/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.tez;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.pig.PigCounters;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.PigStatsUtil;
import org.apache.pig.tools.pigstats.tez.TezDAGStats;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.client.VertexStatus;

public class TezVertexStats
extends JobStats {
    private static final Log LOG = LogFactory.getLog(TezVertexStats.class);
    private boolean isMapOpts;
    private int parallelism;
    private Map<String, Map<String, Long>> counters = null;
    private List<POStore> stores = null;
    private List<FileSpec> loads = null;
    private int numberMaps = 0;
    private int numberReduces = 0;
    private long mapInputRecords = 0L;
    private long mapOutputRecords = 0L;
    private long reduceInputRecords = 0L;
    private long reduceOutputRecords = 0L;
    private long spillCount = 0L;
    private long activeSpillCountObj = 0L;
    private long activeSpillCountRecs = 0L;
    private HashMap<String, Long> multiStoreCounters = new HashMap();

    public TezVertexStats(String name, PigStats.JobGraph plan, boolean isMapOpts) {
        super(name, plan);
        this.isMapOpts = isMapOpts;
    }

    @Override
    public String getJobId() {
        return this.name;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (v instanceof PigStats.JobGraphPrinter) {
            PigStats.JobGraphPrinter jpp = (PigStats.JobGraphPrinter)v;
            jpp.visit(this);
        }
    }

    @Override
    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%1$20s: %2$-100s%n", "VertexName", this.name));
        if (this.getAlias() != null && !this.getAlias().isEmpty()) {
            sb.append(String.format("%1$20s: %2$-100s%n", "Alias", this.getAlias()));
        }
        if (this.getFeature() != null && !this.getFeature().isEmpty()) {
            sb.append(String.format("%1$20s: %2$-100s%n", "Features", this.getFeature()));
        }
        return sb.toString();
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        try {
            this.stores = (List)ObjectSerializer.deserialize(conf.get("pig.reduce.stores"));
            this.loads = (List)ObjectSerializer.deserialize(conf.get("pig.inputs"));
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to deserialize the store list", (Throwable)e);
        }
    }

    public boolean hasLoadOrStore() {
        return this.loads != null && !this.loads.isEmpty() || this.stores != null && !this.stores.isEmpty();
    }

    public void accumulateStats(VertexStatus status, int parallelism) {
        this.hdfsBytesRead = -1L;
        this.hdfsBytesWritten = -1L;
        if (status != null) {
            Map<String, Long> pigCounters;
            this.setSuccessful(status.getState().equals((Object)VertexStatus.State.SUCCEEDED));
            this.parallelism = parallelism;
            if (this.isMapOpts) {
                this.numberMaps += parallelism;
            } else {
                this.numberReduces += parallelism;
            }
            TezCounters tezCounters = status.getVertexCounters();
            this.counters = Maps.newHashMap();
            for (CounterGroup grp : tezCounters) {
                Iterator cntIt = grp.iterator();
                HashMap cntMap = Maps.newHashMap();
                while (cntIt.hasNext()) {
                    TezCounter cnt = (TezCounter)cntIt.next();
                    cntMap.put(cnt.getName(), cnt.getValue());
                }
                this.counters.put(grp.getName(), cntMap);
            }
            if (this.counters.get(TezDAGStats.FS_COUNTER_GROUP) != null && this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_READ") != null) {
                this.hdfsBytesRead = this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_READ");
            }
            if (this.counters.get(TezDAGStats.FS_COUNTER_GROUP) != null && this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_WRITTEN") != null) {
                this.hdfsBytesWritten = this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_WRITTEN");
            }
            if ((pigCounters = this.counters.get(TezDAGStats.PIG_COUNTER_GROUP)) != null) {
                if (pigCounters.containsKey((Object)PigCounters.SPILLABLE_MEMORY_MANAGER_SPILL_COUNT)) {
                    this.spillCount = pigCounters.get((Object)PigCounters.SPILLABLE_MEMORY_MANAGER_SPILL_COUNT);
                }
                if (pigCounters.containsKey((Object)PigCounters.PROACTIVE_SPILL_COUNT_BAGS)) {
                    this.activeSpillCountObj = pigCounters.get((Object)PigCounters.PROACTIVE_SPILL_COUNT_BAGS);
                }
                if (pigCounters.containsKey((Object)PigCounters.PROACTIVE_SPILL_COUNT_RECS)) {
                    this.activeSpillCountRecs = pigCounters.get((Object)PigCounters.PROACTIVE_SPILL_COUNT_RECS);
                }
            }
            this.addInputStatistics();
            this.addOutputStatistics();
        }
    }

    public Map<String, Map<String, Long>> getCounters() {
        return this.counters;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void addInputStatistics() {
        if (this.loads == null) {
            return;
        }
        for (FileSpec fs : this.loads) {
            long records = -1L;
            long hdfsBytesRead = -1L;
            String filename = fs.getFileName();
            if (this.counters != null) {
                Map<String, Long> taskCounter = this.counters.get(TezDAGStats.TASK_COUNTER_GROUP);
                if (taskCounter != null && taskCounter.get(TaskCounter.INPUT_RECORDS_PROCESSED.name()) != null) {
                    records = taskCounter.get(TaskCounter.INPUT_RECORDS_PROCESSED.name());
                    if (this.isMapOpts) {
                        this.mapInputRecords += records;
                    } else {
                        this.reduceInputRecords += records;
                    }
                }
                if (this.counters.get(TezDAGStats.FS_COUNTER_GROUP) != null && this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_READ") != null) {
                    hdfsBytesRead = this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_READ");
                }
            }
            InputStats is = new InputStats(filename, hdfsBytesRead, records, this.state == JobStats.JobState.SUCCESS);
            is.setConf(this.conf);
            this.inputs.add(is);
        }
    }

    public void addOutputStatistics() {
        if (this.stores == null) {
            return;
        }
        for (POStore sto : this.stores) {
            if (sto.isTmpStore()) continue;
            long records = -1L;
            long hdfsBytesWritten = -1L;
            String filename = sto.getSFile().getFileName();
            if (this.counters != null) {
                if (sto.isMultiStore()) {
                    Map<String, Long> msGroup = this.counters.get("MultiStoreCounters");
                    if (msGroup != null) {
                        this.multiStoreCounters.putAll(msGroup);
                        Long n = msGroup.get(PigStatsUtil.getMultiStoreCounterName(sto));
                        if (n != null) {
                            records = n;
                        }
                    }
                } else if (this.counters.get(TezDAGStats.TASK_COUNTER_GROUP) != null && this.counters.get(TezDAGStats.TASK_COUNTER_GROUP).get(TaskCounter.OUTPUT_RECORDS.name()) != null) {
                    records = this.counters.get(TezDAGStats.TASK_COUNTER_GROUP).get(TaskCounter.OUTPUT_RECORDS.name());
                }
                if (records != -1L) {
                    if (this.isMapOpts) {
                        this.mapOutputRecords += records;
                    } else {
                        this.reduceOutputRecords += records;
                    }
                }
            }
            if (!sto.isMultiStore() && this.counters.get(TezDAGStats.FS_COUNTER_GROUP) != null && this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_WRITTEN") != null) {
                hdfsBytesWritten = this.counters.get(TezDAGStats.FS_COUNTER_GROUP).get("HDFS_BYTES_WRITTEN");
            } else {
                try {
                    hdfsBytesWritten = JobStats.getOutputSize(sto, this.conf);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error while getting the bytes written for the output " + sto.getSFile()), (Throwable)e);
                }
            }
            OutputStats os = new OutputStats(filename, hdfsBytesWritten, records, this.state == JobStats.JobState.SUCCESS);
            os.setPOStore(sto);
            os.setConf(this.conf);
            this.outputs.add(os);
        }
    }

    @Override
    @Deprecated
    public int getNumberMaps() {
        return this.numberMaps;
    }

    @Override
    @Deprecated
    public int getNumberReduces() {
        return this.numberReduces;
    }

    @Override
    @Deprecated
    public long getMaxMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMinMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getAvgMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMaxReduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMinReduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getAvgREduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMapInputRecords() {
        return this.mapInputRecords;
    }

    @Override
    @Deprecated
    public long getMapOutputRecords() {
        return this.mapOutputRecords;
    }

    @Override
    @Deprecated
    public long getReduceInputRecords() {
        return this.reduceInputRecords;
    }

    @Override
    @Deprecated
    public long getReduceOutputRecords() {
        return this.reduceOutputRecords;
    }

    @Override
    public long getSMMSpillCount() {
        return this.spillCount;
    }

    @Override
    public long getProactiveSpillCountObjects() {
        return this.activeSpillCountObj;
    }

    @Override
    public long getProactiveSpillCountRecs() {
        return this.activeSpillCountRecs;
    }

    @Override
    @Deprecated
    public Counters getHadoopCounters() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Map<String, Long> getMultiStoreCounters() {
        return this.multiStoreCounters;
    }

    @Override
    @Deprecated
    public Map<String, Long> getMultiInputCounters() {
        throw new UnsupportedOperationException();
    }
}

