/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.TableSorter;
import org.jets3t.gui.skins.SkinsFactory;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;

public class ItemPropertiesDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 7921838316856638675L;
    private static final Log log = LogFactory.getLog(ItemPropertiesDialog.class);
    private Properties applicationProperties = null;
    private SkinsFactory skinsFactory = null;
    private final Insets insetsZero = new Insets(0, 0, 0, 0);
    private final Insets insetsDefault = new Insets(5, 7, 5, 7);
    private final Insets insetsVerticalSpace = new Insets(5, 0, 5, 0);
    private S3Object[] objects = null;
    private int currentObjectIndex = 0;
    private JTextField objectKeyTextField = null;
    private JTextField objectContentTypeTextField = null;
    private JTextField objectContentLengthTextField = null;
    private JTextField objectLastModifiedTextField = null;
    private JTextField objectETagTextField = null;
    private JTextField bucketNameTextField = null;
    private JTextField bucketLocationTextField = null;
    private DefaultTableModel objectMetadataTableModel = null;
    private JTable grantsTable = null;
    private DefaultTableModel grantsTableModel = null;
    private JLabel ownerNameLabel = null;
    private JLabel ownerIdLabel = null;
    private JLabel currentObjectLabel = null;
    private JButton previousObjectButton = null;
    private JButton nextObjectButton = null;
    private JPanel nextPreviousPanel = null;
    private JTextField ownerNameTextField = null;
    private JTextField ownerIdTextField = null;
    private JLabel bucketIsRequesterPaysLabel = null;
    private JCheckBox bucketIsRequesterPaysCheckBox = null;
    private JTextField bucketCreationDateTextField = null;
    private boolean includeMetadata = true;

    protected ItemPropertiesDialog(Frame owner, String title, boolean isObjectDialog, Properties applicationProperties, boolean includeMetadata) {
        super(owner, title, true);
        this.applicationProperties = applicationProperties;
        this.includeMetadata = includeMetadata;
        this.initGui(isObjectDialog);
    }

    private void initGui(boolean isObjectBased) {
        this.skinsFactory = SkinsFactory.getInstance(this.applicationProperties);
        LookAndFeel lookAndFeel = this.skinsFactory.createSkinnedMetalTheme("SkinnedLookAndFeel");
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException e) {
            log.error((Object)"Unable to set skinned LookAndFeel", (Throwable)e);
        }
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        JPanel commonPropertiesContainer = this.skinsFactory.createSkinnedJPanel("ItemPropertiesCommonPanel");
        commonPropertiesContainer.setLayout(new GridBagLayout());
        JPanel metadataContainer = this.skinsFactory.createSkinnedJPanel("ItemPropertiesMetadataPanel");
        metadataContainer.setLayout(new GridBagLayout());
        JPanel grantsContainer = this.skinsFactory.createSkinnedJPanel("ItemPropertiesGrantsPanel");
        grantsContainer.setLayout(new GridBagLayout());
        if (!isObjectBased) {
            JHtmlLabel bucketNameLabel = this.skinsFactory.createSkinnedJHtmlLabel("BucketNameLabel");
            bucketNameLabel.setText("Bucket name:");
            this.bucketNameTextField = this.skinsFactory.createSkinnedJTextField("BucketNameTextField");
            this.bucketNameTextField.setEditable(false);
            JHtmlLabel bucketLocationLabel = this.skinsFactory.createSkinnedJHtmlLabel("BucketLocationLabel");
            bucketLocationLabel.setText("Location:");
            this.bucketLocationTextField = this.skinsFactory.createSkinnedJTextField("BucketLocationTextField");
            this.bucketLocationTextField.setEditable(false);
            JHtmlLabel bucketCreationDateLabel = this.skinsFactory.createSkinnedJHtmlLabel("BucketCreationDateLabel");
            bucketCreationDateLabel.setText("Creation date:");
            this.bucketCreationDateTextField = this.skinsFactory.createSkinnedJTextField("BucketCreationDateTextField");
            this.bucketCreationDateTextField.setEditable(false);
            this.ownerNameLabel = this.skinsFactory.createSkinnedJHtmlLabel("OwnerNameLabel");
            this.ownerNameLabel.setText("Owner name:");
            this.ownerNameTextField = this.skinsFactory.createSkinnedJTextField("OwnerNameTextField");
            this.ownerNameTextField.setEditable(false);
            this.ownerIdLabel = this.skinsFactory.createSkinnedJHtmlLabel("OwnerIdLabel");
            this.ownerIdLabel.setText("Owner ID:");
            this.ownerIdTextField = this.skinsFactory.createSkinnedJTextField("OwnerIdTextField");
            this.ownerIdTextField.setEditable(false);
            this.bucketIsRequesterPaysLabel = this.skinsFactory.createSkinnedJHtmlLabel("BucketIsRequesterPaysLabel");
            this.bucketIsRequesterPaysLabel.setText("Requester Pays?");
            this.bucketIsRequesterPaysCheckBox = this.skinsFactory.createSkinnedJCheckBox("BucketIsRequesterPaysCheckBox");
            this.bucketIsRequesterPaysCheckBox.setEnabled(false);
            int row = 0;
            commonPropertiesContainer.add((Component)bucketNameLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.bucketNameTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)bucketLocationLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.bucketLocationTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)bucketCreationDateLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.bucketCreationDateTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.bucketIsRequesterPaysLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.bucketIsRequesterPaysCheckBox, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.ownerNameLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.ownerNameTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.ownerIdLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.ownerIdTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        } else {
            JHtmlLabel objectKeyLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectKeyLabel");
            objectKeyLabel.setText("Object key:");
            this.objectKeyTextField = this.skinsFactory.createSkinnedJTextField("ObjectKeyTextField");
            this.objectKeyTextField.setEditable(false);
            JHtmlLabel objectContentTypeLabel = this.skinsFactory.createSkinnedJHtmlLabel("ContentTypeLabel");
            objectContentTypeLabel.setText("Content type:");
            this.objectContentTypeTextField = this.skinsFactory.createSkinnedJTextField("ContentTypeTextField");
            this.objectContentTypeTextField.setEditable(false);
            JHtmlLabel objectContentLengthLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectContentLengthLabel");
            objectContentLengthLabel.setText("Size:");
            this.objectContentLengthTextField = this.skinsFactory.createSkinnedJTextField("ObjectContentLengthTextField");
            this.objectContentLengthTextField.setEditable(false);
            JHtmlLabel objectLastModifiedLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectLastModifiedLabel");
            objectLastModifiedLabel.setText("Last modified:");
            this.objectLastModifiedTextField = this.skinsFactory.createSkinnedJTextField("ObjectLastModifiedTextField");
            this.objectLastModifiedTextField.setEditable(false);
            JHtmlLabel objectETagLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectETagLabel");
            objectETagLabel.setText("ETag:");
            this.objectETagTextField = this.skinsFactory.createSkinnedJTextField("ObjectETagTextField");
            this.objectETagTextField.setEditable(false);
            JHtmlLabel bucketNameLabel = this.skinsFactory.createSkinnedJHtmlLabel("BucketNameLabel");
            bucketNameLabel.setText("Bucket name:");
            this.bucketNameTextField = this.skinsFactory.createSkinnedJTextField("BucketNameTextField");
            this.bucketNameTextField.setEditable(false);
            this.ownerNameLabel = this.skinsFactory.createSkinnedJHtmlLabel("OwnerNameLabel");
            this.ownerNameLabel.setText("Owner name:");
            this.ownerNameTextField = this.skinsFactory.createSkinnedJTextField("OwnerNameTextField");
            this.ownerNameTextField.setEditable(false);
            this.ownerIdLabel = this.skinsFactory.createSkinnedJHtmlLabel("OwnerIdLabel");
            this.ownerIdLabel.setText("Owner ID:");
            this.ownerIdTextField = this.skinsFactory.createSkinnedJTextField("OwnerIdTextField");
            this.ownerIdTextField.setEditable(false);
            commonPropertiesContainer.add((Component)objectKeyLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.objectKeyTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)objectContentTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.objectContentTypeTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)objectContentLengthLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.objectContentLengthTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)objectLastModifiedLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.objectLastModifiedTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)objectETagLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.objectETagTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)bucketNameLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.bucketNameTextField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.ownerNameLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.ownerNameTextField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.ownerIdLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
            commonPropertiesContainer.add((Component)this.ownerIdTextField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
            this.objectMetadataTableModel = new DefaultTableModel(new Object[]{"Name", "Value"}, 0){
                private static final long serialVersionUID = -3762866886166776851L;

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            TableSorter metadataTableSorter = new TableSorter(this.objectMetadataTableModel);
            JTable metadataTable = this.skinsFactory.createSkinnedJTable("MetadataTable");
            metadataTable.setModel(metadataTableSorter);
            metadataTableSorter.setTableHeader(metadataTable.getTableHeader());
            metadataContainer.add((Component)new JScrollPane(metadataTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        }
        this.grantsTableModel = new DefaultTableModel(new Object[]{"Grantee", "Permission"}, 0){
            private static final long serialVersionUID = -5882427163845726770L;

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        TableSorter grantsTableSorter = new TableSorter(this.grantsTableModel);
        this.grantsTable = this.skinsFactory.createSkinnedJTable("GrantsTable");
        this.grantsTable.setModel(grantsTableSorter);
        grantsTableSorter.setTableHeader(this.grantsTable.getTableHeader());
        grantsContainer.add((Component)new JScrollPane(this.grantsTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        JButton okButton = this.skinsFactory.createSkinnedJButton("ItemPropertiesOKButton");
        okButton.setText("Finished");
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        int row = 0;
        JPanel container = this.skinsFactory.createSkinnedJPanel("ItemPropertiesPanel");
        container.setLayout(new GridBagLayout());
        container.add((Component)commonPropertiesContainer, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, this.insetsZero, 0, 0));
        if (isObjectBased) {
            if (this.includeMetadata) {
                JHtmlLabel metadataLabel = this.skinsFactory.createSkinnedJHtmlLabel("MetadataLabel");
                metadataLabel.setText("<html><b>Metadata</b></html>");
                metadataLabel.setHorizontalAlignment(0);
                container.add((Component)metadataLabel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, this.insetsVerticalSpace, 0, 0));
                container.add((Component)metadataContainer, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 10, 1, this.insetsZero, 0, 0));
            }
            this.previousObjectButton = this.skinsFactory.createSkinnedJButton("ItemPropertiesPreviousButton");
            this.previousObjectButton.setText("Previous");
            this.previousObjectButton.addActionListener(this);
            this.previousObjectButton.setEnabled(false);
            this.nextObjectButton = this.skinsFactory.createSkinnedJButton("ItemPropertiesNextButton");
            this.nextObjectButton.setText("Next");
            this.nextObjectButton.addActionListener(this);
            this.nextObjectButton.setEnabled(false);
            this.currentObjectLabel = this.skinsFactory.createSkinnedJHtmlLabel("ItemPropertiesCurrentObjectLabel");
            this.currentObjectLabel.setHorizontalAlignment(0);
            this.nextPreviousPanel = this.skinsFactory.createSkinnedJPanel("ItemPropertiesNextPreviousPanel");
            this.nextPreviousPanel.setLayout(new GridBagLayout());
            this.nextPreviousPanel.add((Component)this.previousObjectButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsZero, 0, 0));
            this.nextPreviousPanel.add((Component)this.currentObjectLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, this.insetsZero, 0, 0));
            this.nextPreviousPanel.add((Component)this.nextObjectButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, this.insetsZero, 0, 0));
            container.add((Component)this.nextPreviousPanel, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 10, 2, this.insetsZero, 0, 0));
        } else {
            JHtmlLabel grantsLabel = this.skinsFactory.createSkinnedJHtmlLabel("GrantsLabel");
            grantsLabel.setText("<html><b>Permissions</b></html>");
            grantsLabel.setHorizontalAlignment(0);
            container.add((Component)grantsLabel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, this.insetsVerticalSpace, 0, 0));
            container.add((Component)grantsContainer, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 10, 1, this.insetsZero, 0, 0));
        }
        int n = ++row;
        ++row;
        container.add((Component)okButton, new GridBagConstraints(0, n, 3, 1, 0.0, 0.0, 10, 0, this.insetsZero, 0, 0));
        this.getContentPane().add(container);
        this.pack();
        if (isObjectBased) {
            this.setSize(400, this.includeMetadata ? 550 : 400);
        }
        this.setLocationRelativeTo(this.getOwner());
    }

    private void displayBucketProperties(S3Bucket bucket) {
        this.bucketNameTextField.setText(bucket.getName());
        String location = "Unknown";
        if (bucket.isLocationKnown() && (location = bucket.getLocation()) == null) {
            location = "US";
        }
        this.bucketLocationTextField.setText(location);
        this.bucketCreationDateTextField.setText(String.valueOf(bucket.getCreationDate()));
        if (bucket.getOwner() != null) {
            this.ownerNameLabel.setVisible(true);
            this.ownerNameTextField.setVisible(true);
            this.ownerIdLabel.setVisible(true);
            this.ownerIdTextField.setVisible(true);
            this.ownerNameTextField.setText(bucket.getOwner().getDisplayName());
            this.ownerIdTextField.setText(bucket.getOwner().getId());
        } else {
            this.ownerNameLabel.setVisible(false);
            this.ownerNameTextField.setVisible(false);
            this.ownerIdLabel.setVisible(false);
            this.ownerIdTextField.setVisible(false);
        }
        if (bucket.getAcl() != null) {
            this.grantsTable.setVisible(true);
            while (this.grantsTableModel.getRowCount() > 0) {
                this.grantsTableModel.removeRow(0);
            }
            AccessControlList acl = bucket.getAcl();
            for (GrantAndPermission gap : acl.getGrantAndPermissions()) {
                this.grantsTableModel.addRow(new Object[]{gap.getGrantee().getIdentifier(), gap.getPermission().toString()});
            }
        } else {
            this.grantsTable.setVisible(false);
        }
        if (bucket.isRequesterPaysKnown()) {
            this.bucketIsRequesterPaysLabel.setVisible(true);
            this.bucketIsRequesterPaysCheckBox.setVisible(true);
            this.bucketIsRequesterPaysCheckBox.setSelected(bucket.isRequesterPays());
        } else {
            this.bucketIsRequesterPaysLabel.setVisible(false);
            this.bucketIsRequesterPaysCheckBox.setVisible(false);
        }
        this.pack();
        this.setSize(this.getWidth(), 450);
        this.setLocationRelativeTo(this.getOwner());
    }

    private void displayObjectsProperties(S3Object[] objects) {
        this.objects = objects;
        this.currentObjectIndex = 0;
        this.displayObjectProperties();
    }

    private void displayObjectProperties() {
        S3Object object = this.objects[this.currentObjectIndex];
        if (this.objects.length > 1) {
            this.nextPreviousPanel.setVisible(true);
            this.currentObjectLabel.setText(this.currentObjectIndex + 1 + " of " + this.objects.length);
            this.previousObjectButton.setEnabled(this.currentObjectIndex > 0);
            this.nextObjectButton.setEnabled(this.currentObjectIndex < this.objects.length - 1);
        } else {
            this.nextPreviousPanel.setVisible(false);
        }
        this.objectKeyTextField.setText(object.getKey());
        this.objectContentTypeTextField.setText(object.getContentType());
        this.objectContentLengthTextField.setText(String.valueOf(object.getContentLength()));
        this.objectLastModifiedTextField.setText(String.valueOf(object.getLastModifiedDate()));
        this.objectETagTextField.setText(object.getETag());
        this.bucketNameTextField.setText(object.getBucketName());
        if (object.getOwner() != null) {
            this.ownerNameLabel.setVisible(true);
            this.ownerNameTextField.setVisible(true);
            this.ownerIdLabel.setVisible(true);
            this.ownerIdTextField.setVisible(true);
            this.ownerNameTextField.setText(object.getOwner().getDisplayName());
            this.ownerIdTextField.setText(object.getOwner().getId());
        } else {
            this.ownerNameLabel.setVisible(false);
            this.ownerNameTextField.setVisible(false);
            this.ownerIdLabel.setVisible(false);
            this.ownerIdTextField.setVisible(false);
        }
        while (this.objectMetadataTableModel.getRowCount() > 0) {
            this.objectMetadataTableModel.removeRow(0);
        }
        HashMap<String, Object> objectMetadata = new HashMap<String, Object>(object.getMetadataMap());
        objectMetadata.remove("Content-Length");
        objectMetadata.remove("Content-Type");
        objectMetadata.remove("Date");
        objectMetadata.remove("ETag");
        objectMetadata.remove("Last-Modified");
        objectMetadata.remove("id-2");
        objectMetadata.remove("request-id");
        for (Map.Entry entry : objectMetadata.entrySet()) {
            Object name = entry.getKey();
            Object value = entry.getValue();
            this.objectMetadataTableModel.addRow(new Object[]{name, value});
        }
    }

    public static void showDialog(Frame owner, S3Bucket bucket, Properties applicationProperties) {
        ItemPropertiesDialog dialog = new ItemPropertiesDialog(owner, "Bucket properties", false, applicationProperties, false);
        dialog.displayBucketProperties(bucket);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showDialog(Frame owner, S3Object[] objects, Properties applicationProperties, boolean includeMetadata) {
        ItemPropertiesDialog dialog = new ItemPropertiesDialog(owner, "Object properties", true, applicationProperties, includeMetadata);
        dialog.displayObjectsProperties(objects);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.nextObjectButton)) {
            ++this.currentObjectIndex;
            this.displayObjectProperties();
        } else if (e.getSource().equals(this.previousObjectButton)) {
            --this.currentObjectIndex;
            this.displayObjectProperties();
        } else if ("OK".equals(e.getActionCommand())) {
            this.setVisible(false);
        }
    }
}

