/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage;

import com.microsoft.windowsazure.storage.GeoReplicationStatus;
import com.microsoft.windowsazure.storage.core.Utility;
import java.util.Date;

public class GeoReplicationStats {
    private GeoReplicationStatus status;
    private Date lastSyncTime;

    public static GeoReplicationStatus getGeoReplicationStatus(String geoReplicationStatus) {
        if (geoReplicationStatus != null) {
            if (geoReplicationStatus.equals("unavailable")) {
                return GeoReplicationStatus.UNAVAILABLE;
            }
            if (geoReplicationStatus.equals("live")) {
                return GeoReplicationStatus.LIVE;
            }
            if (geoReplicationStatus.equals("bootstrap")) {
                return GeoReplicationStatus.BOOTSTRAP;
            }
        }
        throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "Null or Invalid geo-replication status in response: %s.", geoReplicationStatus));
    }

    GeoReplicationStats() {
    }

    public Date getLastSyncTime() {
        return this.lastSyncTime;
    }

    public GeoReplicationStatus getStatus() {
        return this.status;
    }

    void setLastSyncTime(Date lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    void setStatus(GeoReplicationStatus status) {
        this.status = status;
    }
}

