/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.LeaseDuration;
import com.microsoft.windowsazure.storage.LeaseState;
import com.microsoft.windowsazure.storage.LeaseStatus;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.blob.BlobContainerAttributes;
import com.microsoft.windowsazure.storage.blob.BlobContainerProperties;
import com.microsoft.windowsazure.storage.blob.BlobProperties;
import com.microsoft.windowsazure.storage.blob.BlobType;
import com.microsoft.windowsazure.storage.blob.BlockEntry;
import com.microsoft.windowsazure.storage.blob.BlockSearchMode;
import com.microsoft.windowsazure.storage.blob.CloudBlob;
import com.microsoft.windowsazure.storage.blob.CloudBlobClient;
import com.microsoft.windowsazure.storage.blob.CloudBlobContainer;
import com.microsoft.windowsazure.storage.blob.CloudBlobDirectory;
import com.microsoft.windowsazure.storage.blob.CloudBlockBlob;
import com.microsoft.windowsazure.storage.blob.CloudPageBlob;
import com.microsoft.windowsazure.storage.blob.CopyState;
import com.microsoft.windowsazure.storage.blob.CopyStatus;
import com.microsoft.windowsazure.storage.blob.ListBlobItem;
import com.microsoft.windowsazure.storage.blob.ListBlobsResponse;
import com.microsoft.windowsazure.storage.blob.PageRange;
import com.microsoft.windowsazure.storage.core.DeserializationHelper;
import com.microsoft.windowsazure.storage.core.ListResponse;
import com.microsoft.windowsazure.storage.core.PathUtility;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class BlobDeserializer {
    public static ListBlobsResponse getBlobList(InputStream stream, CloudBlobClient serviceClient, CloudBlobContainer container) throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(stream);
        ListBlobsResponse blobs = new ListBlobsResponse();
        String tempParseString = null;
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "EnumerationResults");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("MaxResults")) {
                tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "MaxResults");
                blobs.setMaxResults(Integer.parseInt(tempParseString));
                continue;
            }
            if (eventType == 1 && name.equals("Marker")) {
                blobs.setMarker(DeserializationHelper.readElementFromXMLReader(xmlr, "Marker"));
                continue;
            }
            if (eventType == 1 && name.equals("NextMarker")) {
                blobs.setNextMarker(DeserializationHelper.readElementFromXMLReader(xmlr, "NextMarker"));
                continue;
            }
            if (eventType == 1 && name.equals("Prefix")) {
                blobs.setPrefix(DeserializationHelper.readElementFromXMLReader(xmlr, "Prefix"));
                continue;
            }
            if (eventType == 1 && name.equals("Delimiter")) {
                blobs.setDelimiter(DeserializationHelper.readElementFromXMLReader(xmlr, "Delimiter"));
                continue;
            }
            if (eventType == 1 && name.equals("Blobs")) {
                try {
                    blobs.setResults(BlobDeserializer.readBlobItems(xmlr, serviceClient, container));
                }
                catch (URISyntaxException e) {
                    throw new XMLStreamException(e);
                }
                catch (ParseException e) {
                    throw new XMLStreamException(e);
                }
                xmlr.require(2, null, "Blobs");
                continue;
            }
            if (eventType != 2 || !"EnumerationResults".equals(name)) continue;
            break;
        }
        return blobs;
    }

    private static ArrayList<ListBlobItem> readBlobItems(XMLStreamReader xmlr, CloudBlobClient serviceClient, CloudBlobContainer container) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        int eventType = xmlr.getEventType();
        ArrayList<ListBlobItem> retBlobs = new ArrayList<ListBlobItem>();
        xmlr.require(1, null, "Blobs");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType != 1) break;
            if (name.equals("Blob")) {
                retBlobs.add(BlobDeserializer.readBlob(xmlr, serviceClient, container));
                continue;
            }
            if (name.equals("BlobPrefix")) {
                retBlobs.add(BlobDeserializer.readDirectory(xmlr, container));
                continue;
            }
            throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
        }
        xmlr.require(2, null, "Blobs");
        return retBlobs;
    }

    private static CloudBlob readBlob(XMLStreamReader xmlr, CloudBlobClient serviceClient, CloudBlobContainer container) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "Blob");
        String blobName = "";
        String snapshotID = null;
        HashMap<String, String> metadata = null;
        BlobProperties properties = null;
        int eventType = xmlr.getEventType();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Name")) {
                    blobName = DeserializationHelper.readElementFromXMLReader(xmlr, "Name");
                    continue;
                }
                if (name.equals("Snapshot")) {
                    snapshotID = DeserializationHelper.readElementFromXMLReader(xmlr, "Snapshot");
                    continue;
                }
                if (name.equals("Properties")) {
                    properties = BlobDeserializer.readBlobProperties(xmlr);
                    xmlr.require(2, null, "Properties");
                    continue;
                }
                if (!name.equals("Metadata")) continue;
                metadata = DeserializationHelper.parseMetadateFromXML(xmlr);
                xmlr.require(2, null, "Metadata");
                continue;
            }
            if (eventType != 2 || !name.equals("Blob")) continue;
            break;
        }
        xmlr.require(2, null, "Blob");
        if (properties != null) {
            CloudBlob retBlob = null;
            StorageUri blobUri = serviceClient.getStorageUri();
            blobUri = PathUtility.appendPathToUri(blobUri, container.getName());
            blobUri = PathUtility.appendPathToUri(blobUri, blobName);
            if (properties.getBlobType() == BlobType.BLOCK_BLOB) {
                retBlob = new CloudBlockBlob(blobUri, serviceClient, container);
            } else if (properties.getBlobType() == BlobType.PAGE_BLOB) {
                retBlob = new CloudPageBlob(blobUri, serviceClient, container);
            } else {
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            retBlob.setStorageUri(blobUri);
            retBlob.snapshotID = snapshotID;
            retBlob.properties = properties;
            retBlob.metadata = metadata;
            return retBlob;
        }
        throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
    }

    private static CloudBlobDirectory readDirectory(XMLStreamReader xmlr, CloudBlobContainer container) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "BlobPrefix");
        xmlr.next();
        xmlr.require(1, null, "Name");
        String prefixName = DeserializationHelper.readElementFromXMLReader(xmlr, "Name");
        xmlr.next();
        xmlr.require(2, null, "BlobPrefix");
        return container.getDirectoryReference(prefixName);
    }

    private static BlobProperties readBlobProperties(XMLStreamReader xmlr) throws XMLStreamException, ParseException, StorageException, URISyntaxException {
        xmlr.require(1, null, "Properties");
        int eventType = xmlr.getEventType();
        BlobProperties properties = new BlobProperties();
        CopyState copyState = null;
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                String[] progressSequence;
                String tempString;
                if (name.equals("Last-Modified")) {
                    properties.setLastModified(Utility.parseRFC1123DateFromStringInGMT(DeserializationHelper.readElementFromXMLReader(xmlr, "Last-Modified")));
                    continue;
                }
                if (name.equals("Etag")) {
                    properties.setEtag(DeserializationHelper.readETagFromXMLReader(xmlr));
                    continue;
                }
                if (name.equals("Content-Length")) {
                    tempString = DeserializationHelper.readElementFromXMLReader(xmlr, "Content-Length");
                    properties.setLength(Long.parseLong(tempString));
                    continue;
                }
                if (name.equals("Content-Type")) {
                    properties.setContentType(DeserializationHelper.readElementFromXMLReader(xmlr, "Content-Type"));
                    continue;
                }
                if (name.equals("Content-Encoding")) {
                    properties.setContentEncoding(DeserializationHelper.readElementFromXMLReader(xmlr, "Content-Encoding"));
                    continue;
                }
                if (name.equals("Content-Language")) {
                    properties.setContentLanguage(DeserializationHelper.readElementFromXMLReader(xmlr, "Content-Language"));
                    continue;
                }
                if (name.equals("Content-MD5")) {
                    properties.setContentMD5(DeserializationHelper.readElementFromXMLReader(xmlr, "Content-MD5"));
                    continue;
                }
                if (name.equals("Cache-Control")) {
                    properties.setCacheControl(DeserializationHelper.readElementFromXMLReader(xmlr, "Cache-Control"));
                    continue;
                }
                if (name.equals("Content-Disposition")) {
                    properties.setContentDisposition(DeserializationHelper.readElementFromXMLReader(xmlr, "Content-Disposition"));
                    continue;
                }
                if (name.equals("x-ms-blob-sequence-number")) {
                    DeserializationHelper.readElementFromXMLReader(xmlr, "x-ms-blob-sequence-number");
                    continue;
                }
                if (name.equals("BlobType")) {
                    tempString = DeserializationHelper.readElementFromXMLReader(xmlr, "BlobType");
                    if (tempString.equals("BlockBlob")) {
                        properties.setBlobType(BlobType.BLOCK_BLOB);
                        continue;
                    }
                    if (tempString.equals("PageBlob")) {
                        properties.setBlobType(BlobType.PAGE_BLOB);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (name.equals("LeaseStatus")) {
                    LeaseStatus tempStatus = LeaseStatus.parse(DeserializationHelper.readElementFromXMLReader(xmlr, "LeaseStatus"));
                    if (!tempStatus.equals((Object)LeaseStatus.UNSPECIFIED)) {
                        properties.setLeaseStatus(tempStatus);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (name.equals("LeaseState")) {
                    LeaseState tempState = LeaseState.parse(DeserializationHelper.readElementFromXMLReader(xmlr, "LeaseState"));
                    if (!tempState.equals((Object)LeaseState.UNSPECIFIED)) {
                        properties.setLeaseState(tempState);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (name.equals("LeaseDuration")) {
                    LeaseDuration tempDuration = LeaseDuration.parse(DeserializationHelper.readElementFromXMLReader(xmlr, "LeaseDuration"));
                    if (!tempDuration.equals((Object)LeaseDuration.UNSPECIFIED)) {
                        properties.setLeaseDuration(tempDuration);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (name.equals("CopyId")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setCopyId(DeserializationHelper.readElementFromXMLReader(xmlr, "CopyId"));
                    continue;
                }
                if (name.equals("CopyCompletionTime")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(DeserializationHelper.readElementFromXMLReader(xmlr, "CopyCompletionTime")));
                    continue;
                }
                if (name.equals("CopyStatus")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setStatus(CopyStatus.parse(DeserializationHelper.readElementFromXMLReader(xmlr, "CopyStatus")));
                    continue;
                }
                if (name.equals("CopySource")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setSource(new URI(DeserializationHelper.readElementFromXMLReader(xmlr, "CopySource")));
                    continue;
                }
                if (name.equals("CopyProgress")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    tempString = DeserializationHelper.readElementFromXMLReader(xmlr, "CopyProgress");
                    progressSequence = tempString.split("/");
                    copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
                    copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
                    continue;
                }
                if (name.equals("CopyStatusDescription")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setStatusDescription(DeserializationHelper.readElementFromXMLReader(xmlr, "CopyStatusDescription"));
                    continue;
                }
                if (name.equals("CopyId")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setCopyId(DeserializationHelper.readElementFromXMLReader(xmlr, "CopyId"));
                    continue;
                }
                if (name.equals("CopyCompletionTime")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(DeserializationHelper.readElementFromXMLReader(xmlr, "CopyCompletionTime")));
                    continue;
                }
                if (name.equals("CopyStatus")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setStatus(CopyStatus.parse(DeserializationHelper.readElementFromXMLReader(xmlr, "CopyStatus")));
                    continue;
                }
                if (name.equals("CopySource")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setSource(new URI(DeserializationHelper.readElementFromXMLReader(xmlr, "CopySource")));
                    continue;
                }
                if (name.equals("CopyProgress")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    tempString = DeserializationHelper.readElementFromXMLReader(xmlr, "CopyProgress");
                    progressSequence = tempString.split("/");
                    copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
                    copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
                    continue;
                }
                if (!name.equals("CopyStatusDescription")) continue;
                if (copyState == null) {
                    copyState = new CopyState();
                }
                copyState.setStatusDescription(DeserializationHelper.readElementFromXMLReader(xmlr, "CopyStatusDescription"));
                continue;
            }
            if (eventType != 2) continue;
            xmlr.require(2, null, "Properties");
            break;
        }
        properties.setCopyState(copyState);
        return properties;
    }

    public static ListResponse<CloudBlobContainer> getContainerList(InputStream stream, CloudBlobClient serviceClient) throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(stream);
        ListResponse<CloudBlobContainer> containers = new ListResponse<CloudBlobContainer>();
        String tempParseString = null;
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "EnumerationResults");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("MaxResults")) {
                tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "MaxResults");
                containers.setMaxResults(Integer.parseInt(tempParseString));
                continue;
            }
            if (eventType == 1 && name.equals("Marker")) {
                containers.setMarker(DeserializationHelper.readElementFromXMLReader(xmlr, "Marker"));
                continue;
            }
            if (eventType == 1 && name.equals("NextMarker")) {
                containers.setNextMarker(DeserializationHelper.readElementFromXMLReader(xmlr, "NextMarker"));
                continue;
            }
            if (eventType == 1 && name.equals("Prefix")) {
                containers.setPrefix(DeserializationHelper.readElementFromXMLReader(xmlr, "Prefix"));
                continue;
            }
            if (eventType == 1 && name.equals("Containers")) {
                try {
                    containers.setResults(BlobDeserializer.readContainers(xmlr, serviceClient));
                }
                catch (URISyntaxException e) {
                    throw new XMLStreamException(e);
                }
                catch (ParseException e) {
                    throw new XMLStreamException(e);
                }
                xmlr.require(2, null, "Containers");
                continue;
            }
            if (eventType != 2 || !"EnumerationResults".equals(name)) continue;
            break;
        }
        return containers;
    }

    private static CloudBlobContainer readContainer(XMLStreamReader xmlr, CloudBlobClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "Container");
        BlobContainerAttributes attributes = BlobDeserializer.readBlobContainerAttributes(xmlr);
        StorageUri containerUri = serviceClient.getStorageUri();
        containerUri = PathUtility.appendPathToUri(containerUri, attributes.getName());
        attributes.setStorageUri(containerUri);
        CloudBlobContainer retContainer = new CloudBlobContainer(attributes.getStorageUri(), serviceClient);
        retContainer.setMetadata(attributes.getMetadata());
        retContainer.setName(attributes.getName());
        retContainer.setProperties(attributes.getProperties());
        retContainer.setStorageUri(attributes.getStorageUri());
        xmlr.require(2, null, "Container");
        return retContainer;
    }

    private static BlobContainerAttributes readBlobContainerAttributes(XMLStreamReader xmlr) throws XMLStreamException, ParseException, URISyntaxException {
        int eventType = xmlr.getEventType();
        BlobContainerAttributes attributes = new BlobContainerAttributes();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Name")) {
                    attributes.setName(DeserializationHelper.readElementFromXMLReader(xmlr, "Name"));
                    continue;
                }
                if (name.equals("Properties")) {
                    attributes.setProperties(BlobDeserializer.readBlobContainerProperties(xmlr));
                    xmlr.require(2, null, "Properties");
                    continue;
                }
                if (!name.equals("Metadata")) continue;
                attributes.setMetadata(DeserializationHelper.parseMetadateFromXML(xmlr));
                xmlr.require(2, null, "Metadata");
                continue;
            }
            if (eventType != 2 || !name.equals("Container")) continue;
            break;
        }
        return attributes;
    }

    private static BlobContainerProperties readBlobContainerProperties(XMLStreamReader xmlr) throws XMLStreamException, ParseException {
        xmlr.require(1, null, "Properties");
        int eventType = xmlr.getEventType();
        BlobContainerProperties properties = new BlobContainerProperties();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Last-Modified")) {
                    properties.setLastModified(Utility.parseRFC1123DateFromStringInGMT(DeserializationHelper.readElementFromXMLReader(xmlr, "Last-Modified")));
                    continue;
                }
                if (name.equals("Etag")) {
                    properties.setEtag(DeserializationHelper.readETagFromXMLReader(xmlr));
                    continue;
                }
                if (name.equals("LeaseStatus")) {
                    properties.setLeaseStatus(LeaseStatus.parse(DeserializationHelper.readElementFromXMLReader(xmlr, "LeaseStatus")));
                    continue;
                }
                if (name.equals("LeaseState")) {
                    properties.setLeaseState(LeaseState.parse(DeserializationHelper.readElementFromXMLReader(xmlr, "LeaseState")));
                    continue;
                }
                if (!name.equals("LeaseDuration")) continue;
                properties.setLeaseDuration(LeaseDuration.parse(DeserializationHelper.readElementFromXMLReader(xmlr, "LeaseDuration")));
                continue;
            }
            xmlr.require(2, null, "Properties");
            break;
        }
        return properties;
    }

    private static ArrayList<CloudBlobContainer> readContainers(XMLStreamReader xmlr, CloudBlobClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "Containers");
        ArrayList<CloudBlobContainer> containers = new ArrayList<CloudBlobContainer>();
        eventType = xmlr.next();
        while (eventType == 1 && xmlr.hasName() && "Container".equals(xmlr.getName().toString())) {
            containers.add(BlobDeserializer.readContainer(xmlr, serviceClient));
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "Containers");
        return containers;
    }

    public static ArrayList<BlockEntry> getBlockList(InputStream streamRef) throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(streamRef);
        ArrayList<BlockEntry> blocks = new ArrayList<BlockEntry>();
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "BlockList");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (name.equals("CommittedBlocks")) {
                eventType = xmlr.next();
                if (eventType != 1 || !"Block".equals(xmlr.getName().toString())) continue;
                blocks.addAll(BlobDeserializer.readBlobBlocks(xmlr, BlockSearchMode.COMMITTED));
                xmlr.require(2, null, "CommittedBlocks");
                continue;
            }
            if (name.equals("UncommittedBlocks")) {
                eventType = xmlr.next();
                if (eventType != 1 || !"Block".equals(xmlr.getName().toString())) continue;
                blocks.addAll(BlobDeserializer.readBlobBlocks(xmlr, BlockSearchMode.UNCOMMITTED));
                xmlr.require(2, null, "UncommittedBlocks");
                continue;
            }
            if (name.equals("BlockList") && eventType == 2) break;
            throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
        }
        return blocks;
    }

    private static ArrayList<BlockEntry> readBlobBlocks(XMLStreamReader xmlr, BlockSearchMode searchMode) throws XMLStreamException, StorageException {
        int eventType = xmlr.getEventType();
        ArrayList<BlockEntry> retBlocks = new ArrayList<BlockEntry>();
        xmlr.require(1, null, "Block");
        while (xmlr.hasNext() && "Block".equals(xmlr.getName().toString())) {
            String blockName = null;
            long blockSize = -1L;
            while (xmlr.hasNext()) {
                eventType = xmlr.next();
                String name = xmlr.getName().toString();
                if (eventType == 1) {
                    if (name.equals("Name")) {
                        blockName = DeserializationHelper.readElementFromXMLReader(xmlr, "Name");
                        continue;
                    }
                    if (name.equals("Size")) {
                        String sizeString = DeserializationHelper.readElementFromXMLReader(xmlr, "Size");
                        blockSize = Long.parseLong(sizeString);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (eventType != 2) continue;
                BlockEntry newBlock = new BlockEntry(blockName, searchMode);
                newBlock.setSize(blockSize);
                retBlocks.add(newBlock);
                break;
            }
            eventType = xmlr.next();
        }
        return retBlocks;
    }

    public static ArrayList<PageRange> getPageRanges(InputStream streamRef) throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(streamRef);
        ArrayList<PageRange> pageRanges = new ArrayList<PageRange>();
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "PageList");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (name.equals("PageRange")) {
                pageRanges = BlobDeserializer.readPageRanges(xmlr);
                continue;
            }
            if (name.equals("PageList") && eventType == 2) break;
            throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
        }
        return pageRanges;
    }

    private static ArrayList<PageRange> readPageRanges(XMLStreamReader xmlr) throws XMLStreamException, StorageException {
        int eventType = xmlr.getEventType();
        ArrayList<PageRange> retRanges = new ArrayList<PageRange>();
        xmlr.require(1, null, "PageRange");
        while (xmlr.hasNext() && "PageRange".equals(xmlr.getName().toString())) {
            long startOffset = -1L;
            long endOffset = -1L;
            while (xmlr.hasNext()) {
                eventType = xmlr.next();
                String name = xmlr.getName().toString();
                if (eventType == 1) {
                    String sizeString;
                    if (name.equals("Start")) {
                        sizeString = DeserializationHelper.readElementFromXMLReader(xmlr, "Start");
                        startOffset = Long.parseLong(sizeString);
                        continue;
                    }
                    if (name.equals("End")) {
                        sizeString = DeserializationHelper.readElementFromXMLReader(xmlr, "End");
                        endOffset = Long.parseLong(sizeString);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (eventType != 2) continue;
                if (startOffset == -1L || endOffset == -1L) {
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                PageRange pageRef = new PageRange(startOffset, endOffset);
                retRanges.add(pageRef);
                break;
            }
            eventType = xmlr.next();
        }
        return retRanges;
    }
}

