/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.BlobContainerAttributes;
import com.microsoft.windowsazure.storage.blob.BlobContainerProperties;
import com.microsoft.windowsazure.storage.core.BaseResponse;
import com.microsoft.windowsazure.storage.core.PathUtility;
import com.microsoft.windowsazure.storage.core.Utility;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;

final class ContainerResponse
extends BaseResponse {
    ContainerResponse() {
    }

    public static String getAcl(HttpURLConnection request) {
        return request.getHeaderField("x-ms-blob-public-access");
    }

    public static BlobContainerAttributes getAttributes(HttpURLConnection request, boolean usePathStyleUris) throws StorageException {
        URI tempURI;
        BlobContainerAttributes containerAttributes = new BlobContainerAttributes();
        try {
            tempURI = PathUtility.stripSingleURIQueryAndFragment(request.getURL().toURI());
        }
        catch (URISyntaxException e) {
            StorageException wrappedUnexpectedException = Utility.generateNewUnexpectedStorageException(e);
            throw wrappedUnexpectedException;
        }
        containerAttributes.setName(PathUtility.getContainerNameFromUri(tempURI, usePathStyleUris));
        BlobContainerProperties containerProperties = containerAttributes.getProperties();
        containerProperties.setEtag(BaseResponse.getEtag(request));
        containerProperties.setLastModified(new Date(request.getLastModified()));
        containerAttributes.setMetadata(ContainerResponse.getMetadata(request));
        containerProperties.setLeaseStatus(BaseResponse.getLeaseStatus(request));
        containerProperties.setLeaseState(BaseResponse.getLeaseState(request));
        containerProperties.setLeaseDuration(BaseResponse.getLeaseDuration(request));
        return containerAttributes;
    }
}

