/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.core.Canonicalizer;
import com.microsoft.windowsazure.storage.core.Utility;
import java.net.HttpURLConnection;
import java.security.InvalidParameterException;

final class BlobQueueFullCanonicalizer
extends Canonicalizer {
    BlobQueueFullCanonicalizer() {
    }

    @Override
    protected String canonicalize(HttpURLConnection conn, String accountName, Long contentLength) throws StorageException {
        if (contentLength < -1L) {
            throw new InvalidParameterException("ContentLength must be set to -1 or positive Long value.");
        }
        return BlobQueueFullCanonicalizer.canonicalizeHttpRequest(conn.getURL(), accountName, conn.getRequestMethod(), Utility.getStandardHeaderValue(conn, "Content-Type"), contentLength, null, conn);
    }
}

