/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.ServiceClient;
import com.microsoft.windowsazure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.SharedAccessBlobHeaders;
import com.microsoft.windowsazure.storage.blob.SharedAccessBlobPolicy;
import com.microsoft.windowsazure.storage.core.SharedAccessPolicy;
import com.microsoft.windowsazure.storage.core.UriQueryBuilder;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.queue.SharedAccessQueuePolicy;
import com.microsoft.windowsazure.storage.table.SharedAccessTablePolicy;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SharedAccessSignatureHelper {
    public static UriQueryBuilder generateSharedAccessSignatureForBlob(SharedAccessBlobPolicy policy, SharedAccessBlobHeaders headers, String groupPolicyIdentifier, String resourceType, String signature) throws StorageException {
        Utility.assertNotNullOrEmpty("resourceType", resourceType);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, null, null, null, null, groupPolicyIdentifier, resourceType, null, signature, null, headers);
    }

    public static UriQueryBuilder generateSharedAccessSignatureForQueue(SharedAccessQueuePolicy policy, String groupPolicyIdentifier, String signature) throws StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, null, null, null, null, groupPolicyIdentifier, null, null, signature, null, null);
    }

    public static UriQueryBuilder generateSharedAccessSignatureForTable(SharedAccessTablePolicy policy, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, String accessPolicyIdentifier, String tableName, String signature, String accountKeyName) throws StorageException {
        Utility.assertNotNull("tableName", tableName);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, startPartitionKey, startRowKey, endPartitionKey, endRowKey, accessPolicyIdentifier, null, tableName, signature, accountKeyName, null);
    }

    public static String generateSharedAccessSignatureHashForBlob(SharedAccessBlobPolicy policy, SharedAccessBlobHeaders headers, String accessPolicyIdentifier, String resourceName, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashForBlob((SharedAccessPolicy)policy, resourceName, accessPolicyIdentifier, client, opContext, headers);
    }

    public static String generateSharedAccessSignatureHashForQueue(SharedAccessQueuePolicy policy, String accessPolicyIdentifier, String resourceName, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashForQueueAndTable(policy, resourceName, accessPolicyIdentifier, false, null, null, null, null, client, opContext);
    }

    public static String generateSharedAccessSignatureHashForTable(SharedAccessTablePolicy policy, String accessPolicyIdentifier, String resourceName, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashForQueueAndTable(policy, resourceName, accessPolicyIdentifier, true, startPartitionKey, startRowKey, endPartitionKey, endRowKey, client, opContext);
    }

    public static StorageCredentialsSharedAccessSignature parseQuery(HashMap<String, String[]> queryParams) throws StorageException {
        String signature = null;
        String signedStart = null;
        String signedExpiry = null;
        String signedResource = null;
        String signedPermissions = null;
        String signedIdentifier = null;
        String signedVersion = null;
        String cacheControl = null;
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentDisposition = null;
        boolean sasParameterFound = false;
        StorageCredentialsSharedAccessSignature credentials = null;
        for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
            String lowerKey = entry.getKey().toLowerCase(Utility.LOCALE_US);
            if (lowerKey.equals("st")) {
                signedStart = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("se")) {
                signedExpiry = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sp")) {
                signedPermissions = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sr")) {
                signedResource = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("si")) {
                signedIdentifier = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sig")) {
                signature = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("sv")) {
                signedVersion = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("rscc")) {
                cacheControl = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("rsct")) {
                contentType = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("rsce")) {
                contentEncoding = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("rscl")) {
                contentLanguage = entry.getValue()[0];
                sasParameterFound = true;
                continue;
            }
            if (!lowerKey.equals("rscd")) continue;
            contentDisposition = entry.getValue()[0];
            sasParameterFound = true;
        }
        if (sasParameterFound) {
            if (signature == null) {
                String errorMessage = "Missing mandatory parameters for valid Shared Access Signature.";
                throw new IllegalArgumentException("Missing mandatory parameters for valid Shared Access Signature.");
            }
            UriQueryBuilder builder = new UriQueryBuilder();
            if (!Utility.isNullOrEmpty(signedStart)) {
                builder.add("st", signedStart);
            }
            if (!Utility.isNullOrEmpty(signedExpiry)) {
                builder.add("se", signedExpiry);
            }
            if (!Utility.isNullOrEmpty(signedPermissions)) {
                builder.add("sp", signedPermissions);
            }
            if (!Utility.isNullOrEmpty(signedResource)) {
                builder.add("sr", signedResource);
            }
            if (!Utility.isNullOrEmpty(signedIdentifier)) {
                builder.add("si", signedIdentifier);
            }
            if (!Utility.isNullOrEmpty(signedVersion)) {
                builder.add("sv", signedVersion);
            }
            if (!Utility.isNullOrEmpty(signature)) {
                builder.add("sig", signature);
            }
            if (!Utility.isNullOrEmpty(cacheControl)) {
                builder.add("rscc", cacheControl);
            }
            if (!Utility.isNullOrEmpty(contentType)) {
                builder.add("rsct", contentType);
            }
            if (!Utility.isNullOrEmpty(contentEncoding)) {
                builder.add("rsce", contentEncoding);
            }
            if (!Utility.isNullOrEmpty(contentLanguage)) {
                builder.add("rscl", contentLanguage);
            }
            if (!Utility.isNullOrEmpty(contentDisposition)) {
                builder.add("rscd", contentDisposition);
            }
            String token = builder.toString();
            credentials = new StorageCredentialsSharedAccessSignature(token);
        }
        return credentials;
    }

    private static UriQueryBuilder generateSharedAccessSignatureHelper(SharedAccessPolicy policy, String startPatitionKey, String startRowKey, String endPatitionKey, String endRowKey, String accessPolicyIdentifier, String resourceType, String tableName, String signature, String accountKeyName, SharedAccessBlobHeaders headers) throws StorageException {
        String stopString;
        String startString;
        Utility.assertNotNull("signature", signature);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("sv", "2013-08-15");
        if (!Utility.isNullOrEmpty(permissions)) {
            builder.add("sp", permissions);
        }
        if (!Utility.isNullOrEmpty(startString = Utility.getUTCTimeOrEmpty(startTime))) {
            builder.add("st", startString);
        }
        if (!Utility.isNullOrEmpty(stopString = Utility.getUTCTimeOrEmpty(expiryTime))) {
            builder.add("se", stopString);
        }
        if (!Utility.isNullOrEmpty(startPatitionKey)) {
            builder.add("spk", startPatitionKey);
        }
        if (!Utility.isNullOrEmpty(startRowKey)) {
            builder.add("srk", startRowKey);
        }
        if (!Utility.isNullOrEmpty(endPatitionKey)) {
            builder.add("epk", endPatitionKey);
        }
        if (!Utility.isNullOrEmpty(endRowKey)) {
            builder.add("erk", endRowKey);
        }
        if (!Utility.isNullOrEmpty(accessPolicyIdentifier)) {
            builder.add("si", accessPolicyIdentifier);
        }
        if (!Utility.isNullOrEmpty(resourceType)) {
            builder.add("sr", resourceType);
        }
        if (!Utility.isNullOrEmpty(tableName)) {
            builder.add("tn", tableName);
        }
        if (headers != null) {
            if (!Utility.isNullOrEmpty(headers.getCacheControl())) {
                builder.add("rscc", headers.getCacheControl());
            }
            if (!Utility.isNullOrEmpty(headers.getContentType())) {
                builder.add("rsct", headers.getContentType());
            }
            if (!Utility.isNullOrEmpty(headers.getContentEncoding())) {
                builder.add("rsce", headers.getContentEncoding());
            }
            if (!Utility.isNullOrEmpty(headers.getContentLanguage())) {
                builder.add("rscl", headers.getContentLanguage());
            }
            if (!Utility.isNullOrEmpty(headers.getContentDisposition())) {
                builder.add("rscd", headers.getContentDisposition());
            }
        }
        if (!Utility.isNullOrEmpty(signature)) {
            builder.add("sig", signature);
        }
        if (!Utility.isNullOrEmpty(accountKeyName)) {
            builder.add("sk", accountKeyName);
        }
        return builder;
    }

    private static String generateSharedAccessSignatureHashForBlob(SharedAccessPolicy policy, String resourceName, String accessPolicyIdentifier, ServiceClient client, OperationContext opContext, SharedAccessBlobHeaders headers) throws InvalidKeyException, StorageException {
        Utility.assertNotNullOrEmpty("resourceName", resourceName);
        Utility.assertNotNull("client", client);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        String cacheControl = null;
        String contentDisposition = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentType = null;
        if (headers != null) {
            cacheControl = headers.getCacheControl();
            contentDisposition = headers.getContentDisposition();
            contentEncoding = headers.getContentEncoding();
            contentLanguage = headers.getContentLanguage();
            contentType = headers.getContentType();
        }
        String stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s", permissions == null ? "" : permissions, Utility.getUTCTimeOrEmpty(startTime), Utility.getUTCTimeOrEmpty(expiryTime), resourceName, accessPolicyIdentifier == null ? "" : accessPolicyIdentifier, "2013-08-15", cacheControl == null ? "" : cacheControl, contentDisposition == null ? "" : contentDisposition, contentEncoding == null ? "" : contentEncoding, contentLanguage == null ? "" : contentLanguage, contentType == null ? "" : contentType);
        stringToSign = Utility.safeDecode(stringToSign);
        String signature = client.getCredentials().computeHmac256(stringToSign, opContext);
        return signature;
    }

    private static String generateSharedAccessSignatureHashForQueueAndTable(SharedAccessPolicy policy, String resourceName, String accessPolicyIdentifier, boolean useTableSas, String startPatitionKey, String startRowKey, String endPatitionKey, String endRowKey, ServiceClient client, OperationContext opContext) throws InvalidKeyException, StorageException {
        Utility.assertNotNullOrEmpty("resourceName", resourceName);
        Utility.assertNotNull("client", client);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        String stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s", permissions == null ? "" : permissions, Utility.getUTCTimeOrEmpty(startTime), Utility.getUTCTimeOrEmpty(expiryTime), resourceName, accessPolicyIdentifier == null ? "" : accessPolicyIdentifier, "2013-08-15");
        if (useTableSas) {
            stringToSign = String.format("%s\n%s\n%s\n%s\n%s", stringToSign, startPatitionKey == null ? "" : startPatitionKey, startRowKey == null ? "" : startRowKey, endPatitionKey == null ? "" : endPatitionKey, endRowKey == null ? "" : endRowKey);
        }
        stringToSign = Utility.safeDecode(stringToSign);
        String signature = client.getCredentials().computeHmac256(stringToSign, opContext);
        return signature;
    }

    private SharedAccessSignatureHelper() {
    }
}

