/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.core.PathUtility;
import com.microsoft.windowsazure.storage.core.Utility;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class UriQueryBuilder {
    private final HashMap<String, ArrayList<String>> parameters = new HashMap();

    public void add(String name, String value) throws StorageException {
        if (Utility.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("Cannot encode a query parameter with a null or empty key.");
        }
        this.insertKeyValue(name, value);
    }

    public URI addToURI(URI uri) throws URISyntaxException, StorageException {
        String origRawQuery = uri.getRawQuery();
        String rawFragment = uri.getRawFragment();
        String uriString = uri.resolve(uri).toASCIIString();
        HashMap<String, String[]> origQueryMap = PathUtility.parseQueryString(origRawQuery);
        for (Map.Entry<String, String[]> entry : origQueryMap.entrySet()) {
            for (String val : entry.getValue()) {
                this.insertKeyValue(entry.getKey(), val);
            }
        }
        StringBuilder retBuilder = new StringBuilder();
        if (Utility.isNullOrEmpty(origRawQuery) && !Utility.isNullOrEmpty(rawFragment)) {
            int bangDex = uriString.indexOf(35);
            retBuilder.append(uriString.substring(0, bangDex));
        } else if (!Utility.isNullOrEmpty(origRawQuery)) {
            int queryDex = uriString.indexOf(63);
            retBuilder.append(uriString.substring(0, queryDex));
        } else {
            retBuilder.append(uriString);
            if (uri.getRawPath().length() <= 0) {
                retBuilder.append("/");
            }
        }
        String finalQuery = this.toString();
        if (finalQuery.length() > 0) {
            retBuilder.append("?");
            retBuilder.append(finalQuery);
        }
        if (!Utility.isNullOrEmpty(rawFragment)) {
            retBuilder.append("#");
            retBuilder.append(rawFragment);
        }
        return new URI(retBuilder.toString());
    }

    private void insertKeyValue(String key, String value) throws StorageException {
        ArrayList<String> list;
        if (value != null) {
            value = Utility.safeEncode(value);
        }
        if (!key.startsWith("$")) {
            key = Utility.safeEncode(key);
        }
        if ((list = this.parameters.get(key)) == null) {
            list = new ArrayList();
            list.add(value);
            this.parameters.put(key, list);
        } else if (!list.contains(value)) {
            list.add(value);
        }
    }

    public String toString() {
        StringBuilder outString = new StringBuilder();
        Boolean isFirstPair = true;
        for (String key : this.parameters.keySet()) {
            if (this.parameters.get(key) == null) continue;
            for (String val : this.parameters.get(key)) {
                if (isFirstPair.booleanValue()) {
                    isFirstPair = false;
                } else {
                    outString.append("&");
                }
                outString.append(String.format("%s=%s", key, val));
            }
        }
        return outString.toString();
    }
}

