/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.table;

import com.microsoft.windowsazure.storage.RequestOptions;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.table.CloudTableClient;
import com.microsoft.windowsazure.storage.table.EdmType;
import com.microsoft.windowsazure.storage.table.TablePayloadFormat;

public class TableRequestOptions
extends RequestOptions {
    private PropertyResolver propertyResolver;
    private TablePayloadFormat payloadFormat;

    public TableRequestOptions() {
    }

    public TableRequestOptions(TableRequestOptions other) {
        super(other);
        if (other != null) {
            this.setTablePayloadFormat(other.getTablePayloadFormat());
            this.setPropertyResolver(other.getPropertyResolver());
        }
    }

    protected static final TableRequestOptions applyDefaults(TableRequestOptions options, CloudTableClient client) {
        TableRequestOptions modifiedOptions = new TableRequestOptions(options);
        return TableRequestOptions.applyDefaultsInternal(modifiedOptions, client);
    }

    protected static final TableRequestOptions applyDefaultsInternal(TableRequestOptions modifiedOptions, CloudTableClient client) {
        Utility.assertNotNull("modifiedOptions", modifiedOptions);
        RequestOptions.applyBaseDefaultsInternal(modifiedOptions, client);
        if (modifiedOptions.getTablePayloadFormat() == null) {
            modifiedOptions.setTablePayloadFormat(client.getTablePayloadFormat());
        }
        return modifiedOptions;
    }

    public TablePayloadFormat getTablePayloadFormat() {
        return this.payloadFormat;
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public void setTablePayloadFormat(TablePayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public static interface PropertyResolver {
        public EdmType propertyResolver(String var1, String var2, String var3, String var4);
    }
}

