/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.metrics.FileCacheMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheService {
    private static final Logger logger = LoggerFactory.getLogger(FileCacheService.class);
    private static final long MEMORY_USAGE_THRESHOLD = (long)DatabaseDescriptor.getFileCacheSizeInMB() * 1024L * 1024L;
    private static final int AFTER_ACCESS_EXPIRATION = 512;
    public static FileCacheService instance = new FileCacheService();
    private static final Callable<Queue<RandomAccessReader>> cacheForPathCreator = new Callable<Queue<RandomAccessReader>>(){

        @Override
        public Queue<RandomAccessReader> call() {
            return new ConcurrentLinkedQueue<RandomAccessReader>();
        }
    };
    private static final AtomicInteger memoryUsage = new AtomicInteger();
    private final Cache<String, Queue<RandomAccessReader>> cache;
    private final FileCacheMetrics metrics = new FileCacheMetrics();

    protected FileCacheService() {
        RemovalListener<String, Queue<RandomAccessReader>> onRemove = new RemovalListener<String, Queue<RandomAccessReader>>(){

            public void onRemoval(RemovalNotification<String, Queue<RandomAccessReader>> notification) {
                Queue cachedInstances = (Queue)notification.getValue();
                if (cachedInstances == null) {
                    return;
                }
                if (cachedInstances.size() > 0) {
                    logger.debug("Evicting cold readers for {}", (Object)((RandomAccessReader)cachedInstances.peek()).getPath());
                }
                for (RandomAccessReader reader : cachedInstances) {
                    memoryUsage.addAndGet(-1 * reader.getTotalBufferSize());
                    reader.deallocate();
                }
            }
        };
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(512L, TimeUnit.MILLISECONDS).concurrencyLevel(DatabaseDescriptor.getConcurrentReaders()).removalListener((RemovalListener)onRemove).build();
    }

    public RandomAccessReader get(String path) {
        this.metrics.requests.mark();
        Queue<RandomAccessReader> instances = this.getCacheFor(path);
        RandomAccessReader result = instances.poll();
        if (result != null) {
            this.metrics.hits.mark();
            memoryUsage.addAndGet(-result.getTotalBufferSize());
        }
        return result;
    }

    private Queue<RandomAccessReader> getCacheFor(String path) {
        try {
            return (Queue)this.cache.get((Object)path, cacheForPathCreator);
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void put(RandomAccessReader instance) {
        int memoryUsed = memoryUsage.get();
        if (logger.isDebugEnabled()) {
            logger.debug("Estimated memory usage is {} compared to actual usage {}", (Object)memoryUsed, (Object)this.sizeInBytes());
        }
        if ((long)memoryUsed >= MEMORY_USAGE_THRESHOLD) {
            instance.deallocate();
        } else {
            memoryUsage.addAndGet(instance.getTotalBufferSize());
            this.getCacheFor(instance.getPath()).add(instance);
        }
    }

    public void invalidate(String path) {
        logger.debug("Invalidating cache for {}", (Object)path);
        this.cache.invalidate((Object)path);
    }

    public long sizeInBytes() {
        long n = 0L;
        for (Queue queue : this.cache.asMap().values()) {
            for (RandomAccessReader reader : queue) {
                n += (long)reader.getTotalBufferSize();
            }
        }
        return n;
    }
}

