/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.drools.guvnor.client.modeldriven.brl.ActionCallMethod;
import org.drools.guvnor.client.modeldriven.brl.ActionFieldValue;
import org.drools.guvnor.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.guvnor.client.modeldriven.brl.ActionInsertFact;
import org.drools.guvnor.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.guvnor.client.modeldriven.brl.ActionRetractFact;
import org.drools.guvnor.client.modeldriven.brl.ActionSetField;
import org.drools.guvnor.client.modeldriven.brl.ActionUpdateField;
import org.drools.guvnor.client.modeldriven.brl.CompositeFactPattern;
import org.drools.guvnor.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.guvnor.client.modeldriven.brl.DSLSentence;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.brl.FreeFormLine;
import org.drools.guvnor.client.modeldriven.brl.RuleAttribute;
import org.drools.guvnor.client.modeldriven.brl.RuleMetadata;
import org.drools.guvnor.client.modeldriven.brl.RuleModel;
import org.drools.guvnor.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.guvnor.server.util.BRLPersistence;

public class BRXMLPersistence
implements BRLPersistence {
    private XStream xt = new XStream((HierarchicalStreamDriver)new DomDriver());
    private static final BRLPersistence INSTANCE = new BRXMLPersistence();

    private BRXMLPersistence() {
        this.xt.alias("rule", RuleModel.class);
        this.xt.alias("fact", FactPattern.class);
        this.xt.alias("retract", ActionRetractFact.class);
        this.xt.alias("assert", ActionInsertFact.class);
        this.xt.alias("modify", ActionUpdateField.class);
        this.xt.alias("setField", ActionSetField.class);
        this.xt.alias("dslSentence", DSLSentence.class);
        this.xt.alias("compositePattern", CompositeFactPattern.class);
        this.xt.alias("metadata", RuleMetadata.class);
        this.xt.alias("attribute", RuleAttribute.class);
        this.xt.alias("fieldValue", ActionFieldValue.class);
        this.xt.alias("connectiveConstraint", ConnectiveConstraint.class);
        this.xt.alias("fieldConstraint", SingleFieldConstraint.class);
        this.xt.alias("compositeConstraint", CompositeFieldConstraint.class);
        this.xt.alias("assertLogical", ActionInsertLogicalFact.class);
        this.xt.alias("freeForm", FreeFormLine.class);
        this.xt.alias("addToGlobal", ActionGlobalCollectionAdd.class);
    }

    public static BRLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(RuleModel model) {
        return this.xt.toXML((Object)model);
    }

    public RuleModel unmarshal(String xml) {
        if (xml == null) {
            return new RuleModel();
        }
        if (xml.trim().equals("")) {
            return new RuleModel();
        }
        RuleModel rm = (RuleModel)this.xt.fromXML(xml);
        if (rm.metadataList == null) {
            rm.metadataList = new RuleMetadata[0];
        }
        this.updateMethodCall(rm);
        return rm;
    }

    private RuleModel updateMethodCall(RuleModel model) {
        for (int i = 0; i < model.rhs.length; ++i) {
            if (!(model.rhs[i] instanceof ActionCallMethod)) continue;
            ActionCallMethod action = (ActionCallMethod)model.rhs[i];
            if (action.methodName != null && !"".equals(action.methodName) || action.fieldValues == null || action.fieldValues.length < 1) continue;
            action.methodName = action.fieldValues[0].field;
            action.fieldValues = new ActionFieldValue[0];
            action.state = 1;
        }
        return model;
    }
}

