/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.List;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.executor.jpa.BundleJobGetCoordinatorsJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;

public class BundleJobXCommand
extends XCommand<BundleJobBean> {
    private final String id;

    public BundleJobXCommand(String id) {
        super("job.info", "job.info", 1);
        this.id = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return this.id;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected BundleJobBean execute() throws CommandException {
        try {
            JPAService jpaService = Services.get().get(JPAService.class);
            BundleJobBean bundleJob = null;
            if (jpaService != null) {
                bundleJob = jpaService.execute(new BundleJobGetJPAExecutor(this.id));
                List<CoordinatorJobBean> coordinators = jpaService.execute(new BundleJobGetCoordinatorsJPAExecutor(this.id));
                bundleJob.setCoordJobs(coordinators);
            } else {
                this.LOG.error((Object)ErrorCode.E0610);
            }
            return bundleJob;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }
}

