/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordActionGetJPAExecutor
implements JPAExecutor<CoordinatorActionBean> {
    private String coordActionId = null;

    public CoordActionGetJPAExecutor(String coordActionId) {
        ParamChecker.notNull(coordActionId, "coordActionId");
        this.coordActionId = coordActionId;
    }

    @Override
    public String getName() {
        return "CoordActionGetJPAExecutor";
    }

    @Override
    public CoordinatorActionBean execute(EntityManager em) throws JPAExecutorException {
        List caBeans;
        try {
            Query q = em.createNamedQuery("GET_COORD_ACTION");
            q.setParameter("id", (Object)this.coordActionId);
            caBeans = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        CoordinatorActionBean bean = null;
        if (caBeans != null && caBeans.size() > 0) {
            bean = (CoordinatorActionBean)caBeans.get(0);
            return bean;
        }
        throw new JPAExecutorException(ErrorCode.E0605, this.coordActionId);
    }
}

