/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.locks.ChildReaper;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessReadWriteLock;
import org.apache.curator.framework.recipes.locks.Reaper;
import org.apache.curator.utils.ThreadUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.ZKUtils;

public class ZKLocksService
extends MemoryLocksService
implements Service,
Instrumentable {
    private ZKUtils zk;
    private static XLog LOG = XLog.getLog(ZKLocksService.class);
    public static final String LOCKS_NODE = "/locks";
    private final HashMap<String, InterProcessReadWriteLock> zkLocks = new HashMap();
    private static final String REAPING_LEADER_PATH = "/services/locksChildReaperLeaderPath";
    public static final int DEFAULT_REAPING_THRESHOLD = 300;
    public static final String REAPING_THRESHOLD = "oozie.service.ZKLocksService.locks.reaper.threshold";
    public static final String REAPING_THREADS = "oozie.service.ZKLocksService.locks.reaper.threads";
    private ChildReaper reaper = null;

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
            this.reaper = new ChildReaper(this.zk.getClient(), LOCKS_NODE, Reaper.Mode.REAP_INDEFINITELY, ZKLocksService.getExecutorService(), services.getConf().getInt(REAPING_THRESHOLD, 300) * 1000, REAPING_LEADER_PATH);
            this.reaper.start();
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
    }

    @Override
    public void destroy() {
        if (this.reaper != null) {
            try {
                this.reaper.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing childReaper", e);
            }
        }
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable("locks", "locks", new Instrumentation.Variable<Integer>(){

            @Override
            public Integer getValue() {
                return ZKLocksService.this.zkLocks.size();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockToken getReadLock(String resource, long wait) throws InterruptedException {
        InterProcessReadWriteLock lockEntry;
        HashMap<String, InterProcessReadWriteLock> hashMap = this.zkLocks;
        synchronized (hashMap) {
            if (this.zkLocks.containsKey(resource)) {
                lockEntry = this.zkLocks.get(resource);
            } else {
                lockEntry = new InterProcessReadWriteLock(this.zk.getClient(), "/locks/" + resource);
                this.zkLocks.put(resource, lockEntry);
            }
        }
        InterProcessMutex readLock = lockEntry.readLock();
        return this.acquireLock(wait, readLock, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockToken getWriteLock(String resource, long wait) throws InterruptedException {
        InterProcessReadWriteLock lockEntry;
        HashMap<String, InterProcessReadWriteLock> hashMap = this.zkLocks;
        synchronized (hashMap) {
            if (this.zkLocks.containsKey(resource)) {
                lockEntry = this.zkLocks.get(resource);
            } else {
                lockEntry = new InterProcessReadWriteLock(this.zk.getClient(), "/locks/" + resource);
                this.zkLocks.put(resource, lockEntry);
            }
        }
        InterProcessMutex writeLock = lockEntry.writeLock();
        return this.acquireLock(wait, writeLock, resource);
    }

    private LockToken acquireLock(long wait, InterProcessMutex lock, String resource) {
        ZKLockToken token = null;
        try {
            if (wait == -1L) {
                lock.acquire();
                token = new ZKLockToken(lock, resource);
            } else if (lock.acquire(wait, TimeUnit.MILLISECONDS)) {
                token = new ZKLockToken(lock, resource);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return token;
    }

    @VisibleForTesting
    public HashMap<String, InterProcessReadWriteLock> getLocks() {
        return this.zkLocks;
    }

    private static ScheduledExecutorService getExecutorService() {
        return ThreadUtils.newFixedThreadScheduledPool((int)Services.get().getConf().getInt(REAPING_THREADS, 2), (String)"ZKLocksChildReaper");
    }

    class ZKLockToken
    implements LockToken {
        private final InterProcessMutex lock;
        private final String resource;

        private ZKLockToken(InterProcessMutex lock, String resource) {
            this.lock = lock;
            this.resource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            block5: {
                try {
                    this.lock.release();
                    int val = this.lock.getParticipantNodes().size();
                    if (val != 0) break block5;
                    HashMap hashMap = ZKLocksService.this.zkLocks;
                    synchronized (hashMap) {
                        ZKLocksService.this.zkLocks.remove(this.resource);
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Could not release lock: " + ex.getMessage()), ex);
                }
            }
        }
    }
}

