/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogCopyService;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.util.AuthUrlClient;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.SimpleTimestampedMessageParser;
import org.apache.oozie.util.TimestampedMessageParser;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogStreamer;
import org.apache.oozie.util.ZKUtils;

public class ZKXLogStreamingService
extends XLogStreamingService
implements Service,
Instrumentable {
    private ZKUtils zk;
    private XLog log;

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
        this.log = XLog.getLog(this.getClass());
    }

    @Override
    public void destroy() {
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    @Override
    public void instrument(Instrumentation instr) {
        super.instrument(instr);
    }

    @Override
    public void streamLog(XLogFilter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params) throws IOException {
        XLogService xLogService = Services.get().get(XLogService.class);
        if (xLogService.getLogOverWS()) {
            if (!Services.get().get(JobsConcurrencyService.class).isAllServerRequest(params)) {
                new XLogStreamer(filter, xLogService.getOozieLogPath(), xLogService.getOozieLogName(), xLogService.getOozieLogRotation()).streamLog(writer, startTime, endTime, this.bufferLen);
            } else {
                this.collateLogs(filter, startTime, endTime, writer, params);
            }
        } else {
            writer.write("Log streaming disabled!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collateLogs(XLogFilter filter, Date startTime, Date endTime, Writer writer, Map<String, String[]> params) throws IOException {
        block23: {
            XLogService xLogService = Services.get().get(XLogService.class);
            ArrayList<String> badOozies = new ArrayList<String>();
            List<ServiceInstance<Map>> oozies = null;
            try {
                oozies = this.zk.getAllMetaData();
            }
            catch (Exception ex) {
                throw new IOException("Issue communicating with ZooKeeper: " + ex.getMessage(), ex);
            }
            ArrayList<TimestampedMessageParser> parsers = new ArrayList<TimestampedMessageParser>(oozies.size());
            boolean openHDFS = false;
            FileSystem fs = null;
            try {
                for (ServiceInstance<Map> oozie : oozies) {
                    Map oozieMeta = (Map)oozie.getPayload();
                    String otherId = (String)oozieMeta.get("OOZIE_ID");
                    if (otherId.equals(this.zk.getZKId())) {
                        BufferedReader reader = new XLogStreamer(filter, xLogService.getOozieLogPath(), xLogService.getOozieLogName(), xLogService.getOozieLogRotation()).makeReader(startTime, endTime);
                        parsers.add(new TimestampedMessageParser(reader, filter));
                        continue;
                    }
                    String otherUrl = (String)oozieMeta.get("OOZIE_URL");
                    String jobId = filter.getFilterParams().get("JOB");
                    try {
                        String url = otherUrl + "/v" + 2L + "/" + "job" + "/" + jobId + "?" + "show" + "=" + "log" + "&" + "allservers" + "=false" + AuthUrlClient.getQueryParamString(params);
                        BufferedReader reader = AuthUrlClient.callServer(url);
                        parsers.add(new SimpleTimestampedMessageParser(reader, filter));
                    }
                    catch (IOException ioe) {
                        this.log.warn((Object)("Failed to retrieve logs for job [" + jobId + "] from Oozie server with ID [" + otherId + "] at [" + otherUrl + "]; log information may be incomplete"), ioe);
                        badOozies.add(otherId);
                    }
                }
                if (filter.isDebugMode()) {
                    writer.write(filter.getDebugMessage());
                }
                if (!badOozies.isEmpty()) {
                    writer.write("Unable to contact the following Oozie Servers for logs (log information may be incomplete):\n");
                    for (String badOozie : badOozies) {
                        writer.write("     ");
                        writer.write(badOozie);
                        writer.write("\n");
                    }
                    writer.write("\n");
                    writer.flush();
                }
                if (parsers.size() == 1) {
                    TimestampedMessageParser parser = (TimestampedMessageParser)parsers.get(0);
                    parser.processRemaining(writer, this.bufferLen);
                    break block23;
                }
                if (!badOozies.isEmpty()) {
                    XLogCopyService xls = Services.get().get(XLogCopyService.class);
                    String hdfsDir = xls.getConfHdfsLogDir();
                    HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
                    URI uri = new Path(hdfsDir).toUri();
                    JobConf fsConf = has.createJobConf(uri.getAuthority());
                    try {
                        fs = has.createFileSystem(System.getProperty("user.name"), uri, (Configuration)fsConf);
                        openHDFS = true;
                    }
                    catch (Exception ex) {
                        this.log.error((Object)(System.getProperty("user.name") + " has to be specified to access hdfs"), new HadoopAccessorException(ErrorCode.E0902, System.getProperty("user.name") + " has to be specified to access FileSystem"));
                    }
                    FileStatus[] fileStatuses = fs.listStatus(new Path(hdfsDir));
                    Path[] paths = FileUtil.stat2Paths((FileStatus[])fileStatuses);
                    String jobId = filter.getFilterParams().get("JOB");
                    parsers = new ArrayList();
                    for (Path path : paths) {
                        Path logFilePath = new Path(path, jobId + ".log");
                        if (!fs.exists(logFilePath)) continue;
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(logFilePath)));
                        parsers.add(new TimestampedMessageParser(reader, filter));
                    }
                }
                TreeMap<String, TimestampedMessageParser> timestampMap = new TreeMap<String, TimestampedMessageParser>();
                for (TimestampedMessageParser parser : parsers) {
                    if (!parser.increment()) continue;
                    timestampMap.put(parser.getLastTimestamp(), parser);
                }
                int bytesWritten = 0;
                while (timestampMap.size() > 1) {
                    TimestampedMessageParser earliestParser = (TimestampedMessageParser)timestampMap.pollFirstEntry().getValue();
                    writer.write(earliestParser.getLastMessage());
                    bytesWritten = earliestParser.getLastMessage().length();
                    if (bytesWritten > this.bufferLen) {
                        writer.flush();
                        bytesWritten = 0;
                    }
                    if (!earliestParser.increment()) continue;
                    timestampMap.put(earliestParser.getLastTimestamp(), earliestParser);
                }
                if (timestampMap.size() == 1) {
                    TimestampedMessageParser parser;
                    parser = (TimestampedMessageParser)timestampMap.values().iterator().next();
                    writer.write(parser.getLastMessage());
                    parser.processRemaining(writer, this.bufferLen, bytesWritten + parser.getLastMessage().length());
                }
            }
            finally {
                for (TimestampedMessageParser parser : parsers) {
                    parser.closeReader();
                }
                writer.flush();
                if (openHDFS) {
                    fs.close();
                }
            }
        }
    }
}

