/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.oozie.util.TimestampedMessageParser;
import org.apache.oozie.util.XLogFilter;

public class HDFSTimestampedMessageParser
extends TimestampedMessageParser {
    public HDFSTimestampedMessageParser(BufferedReader reader, XLogFilter filter) {
        super(reader, filter);
    }

    public List<String> getAllServers() throws IOException {
        String currentLine = "";
        Pattern pattern = Pattern.compile("SERVER\\[(.*?)\\]");
        HashSet<String> servers = new HashSet<String>();
        while ((currentLine = this.reader.readLine()) != null) {
            String server = "";
            Matcher matcher = pattern.matcher(currentLine);
            if (matcher.find()) {
                server = matcher.group(1);
            }
            if (server.trim().equals("-") || server.isEmpty() || servers.contains(server)) continue;
            servers.add(server);
        }
        ArrayList<String> allServers = new ArrayList<String>();
        for (String s : servers) {
            allServers.add(s);
        }
        return allServers;
    }
}

