/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hdfs.vfs;

import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.pentaho.hdfs.vfs.HDFSFileObject;
import org.pentaho.hdfs.vfs.HDFSFileProvider;
import org.pentaho.hdfs.vfs.HDFSFileSystemConfigBuilder;
import org.pentaho.hdfs.vfs.HadoopFileSystem;
import org.pentaho.hdfs.vfs.HadoopFileSystemImpl;

public class HDFSFileSystem
extends AbstractFileSystem
implements org.apache.commons.vfs.FileSystem {
    private static HadoopFileSystem mockHdfs;
    private HadoopFileSystem hdfs;

    protected HDFSFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(HDFSFileProvider.capabilities);
    }

    protected FileObject createFile(FileName name) throws Exception {
        return new HDFSFileObject(name, this);
    }

    public static void setMockHDFSFileSystem(FileSystem hdfs) {
        mockHdfs = new HadoopFileSystemImpl(hdfs);
    }

    public HadoopFileSystem getHDFSFileSystem() throws FileSystemException {
        if (mockHdfs != null) {
            return mockHdfs;
        }
        if (this.hdfs == null) {
            Configuration conf = new Configuration();
            GenericFileName genericFileName = (GenericFileName)this.getRootName();
            StringBuffer urlBuffer = new StringBuffer("hdfs://");
            urlBuffer.append(genericFileName.getHostName());
            int port = genericFileName.getPort();
            if (port >= 0) {
                urlBuffer.append(":");
                urlBuffer.append(port);
            }
            String url = urlBuffer.toString();
            conf.set("fs.default.name", url);
            String replication = System.getProperty("dfs.replication", "3");
            conf.set("dfs.replication", replication);
            if (genericFileName.getUserName() != null && !"".equals(genericFileName.getUserName())) {
                conf.set("hadoop.job.ugi", genericFileName.getUserName() + ", " + genericFileName.getPassword());
            }
            HDFSFileSystem.setFileSystemOptions(this.getFileSystemOptions(), conf);
            try {
                this.hdfs = new HadoopFileSystemImpl(FileSystem.get((Configuration)conf));
            }
            catch (Throwable t) {
                throw new FileSystemException("Could not getHDFSFileSystem() for " + url, t);
            }
        }
        return this.hdfs;
    }

    public static void setFileSystemOptions(FileSystemOptions fileSystemOptions, Configuration configuration) {
        HDFSFileSystemConfigBuilder hdfsFileSystemConfigBuilder = new HDFSFileSystemConfigBuilder();
        FileSystemOptions opts = fileSystemOptions;
        for (String name : hdfsFileSystemConfigBuilder.getOptions(opts)) {
            if (!hdfsFileSystemConfigBuilder.hasParam(opts, name)) continue;
            configuration.set(name, String.valueOf(hdfsFileSystemConfigBuilder.getParam(opts, name)));
        }
    }
}

