/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Region
extends Resource {
    public long handle;
    NSAffineTransform transform;
    NSPoint pt = new NSPoint();
    short[] rect = new short[4];

    public Region() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region(Device device) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle = OS.NewRgn();
            if (this.handle == 0L) {
                SWT.error(2);
            }
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    Region(Device device, long l) {
        super(device);
        this.handle = l;
    }

    public static Region cocoa_new(Device device, long l) {
        return new Region(device, l);
    }

    static long polyToRgn(int[] nArray, int n) {
        short[] sArray = new short[4];
        long l = OS.NewRgn();
        long l2 = OS.NewRgn();
        int n2 = nArray[1];
        int n3 = nArray[1];
        for (int i = 3; i < n; i += 2) {
            if (nArray[i] < n2) {
                n2 = nArray[i];
            }
            if (nArray[i] <= n3) continue;
            n3 = nArray[i];
        }
        int[] nArray2 = new int[n + 1];
        for (int i = n2; i <= n3; ++i) {
            int n4;
            int n5;
            int n6;
            int n7 = 0;
            int n8 = nArray[0];
            int n9 = nArray[1];
            for (n6 = 2; n6 < n; n6 += 2) {
                n5 = nArray[n6];
                n4 = nArray[n6 + 1];
                if (n9 != n4 && (n9 <= i && i < n4 || n4 <= i && i < n9)) {
                    nArray2[n7++] = (int)((float)(i - n9) / (float)(n4 - n9) * (float)(n5 - n8) + (float)n8 + 0.5f);
                }
                n8 = n5;
                n9 = n4;
            }
            n6 = nArray[0];
            n5 = nArray[1];
            if (n9 != n5 && (n9 <= i && i < n5 || n5 <= i && i < n9)) {
                nArray2[n7++] = (int)((float)(i - n9) / (float)(n5 - n9) * (float)(n6 - n8) + (float)n8 + 0.5f);
            }
            for (n4 = n7 / 2; n4 > 0; n4 /= 2) {
                for (int j = n4; j < n7; ++j) {
                    for (int k = j - n4; k >= 0 && nArray2[k] - nArray2[k + n4] > 0; k -= n4) {
                        int n10 = nArray2[k];
                        nArray2[k] = nArray2[k + n4];
                        nArray2[k + n4] = n10;
                    }
                }
            }
            for (n4 = 0; n4 < n7; n4 += 2) {
                OS.SetRect(sArray, (short)nArray2[n4], (short)i, (short)nArray2[n4 + 1], (short)(i + 1));
                OS.RectRgn(l2, sArray);
                OS.UnionRgn(l, l2, l);
            }
        }
        OS.DisposeRgn(l2);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long polyRgn(int[] nArray, int n) {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l;
            if (C.PTR_SIZEOF == 4) {
                l = OS.NewRgn();
                OS.OpenRgn();
                OS.MoveTo((short)nArray[0], (short)nArray[1]);
                for (int i = 1; i < n / 2; ++i) {
                    OS.LineTo((short)nArray[2 * i], (short)nArray[2 * i + 1]);
                }
                OS.LineTo((short)nArray[0], (short)nArray[1]);
                OS.CloseRgn(l);
            } else {
                l = Region.polyToRgn(nArray, n);
            }
            long l2 = l;
            return l2;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.add(nArray, nArray.length);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(int[] nArray, int n) {
        if ((n = n / 2 * 2) <= 2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l = Region.polyRgn(nArray, n);
            OS.UnionRgn(this.handle, l, this.handle);
            OS.DisposeRgn(l);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (rectangle.width < 0 || rectangle.height < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l = OS.NewRgn();
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
            OS.RectRgn(l, sArray);
            OS.UnionRgn(this.handle, l, this.handle);
            OS.DisposeRgn(l);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.UnionRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] sArray = new short[]{(short)n2, (short)n};
            boolean bl = OS.PtInRgn(sArray, this.handle);
            return bl;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public boolean contains(Point point) {
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    void convertRgn(NSAffineTransform nSAffineTransform) {
        long l = OS.NewRgn();
        Callback callback = new Callback(this, "convertRgn", 4);
        long l2 = callback.getAddress();
        if (l2 == 0L) {
            SWT.error(3);
        }
        this.transform = nSAffineTransform;
        OS.QDRegionToRects(this.handle, 5, l2, l);
        this.transform = null;
        callback.dispose();
        OS.CopyRgn(l, this.handle);
        OS.DisposeRgn(l);
    }

    long convertRgn(long l, long l2, long l3, long l4) {
        if (l == 2L) {
            short[] sArray = new short[4];
            OS.memmove(sArray, l3, (long)(sArray.length * 2));
            int n = 0;
            NSPoint nSPoint = new NSPoint();
            int[] nArray = new int[10];
            nSPoint.x = sArray[1];
            nSPoint.y = sArray[0];
            nSPoint = this.transform.transformPoint(nSPoint);
            int n2 = n++;
            short s = (short)nSPoint.x;
            nArray[n2] = s;
            int n3 = n++;
            short s2 = (short)nSPoint.y;
            nArray[n3] = s2;
            nSPoint.x = sArray[3];
            nSPoint.y = sArray[0];
            nSPoint = this.transform.transformPoint(nSPoint);
            nArray[n++] = (short)Math.round(nSPoint.x);
            nArray[n++] = (short)nSPoint.y;
            nSPoint.x = sArray[3];
            nSPoint.y = sArray[2];
            nSPoint = this.transform.transformPoint(nSPoint);
            nArray[n++] = (short)Math.round(nSPoint.x);
            nArray[n++] = (short)Math.round(nSPoint.y);
            nSPoint.x = sArray[1];
            nSPoint.y = sArray[2];
            nSPoint = this.transform.transformPoint(nSPoint);
            nArray[n++] = (short)nSPoint.x;
            nArray[n++] = (short)Math.round(nSPoint.y);
            nArray[n++] = s;
            nArray[n++] = s2;
            long l5 = Region.polyRgn(nArray, nArray.length);
            OS.UnionRgn(l4, l5, l4);
            OS.DisposeRgn(l5);
        }
        return 0L;
    }

    void destroy() {
        OS.DisposeRgn(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] sArray = new short[4];
            OS.GetRegionBounds(this.handle, sArray);
            int n = sArray[3] - sArray[1];
            int n2 = sArray[2] - sArray[0];
            Rectangle rectangle = new Rectangle(sArray[1], sArray[0], n, n2);
            return rectangle;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    NSBezierPath getPath() {
        Callback callback = new Callback(this, "regionToRects", 4);
        if (callback.getAddress() == 0L) {
            SWT.error(3);
        }
        NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
        nSBezierPath.retain();
        OS.QDRegionToRects(this.handle, 5, callback.getAddress(), nSBezierPath.id);
        callback.dispose();
        if (nSBezierPath.isEmpty()) {
            nSBezierPath.appendBezierPathWithRect(new NSRect());
        }
        return nSBezierPath;
    }

    long regionToRects(long l, long l2, long l3, long l4) {
        if (l == 2L) {
            OS.memmove(this.rect, l3, (long)(this.rect.length * 2));
            this.pt.x = this.rect[1];
            this.pt.y = this.rect[0];
            OS.objc_msgSend(l4, OS.sel_moveToPoint_, this.pt);
            this.pt.x = this.rect[3];
            OS.objc_msgSend(l4, OS.sel_lineToPoint_, this.pt);
            this.pt.x = this.rect[3];
            this.pt.y = this.rect[2];
            OS.objc_msgSend(l4, OS.sel_lineToPoint_, this.pt);
            this.pt.x = this.rect[1];
            OS.objc_msgSend(l4, OS.sel_lineToPoint_, this.pt);
            OS.objc_msgSend(l4, OS.sel_closePath);
        }
        return 0L;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    public void intersect(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intersect(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l = OS.NewRgn();
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
            OS.RectRgn(l, sArray);
            OS.SectRgn(this.handle, l, this.handle);
            OS.DisposeRgn(l);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.SectRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean intersects(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
            boolean bl = OS.RectInRgn(sArray, this.handle);
            return bl;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean isDisposed() {
        return this.handle == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            boolean bl = OS.EmptyRgn(this.handle);
            return bl;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l = Region.polyRgn(nArray, nArray.length);
            OS.DiffRgn(this.handle, l, this.handle);
            OS.DisposeRgn(l);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void subtract(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            long l = OS.NewRgn();
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
            OS.RectRgn(l, sArray);
            OS.DiffRgn(this.handle, l, this.handle);
            OS.DisposeRgn(l);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.DiffRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.OffsetRgn(this.handle, (short)n, (short)n2);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.translate(point.x, point.y);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

