/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POBinCond
extends ExpressionOperator {
    private static final long serialVersionUID = 1L;
    ExpressionOperator cond;
    ExpressionOperator lhs;
    ExpressionOperator rhs;
    private transient List<ExpressionOperator> child;

    public POBinCond(OperatorKey k) {
        super(k);
    }

    public POBinCond(OperatorKey k, int rp) {
        super(k, rp);
    }

    public POBinCond(OperatorKey k, int rp, ExpressionOperator cond, ExpressionOperator lhs, ExpressionOperator rhs) {
        super(k, rp);
        this.cond = cond;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Result genericGetNext(byte dataType) throws ExecException {
        ArrayList<ExpressionOperator> list = new ArrayList<ExpressionOperator>();
        list.add(this.cond);
        Result r = this.accumChild(list, (byte)5);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            list.clear();
            list.add(this.lhs);
            list.add(this.rhs);
            r = this.accumChild(list, dataType);
            return r;
        }
        Result res = this.cond.getNextBoolean();
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        Result result = (Boolean)res.result == true ? this.lhs.getNext(dataType) : this.rhs.getNext(dataType);
        this.illustratorMarkup(null, result.result, (Boolean)res.result != false ? 0 : 1);
        return result;
    }

    @Override
    public Result getNextBoolean() throws ExecException {
        Result r = this.accumChild(null, (byte)5);
        if (r != null) {
            return r;
        }
        Result res = this.cond.getNextBoolean();
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNextBoolean() : this.rhs.getNextBoolean();
    }

    @Override
    public Result getNextDataBag() throws ExecException {
        return this.genericGetNext((byte)120);
    }

    @Override
    public Result getNextDataByteArray() throws ExecException {
        return this.genericGetNext((byte)50);
    }

    @Override
    public Result getNextDouble() throws ExecException {
        return this.genericGetNext((byte)25);
    }

    @Override
    public Result getNextFloat() throws ExecException {
        return this.genericGetNext((byte)20);
    }

    @Override
    public Result getNextInteger() throws ExecException {
        return this.genericGetNext((byte)10);
    }

    @Override
    public Result getNextLong() throws ExecException {
        return this.genericGetNext((byte)15);
    }

    @Override
    public Result getNextDateTime() throws ExecException {
        return this.genericGetNext((byte)30);
    }

    @Override
    public Result getNextMap() throws ExecException {
        return this.genericGetNext((byte)100);
    }

    @Override
    public Result getNextString() throws ExecException {
        return this.genericGetNext((byte)55);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        return this.genericGetNext((byte)110);
    }

    @Override
    public Result getNextBigInteger() throws ExecException {
        return this.genericGetNext((byte)65);
    }

    @Override
    public Result getNextBigDecimal() throws ExecException {
        return this.genericGetNext((byte)70);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitBinCond(this);
    }

    @Override
    public String name() {
        return "POBinCond[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public void attachInput(Tuple t) {
        this.cond.attachInput(t);
        this.lhs.attachInput(t);
        this.rhs.attachInput(t);
    }

    public void setCond(ExpressionOperator condOp) {
        this.cond = condOp;
    }

    public void setRhs(ExpressionOperator rhs) {
        this.rhs = rhs;
    }

    public void setLhs(ExpressionOperator lhs) {
        this.lhs = lhs;
    }

    public ExpressionOperator getCond() {
        return this.cond;
    }

    public ExpressionOperator getRhs() {
        return this.rhs;
    }

    public ExpressionOperator getLhs() {
        return this.lhs;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public POBinCond clone() throws CloneNotSupportedException {
        POBinCond clone = new POBinCond(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        clone.cond = this.cond.clone();
        clone.lhs = this.lhs.clone();
        clone.rhs = this.rhs.clone();
        return clone;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        if (this.child == null) {
            this.child = new ArrayList<ExpressionOperator>();
            this.child.add(this.cond);
            this.child.add(this.lhs);
            this.child.add(this.rhs);
        }
        return this.child;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            // empty if block
        }
        return null;
    }
}

