/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BagToTuple
extends EvalFunc<Tuple> {
    @Override
    public Tuple exec(Tuple inputTuple) throws IOException {
        if (inputTuple.size() != 1) {
            throw new ExecException("Expecting 1 input, found " + inputTuple.size(), 2);
        }
        if (inputTuple.get(0) == null) {
            return null;
        }
        if (!(inputTuple.get(0) instanceof DataBag)) {
            throw new ExecException("Usage BagToTuple(DataBag)", 2);
        }
        DataBag inputBag = (DataBag)inputTuple.get(0);
        try {
            Tuple outputTuple = null;
            long outputTupleSize = this.getOuputTupleSize(inputBag);
            if (outputTupleSize > Integer.MAX_VALUE) {
                throw new ExecException("Input bag is too large", 105, 2);
            }
            TupleFactory tupleFactory = TupleFactory.getInstance();
            outputTuple = tupleFactory.newTuple((int)outputTupleSize);
            int fieldNum = 0;
            for (Tuple t : inputBag) {
                if (t == null) continue;
                for (int i = 0; i < t.size(); ++i) {
                    outputTuple.set(fieldNum++, t.get(i));
                }
            }
            return outputTuple;
        }
        catch (Exception e) {
            String msg = "Encourntered error while flattening a bag to tuple" + this.getClass().getSimpleName();
            throw new ExecException(msg, 4, e);
        }
    }

    private long getOuputTupleSize(DataBag bag) {
        long size = 0L;
        if (bag != null) {
            for (Tuple t : bag) {
                size += (long)t.size();
            }
        }
        return size;
    }

    @Override
    public Schema outputSchema(Schema inputSchema) {
        try {
            if (inputSchema == null || inputSchema.size() != 1) {
                throw new RuntimeException("Expecting 1 input, found " + (inputSchema == null ? 0 : inputSchema.size()));
            }
            Schema.FieldSchema inputFieldSchema = inputSchema.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expecting a bag of tuples: {()}");
            }
            Schema.FieldSchema firstFieldSchema = inputFieldSchema.schema.getField(0);
            if (firstFieldSchema == null || firstFieldSchema.schema == null || firstFieldSchema.schema.size() < 1) {
                throw new RuntimeException("Expecting a bag of tuples: {()}, found: " + inputSchema);
            }
            if (firstFieldSchema.type != 110) {
                throw new RuntimeException("Expecting a bag of tuples: {()}, found: " + inputSchema);
            }
            Schema tupleOutputSchema = new Schema();
            for (int i = 0; i < firstFieldSchema.schema.size(); ++i) {
                tupleOutputSchema.add(firstFieldSchema.schema.getField(i));
            }
            return new Schema(new Schema.FieldSchema(this.getSchemaName(this.getClass().getName().toLowerCase(), inputSchema), tupleOutputSchema, 110));
        }
        catch (FrontendException e) {
            e.printStackTrace();
            return null;
        }
    }
}

