/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LOCube;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static LogicalSchema translateSchema(Schema schema) {
        if (schema == null) {
            return null;
        }
        LogicalSchema s2 = new LogicalSchema();
        List<Schema.FieldSchema> ll = schema.getFields();
        for (Schema.FieldSchema f : ll) {
            LogicalSchema.LogicalFieldSchema f2 = new LogicalSchema.LogicalFieldSchema(f.alias, Util.translateSchema(f.schema), f.type);
            s2.addField(f2);
        }
        return s2;
    }

    public static LogicalSchema.LogicalFieldSchema translateFieldSchema(Schema.FieldSchema fs) {
        LogicalSchema newSchema = null;
        if (fs.schema != null) {
            newSchema = Util.translateSchema(fs.schema);
        }
        LogicalSchema.LogicalFieldSchema newFs = new LogicalSchema.LogicalFieldSchema(fs.alias, newSchema, fs.type);
        return newFs;
    }

    public static Schema translateSchema(LogicalSchema schema) {
        if (schema == null) {
            return null;
        }
        Schema s2 = new Schema();
        List<LogicalSchema.LogicalFieldSchema> ll = schema.getFields();
        for (LogicalSchema.LogicalFieldSchema f : ll) {
            Schema.FieldSchema f2 = null;
            try {
                f2 = new Schema.FieldSchema(f.alias, Util.translateSchema(f.schema), f.type);
                f2.canonicalName = Long.valueOf(f.uid).toString();
                s2.add(f2);
            }
            catch (FrontendException e) {}
        }
        return s2;
    }

    public static Schema fixSchemaAddTupleInBag(Schema sch) throws FrontendException {
        LogicalSchema logSch = Util.translateSchema(sch);
        logSch.normalize();
        return Util.translateSchema(logSch);
    }

    public static Schema.FieldSchema translateFieldSchema(LogicalSchema.LogicalFieldSchema fs) {
        if (fs == null) {
            return null;
        }
        Schema newSchema = null;
        if (fs.schema != null) {
            newSchema = Util.translateSchema(fs.schema);
        }
        Schema.FieldSchema newFs = null;
        try {
            newFs = new Schema.FieldSchema(null, newSchema, fs.type);
        }
        catch (FrontendException frontendException) {
            // empty catch block
        }
        return newFs;
    }

    public static LOForEach addForEachAfter(LogicalPlan plan, LogicalRelationalOperator op, int branch, Set<Integer> columnsToDrop) throws FrontendException {
        LOForEach foreach = new LOForEach(plan);
        plan.add(foreach);
        List<Operator> next = plan.getSuccessors(op);
        if (next != null) {
            LogicalRelationalOperator nextOp = (LogicalRelationalOperator)next.get(branch);
            plan.insertBetween(op, foreach, nextOp);
            foreach.setAlias(op.getAlias());
        } else {
            plan.connect(op, foreach);
        }
        LogicalPlan innerPlan = new LogicalPlan();
        foreach.setInnerPlan(innerPlan);
        LogicalSchema schema = op.getSchema();
        ArrayList<LogicalExpressionPlan> exps = new ArrayList<LogicalExpressionPlan>();
        LOGenerate gen = new LOGenerate(innerPlan, exps, new boolean[schema.size() - columnsToDrop.size()]);
        innerPlan.add(gen);
        int j = 0;
        for (int i = 0; i < schema.size(); ++i) {
            if (columnsToDrop.contains(i)) continue;
            LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, i);
            innerPlan.add(innerLoad);
            innerPlan.connect(innerLoad, gen);
            LogicalExpressionPlan exp = new LogicalExpressionPlan();
            ProjectExpression prj = new ProjectExpression(exp, j++, -1, gen);
            exp.add(prj);
            exps.add(exp);
        }
        return foreach;
    }

    public static <C extends LogicalRelationalOperator> LinkedList<C> getLogicalRelationalOperators(LogicalPlan plan, Class<C> opClass) throws FrontendException {
        OpFinder<C> finder = new OpFinder<C>(plan, opClass);
        finder.visit();
        return finder.getFoundOps();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OpFinder<C extends LogicalRelationalOperator>
    extends LogicalRelationalNodesVisitor {
        final Class<C> opClass;
        private LinkedList<C> foundOps = Lists.newLinkedList();

        public OpFinder(LogicalPlan plan, Class<C> opClass) throws FrontendException {
            super(plan, new DependencyOrderWalker(plan));
            this.opClass = opClass;
        }

        public LinkedList<C> getFoundOps() {
            return this.foundOps;
        }

        private void visitOp(LogicalRelationalOperator op) {
            if (this.opClass.isAssignableFrom(op.getClass())) {
                this.foundOps.add(op);
            }
        }

        @Override
        public void visit(LOLoad load) throws FrontendException {
            this.visitOp(load);
        }

        @Override
        public void visit(LOFilter filter) throws FrontendException {
            this.visitOp(filter);
        }

        @Override
        public void visit(LOStore store) throws FrontendException {
            this.visitOp(store);
        }

        @Override
        public void visit(LOJoin join) throws FrontendException {
            this.visitOp(join);
        }

        @Override
        public void visit(LOForEach foreach) throws FrontendException {
            this.visitOp(foreach);
        }

        @Override
        public void visit(LOGenerate gen) throws FrontendException {
            this.visitOp(gen);
        }

        @Override
        public void visit(LOInnerLoad load) throws FrontendException {
            this.visitOp(load);
        }

        @Override
        public void visit(LOCube cube) throws FrontendException {
            this.visitOp(cube);
        }

        @Override
        public void visit(LOCogroup loCogroup) throws FrontendException {
            this.visitOp(loCogroup);
        }

        @Override
        public void visit(LOSplit loSplit) throws FrontendException {
            this.visitOp(loSplit);
        }

        @Override
        public void visit(LOSplitOutput loSplitOutput) throws FrontendException {
            this.visitOp(loSplitOutput);
        }

        @Override
        public void visit(LOUnion loUnion) throws FrontendException {
            this.visitOp(loUnion);
        }

        @Override
        public void visit(LOSort loSort) throws FrontendException {
            this.visitOp(loSort);
        }

        @Override
        public void visit(LORank loRank) throws FrontendException {
            this.visitOp(loRank);
        }

        @Override
        public void visit(LODistinct loDistinct) throws FrontendException {
            this.visitOp(loDistinct);
        }

        @Override
        public void visit(LOLimit loLimit) throws FrontendException {
            this.visitOp(loLimit);
        }

        @Override
        public void visit(LOCross loCross) throws FrontendException {
            this.visitOp(loCross);
        }

        @Override
        public void visit(LOStream loStream) throws FrontendException {
            this.visitOp(loStream);
        }

        @Override
        public void visit(LONative nativeMR) throws FrontendException {
            this.visitOp(nativeMR);
        }
    }
}

