/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;

public final class NetDump {
    private NetDump() {
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Need an Method + URL as parameter");
            System.exit(1);
        }
        try {
            String method = args[0];
            URL url = new URL(args[1]);
            if (!"http".equals(url.getProtocol())) {
                System.err.println("The given url must be a HTTP url");
                System.exit(1);
            }
            ConnectionInfo ci = new ConnectionInfo(url);
            System.out.println("Connecting to: " + ci.getHost() + ":" + ci.getPort());
            Socket socket = new Socket(ci.getHost(), ci.getPort());
            OutputStream out = socket.getOutputStream();
            StringBuffer b = new StringBuffer();
            b.append(method.toUpperCase());
            b.append(" ");
            b.append(ci.getUri());
            b.append(" HTTP/1.0\n");
            b.append("\n");
            System.out.println(b.toString());
            out.write(b.toString().getBytes());
            InputStream in = socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                System.out.println(line);
                line = reader.readLine();
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Failed to perform request: ");
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static class ConnectionInfo {
        private String host;
        private int port;
        private String uri;

        public ConnectionInfo(URL url) {
            this.host = url.getHost();
            this.port = url.getPort();
            if (this.port == -1) {
                this.port = 80;
            }
            String file = url.getFile();
            String ref = url.getRef();
            this.uri = file;
            if (ref != null) {
                this.uri = this.uri + "#";
                this.uri = this.uri + ref;
            }
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

