/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.event;

import com.cloudera.com.amazonaws.event.ProgressEvent;
import com.cloudera.com.amazonaws.event.ProgressListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProgressListenerChain
implements ProgressListener {
    private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private final ProgressEventFilter progressEventFilter;
    private static final Log log = LogFactory.getLog(ProgressListenerChain.class);

    public ProgressListenerChain(ProgressListener ... listeners) {
        this((ProgressEventFilter)null, listeners);
    }

    public ProgressListenerChain(ProgressEventFilter progressEventFilter, ProgressListener ... listeners) {
        for (ProgressListener listener : listeners) {
            this.addProgressListener(listener);
        }
        this.progressEventFilter = progressEventFilter;
    }

    public synchronized void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public synchronized void removeProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void progressChanged(ProgressEvent progressEvent) {
        ProgressEvent filteredEvent = progressEvent;
        if (this.progressEventFilter != null && (filteredEvent = this.progressEventFilter.filter(progressEvent)) == null) {
            return;
        }
        for (ProgressListener listener : this.listeners) {
            try {
                listener.progressChanged(filteredEvent);
            }
            catch (RuntimeException e) {
                log.warn((Object)"Couldn't update progress listener", (Throwable)e);
            }
        }
    }

    public static interface ProgressEventFilter {
        public ProgressEvent filter(ProgressEvent var1);
    }
}

