/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.retry;

import com.cloudera.com.amazonaws.AmazonServiceException;

public class RetryUtils {
    public static boolean isThrottlingException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        String errorCode = ase.getErrorCode();
        return "Throttling".equals(errorCode) || "ThrottlingException".equals(errorCode) || "ProvisionedThroughputExceededException".equals(errorCode);
    }

    public static boolean isRequestEntityTooLargeException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        return "Request entity too large".equals(ase.getErrorCode());
    }

    public static boolean isClockSkewError(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        String errorCode = ase.getErrorCode();
        return "RequestTimeTooSkewed".equals(errorCode) || "RequestExpired".equals(errorCode) || "InvalidSignatureException".equals(errorCode) || "SignatureDoesNotMatch".equals(errorCode);
    }
}

