/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.autoscaling;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.AmazonWebServiceClient;
import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.Response;
import com.cloudera.com.amazonaws.ResponseMetadata;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.cloudera.com.amazonaws.handlers.HandlerChainFactory;
import com.cloudera.com.amazonaws.http.DefaultErrorResponseHandler;
import com.cloudera.com.amazonaws.http.ExecutionContext;
import com.cloudera.com.amazonaws.http.StaxResponseHandler;
import com.cloudera.com.amazonaws.internal.StaticCredentialsProvider;
import com.cloudera.com.amazonaws.metrics.RequestMetricCollector;
import com.cloudera.com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.cloudera.com.amazonaws.services.autoscaling.model.AttachInstancesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DeletePolicyRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DeleteTagsRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeAccountLimitsResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribePoliciesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribePoliciesResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeScheduledActionsResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeTagsRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeTagsResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.ExecutePolicyRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.PutScalingPolicyResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResult;
import com.cloudera.com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.AttachInstancesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.CreateAutoScalingGroupRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.CreateLaunchConfigurationRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.CreateOrUpdateTagsRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DeleteAutoScalingGroupRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DeleteLaunchConfigurationRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DeleteNotificationConfigurationRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DeletePolicyRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DeleteScheduledActionRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DeleteTagsRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeAccountLimitsRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeAccountLimitsResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeAdjustmentTypesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeAdjustmentTypesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingGroupsRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingGroupsResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingInstancesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingInstancesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingNotificationTypesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingNotificationTypesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeLaunchConfigurationsRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeLaunchConfigurationsResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeMetricCollectionTypesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeMetricCollectionTypesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeNotificationConfigurationsRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeNotificationConfigurationsResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribePoliciesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribePoliciesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeScalingActivitiesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeScalingActivitiesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeScalingProcessTypesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeScalingProcessTypesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeScheduledActionsRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeScheduledActionsResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeTagsRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeTagsResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeTerminationPolicyTypesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DescribeTerminationPolicyTypesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.DisableMetricsCollectionRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.EnableMetricsCollectionRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.ExecutePolicyRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.LimitExceededExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.PutNotificationConfigurationRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.PutScalingPolicyRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.PutScalingPolicyResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.PutScheduledUpdateGroupActionRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.ResourceInUseExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.ResumeProcessesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.ScalingActivityInProgressExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.SetDesiredCapacityRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.SetInstanceHealthRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.SuspendProcessesRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.TerminateInstanceInAutoScalingGroupRequestMarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.TerminateInstanceInAutoScalingGroupResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.autoscaling.model.transform.UpdateAutoScalingGroupRequestMarshaller;
import com.cloudera.com.amazonaws.transform.StandardErrorUnmarshaller;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import com.cloudera.com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonAutoScalingClient
extends AmazonWebServiceClient
implements AmazonAutoScaling {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonAutoScalingClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonAutoScalingClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonAutoScalingClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonAutoScalingClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonAutoScalingClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonAutoScalingClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonAutoScalingClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ScalingActivityInProgressExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("autoscaling.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/cloudera/com/amazonaws/services/autoscaling/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/cloudera/com/amazonaws/services/autoscaling/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountLimitsResult describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAccountLimitsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeAccountLimitsRequest> request = null;
        Response<DescribeAccountLimitsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeAccountLimitsRequestMarshaller().marshall(describeAccountLimitsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeAccountLimitsResultStaxUnmarshaller(), executionContext);
            DescribeAccountLimitsResult describeAccountLimitsResult = response.getAwsResponse();
            return describeAccountLimitsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoScalingGroupsResult describeAutoScalingGroups(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAutoScalingGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeAutoScalingGroupsRequest> request = null;
        Response<DescribeAutoScalingGroupsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeAutoScalingGroupsRequestMarshaller().marshall(describeAutoScalingGroupsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeAutoScalingGroupsResultStaxUnmarshaller(), executionContext);
            DescribeAutoScalingGroupsResult describeAutoScalingGroupsResult = response.getAwsResponse();
            return describeAutoScalingGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableMetricsCollection(EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableMetricsCollectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<EnableMetricsCollectionRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new EnableMetricsCollectionRequestMarshaller().marshall(enableMetricsCollectionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeProcesses(ResumeProcessesRequest resumeProcessesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resumeProcessesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ResumeProcessesRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ResumeProcessesRequestMarshaller().marshall(resumeProcessesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteLaunchConfiguration(DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLaunchConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteLaunchConfigurationRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteLaunchConfigurationRequestMarshaller().marshall(deleteLaunchConfigurationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePoliciesResult describePolicies(DescribePoliciesRequest describePoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribePoliciesRequest> request = null;
        Response<DescribePoliciesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribePoliciesRequestMarshaller().marshall(describePoliciesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribePoliciesResultStaxUnmarshaller(), executionContext);
            DescribePoliciesResult describePoliciesResult = response.getAwsResponse();
            return describePoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingProcessTypesResult describeScalingProcessTypes(DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScalingProcessTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeScalingProcessTypesRequest> request = null;
        Response<DescribeScalingProcessTypesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeScalingProcessTypesRequestMarshaller().marshall(describeScalingProcessTypesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeScalingProcessTypesResultStaxUnmarshaller(), executionContext);
            DescribeScalingProcessTypesResult describeScalingProcessTypesResult = response.getAwsResponse();
            return describeScalingProcessTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAutoScalingGroup(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAutoScalingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateAutoScalingGroupRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateAutoScalingGroupRequestMarshaller().marshall(createAutoScalingGroupRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachInstances(AttachInstancesRequest attachInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(attachInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<AttachInstancesRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new AttachInstancesRequestMarshaller().marshall(attachInstancesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingActivitiesResult describeScalingActivities(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScalingActivitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeScalingActivitiesRequest> request = null;
        Response<DescribeScalingActivitiesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeScalingActivitiesRequestMarshaller().marshall(describeScalingActivitiesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeScalingActivitiesResultStaxUnmarshaller(), executionContext);
            DescribeScalingActivitiesResult describeScalingActivitiesResult = response.getAwsResponse();
            return describeScalingActivitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNotificationConfigurationsResult describeNotificationConfigurations(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeNotificationConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeNotificationConfigurationsRequest> request = null;
        Response<DescribeNotificationConfigurationsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeNotificationConfigurationsRequestMarshaller().marshall(describeNotificationConfigurationsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeNotificationConfigurationsResultStaxUnmarshaller(), executionContext);
            DescribeNotificationConfigurationsResult describeNotificationConfigurationsResult = response.getAwsResponse();
            return describeNotificationConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTerminationPolicyTypesResult describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTerminationPolicyTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeTerminationPolicyTypesRequest> request = null;
        Response<DescribeTerminationPolicyTypesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeTerminationPolicyTypesRequestMarshaller().marshall(describeTerminationPolicyTypesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeTerminationPolicyTypesResultStaxUnmarshaller(), executionContext);
            DescribeTerminationPolicyTypesResult describeTerminationPolicyTypesResult = response.getAwsResponse();
            return describeTerminationPolicyTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResult describeTags(DescribeTagsRequest describeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeTagsRequest> request = null;
        Response<DescribeTagsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeTagsRequestMarshaller().marshall(describeTagsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeTagsResultStaxUnmarshaller(), executionContext);
            DescribeTagsResult describeTagsResult = response.getAwsResponse();
            return describeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTags(DeleteTagsRequest deleteTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteTagsRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteTagsRequestMarshaller().marshall(deleteTagsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executePolicy(ExecutePolicyRequest executePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(executePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ExecutePolicyRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ExecutePolicyRequestMarshaller().marshall(executePolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutScalingPolicyResult putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putScalingPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<PutScalingPolicyRequest> request = null;
        Response<PutScalingPolicyResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new PutScalingPolicyRequestMarshaller().marshall(putScalingPolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new PutScalingPolicyResultStaxUnmarshaller(), executionContext);
            PutScalingPolicyResult putScalingPolicyResult = response.getAwsResponse();
            return putScalingPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putNotificationConfiguration(PutNotificationConfigurationRequest putNotificationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putNotificationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<PutNotificationConfigurationRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new PutNotificationConfigurationRequestMarshaller().marshall(putNotificationConfigurationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeletePolicyRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeletePolicyRequestMarshaller().marshall(deletePolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNotificationConfiguration(DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNotificationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteNotificationConfigurationRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteNotificationConfigurationRequestMarshaller().marshall(deleteNotificationConfigurationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteScheduledActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteScheduledActionRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteScheduledActionRequestMarshaller().marshall(deleteScheduledActionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInstanceHealth(SetInstanceHealthRequest setInstanceHealthRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setInstanceHealthRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetInstanceHealthRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetInstanceHealthRequestMarshaller().marshall(setInstanceHealthRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoScalingNotificationTypesResult describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAutoScalingNotificationTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeAutoScalingNotificationTypesRequest> request = null;
        Response<DescribeAutoScalingNotificationTypesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeAutoScalingNotificationTypesRequestMarshaller().marshall(describeAutoScalingNotificationTypesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeAutoScalingNotificationTypesResultStaxUnmarshaller(), executionContext);
            DescribeAutoScalingNotificationTypesResult describeAutoScalingNotificationTypesResult = response.getAwsResponse();
            return describeAutoScalingNotificationTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOrUpdateTags(CreateOrUpdateTagsRequest createOrUpdateTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createOrUpdateTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateOrUpdateTagsRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateOrUpdateTagsRequestMarshaller().marshall(createOrUpdateTagsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendProcesses(SuspendProcessesRequest suspendProcessesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(suspendProcessesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SuspendProcessesRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SuspendProcessesRequestMarshaller().marshall(suspendProcessesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createLaunchConfiguration(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLaunchConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateLaunchConfigurationRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateLaunchConfigurationRequestMarshaller().marshall(createLaunchConfigurationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoScalingInstancesResult describeAutoScalingInstances(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAutoScalingInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeAutoScalingInstancesRequest> request = null;
        Response<DescribeAutoScalingInstancesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeAutoScalingInstancesRequestMarshaller().marshall(describeAutoScalingInstancesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeAutoScalingInstancesResultStaxUnmarshaller(), executionContext);
            DescribeAutoScalingInstancesResult describeAutoScalingInstancesResult = response.getAwsResponse();
            return describeAutoScalingInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAutoScalingGroup(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAutoScalingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteAutoScalingGroupRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteAutoScalingGroupRequestMarshaller().marshall(deleteAutoScalingGroupRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableMetricsCollection(DisableMetricsCollectionRequest disableMetricsCollectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableMetricsCollectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DisableMetricsCollectionRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DisableMetricsCollectionRequestMarshaller().marshall(disableMetricsCollectionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAutoScalingGroup(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAutoScalingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateAutoScalingGroupRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateAutoScalingGroupRequestMarshaller().marshall(updateAutoScalingGroupRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLaunchConfigurationsResult describeLaunchConfigurations(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLaunchConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeLaunchConfigurationsRequest> request = null;
        Response<DescribeLaunchConfigurationsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeLaunchConfigurationsRequestMarshaller().marshall(describeLaunchConfigurationsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeLaunchConfigurationsResultStaxUnmarshaller(), executionContext);
            DescribeLaunchConfigurationsResult describeLaunchConfigurationsResult = response.getAwsResponse();
            return describeLaunchConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAdjustmentTypesResult describeAdjustmentTypes(DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAdjustmentTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeAdjustmentTypesRequest> request = null;
        Response<DescribeAdjustmentTypesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeAdjustmentTypesRequestMarshaller().marshall(describeAdjustmentTypesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeAdjustmentTypesResultStaxUnmarshaller(), executionContext);
            DescribeAdjustmentTypesResult describeAdjustmentTypesResult = response.getAwsResponse();
            return describeAdjustmentTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScheduledActionsResult describeScheduledActions(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScheduledActionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeScheduledActionsRequest> request = null;
        Response<DescribeScheduledActionsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeScheduledActionsRequestMarshaller().marshall(describeScheduledActionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeScheduledActionsResultStaxUnmarshaller(), executionContext);
            DescribeScheduledActionsResult describeScheduledActionsResult = response.getAwsResponse();
            return describeScheduledActionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putScheduledUpdateGroupAction(PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putScheduledUpdateGroupActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<PutScheduledUpdateGroupActionRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new PutScheduledUpdateGroupActionRequestMarshaller().marshall(putScheduledUpdateGroupActionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetricCollectionTypesResult describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMetricCollectionTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeMetricCollectionTypesRequest> request = null;
        Response<DescribeMetricCollectionTypesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeMetricCollectionTypesRequestMarshaller().marshall(describeMetricCollectionTypesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeMetricCollectionTypesResultStaxUnmarshaller(), executionContext);
            DescribeMetricCollectionTypesResult describeMetricCollectionTypesResult = response.getAwsResponse();
            return describeMetricCollectionTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setDesiredCapacityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetDesiredCapacityRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetDesiredCapacityRequestMarshaller().marshall(setDesiredCapacityRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateInstanceInAutoScalingGroupResult terminateInstanceInAutoScalingGroup(TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(terminateInstanceInAutoScalingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<TerminateInstanceInAutoScalingGroupRequest> request = null;
        Response<TerminateInstanceInAutoScalingGroupResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new TerminateInstanceInAutoScalingGroupRequestMarshaller().marshall(terminateInstanceInAutoScalingGroupRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new TerminateInstanceInAutoScalingGroupResultStaxUnmarshaller(), executionContext);
            TerminateInstanceInAutoScalingGroupResult terminateInstanceInAutoScalingGroupResult = response.getAwsResponse();
            return terminateInstanceInAutoScalingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAccountLimitsResult describeAccountLimits() throws AmazonServiceException, AmazonClientException {
        return this.describeAccountLimits(new DescribeAccountLimitsRequest());
    }

    @Override
    public DescribeAutoScalingGroupsResult describeAutoScalingGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest());
    }

    @Override
    public DescribePoliciesResult describePolicies() throws AmazonServiceException, AmazonClientException {
        return this.describePolicies(new DescribePoliciesRequest());
    }

    @Override
    public DescribeScalingProcessTypesResult describeScalingProcessTypes() throws AmazonServiceException, AmazonClientException {
        return this.describeScalingProcessTypes(new DescribeScalingProcessTypesRequest());
    }

    @Override
    public DescribeScalingActivitiesResult describeScalingActivities() throws AmazonServiceException, AmazonClientException {
        return this.describeScalingActivities(new DescribeScalingActivitiesRequest());
    }

    @Override
    public DescribeNotificationConfigurationsResult describeNotificationConfigurations() throws AmazonServiceException, AmazonClientException {
        return this.describeNotificationConfigurations(new DescribeNotificationConfigurationsRequest());
    }

    @Override
    public DescribeTerminationPolicyTypesResult describeTerminationPolicyTypes() throws AmazonServiceException, AmazonClientException {
        return this.describeTerminationPolicyTypes(new DescribeTerminationPolicyTypesRequest());
    }

    @Override
    public DescribeTagsResult describeTags() throws AmazonServiceException, AmazonClientException {
        return this.describeTags(new DescribeTagsRequest());
    }

    @Override
    public DescribeAutoScalingNotificationTypesResult describeAutoScalingNotificationTypes() throws AmazonServiceException, AmazonClientException {
        return this.describeAutoScalingNotificationTypes(new DescribeAutoScalingNotificationTypesRequest());
    }

    @Override
    public DescribeAutoScalingInstancesResult describeAutoScalingInstances() throws AmazonServiceException, AmazonClientException {
        return this.describeAutoScalingInstances(new DescribeAutoScalingInstancesRequest());
    }

    @Override
    public DescribeLaunchConfigurationsResult describeLaunchConfigurations() throws AmazonServiceException, AmazonClientException {
        return this.describeLaunchConfigurations(new DescribeLaunchConfigurationsRequest());
    }

    @Override
    public DescribeAdjustmentTypesResult describeAdjustmentTypes() throws AmazonServiceException, AmazonClientException {
        return this.describeAdjustmentTypes(new DescribeAdjustmentTypesRequest());
    }

    @Override
    public DescribeScheduledActionsResult describeScheduledActions() throws AmazonServiceException, AmazonClientException {
        return this.describeScheduledActions(new DescribeScheduledActionsRequest());
    }

    @Override
    public DescribeMetricCollectionTypesResult describeMetricCollectionTypes() throws AmazonServiceException, AmazonClientException {
        return this.describeMetricCollectionTypes(new DescribeMetricCollectionTypesRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

