/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudfront.model.transform;

import com.cloudera.com.amazonaws.services.cloudfront.model.Signer;
import com.cloudera.com.amazonaws.services.cloudfront.model.transform.KeyPairIdsStaxUnmarshaller;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignerStaxUnmarshaller
implements Unmarshaller<Signer, StaxUnmarshallerContext> {
    private static SignerStaxUnmarshaller instance;

    @Override
    public Signer unmarshall(StaxUnmarshallerContext context) throws Exception {
        Signer signer = new Signer();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return signer;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AwsAccountNumber", targetDepth)) {
                    signer.setAwsAccountNumber(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("KeyPairIds", targetDepth)) continue;
                signer.setKeyPairIds(KeyPairIdsStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return signer;
    }

    public static SignerStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SignerStaxUnmarshaller();
        }
        return instance;
    }
}

