/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudfront_2012_03_15.model.transform;

import com.cloudera.com.amazonaws.services.cloudfront_2012_03_15.model.InvalidationList;
import com.cloudera.com.amazonaws.services.cloudfront_2012_03_15.model.transform.InvalidationSummaryStaxUnmarshaller;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationListStaxUnmarshaller
implements Unmarshaller<InvalidationList, StaxUnmarshallerContext> {
    private static InvalidationListStaxUnmarshaller instance;

    @Override
    public InvalidationList unmarshall(StaxUnmarshallerContext context) throws Exception {
        InvalidationList invalidationList = new InvalidationList();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return invalidationList;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Marker", targetDepth)) {
                    invalidationList.setMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NextMarker", targetDepth)) {
                    invalidationList.setNextMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxItems", targetDepth)) {
                    invalidationList.setMaxItems(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsTruncated", targetDepth)) {
                    invalidationList.setIsTruncated(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("InvalidationSummary", targetDepth)) continue;
                invalidationList.getInvalidationSummaries().add(InvalidationSummaryStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return invalidationList;
    }

    public static InvalidationListStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InvalidationListStaxUnmarshaller();
        }
        return instance;
    }
}

