/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudfront_2012_03_15.model.transform;

import com.cloudera.com.amazonaws.services.cloudfront_2012_03_15.model.S3Origin;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3OriginStaxUnmarshaller
implements Unmarshaller<S3Origin, StaxUnmarshallerContext> {
    private static S3OriginStaxUnmarshaller instance;

    @Override
    public S3Origin unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3Origin s3Origin = new S3Origin();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3Origin;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DNSName", targetDepth)) {
                    s3Origin.setDNSName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OriginAccessIdentity", targetDepth)) continue;
                s3Origin.setOriginAccessIdentity(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3Origin;
    }

    public static S3OriginStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3OriginStaxUnmarshaller();
        }
        return instance;
    }
}

