/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudwatch;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.AmazonWebServiceClient;
import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.Response;
import com.cloudera.com.amazonaws.ResponseMetadata;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.cloudera.com.amazonaws.handlers.HandlerChainFactory;
import com.cloudera.com.amazonaws.http.DefaultErrorResponseHandler;
import com.cloudera.com.amazonaws.http.ExecutionContext;
import com.cloudera.com.amazonaws.http.StaxResponseHandler;
import com.cloudera.com.amazonaws.internal.StaticCredentialsProvider;
import com.cloudera.com.amazonaws.metrics.RequestMetricCollector;
import com.cloudera.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.cloudera.com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryResult;
import com.cloudera.com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricResult;
import com.cloudera.com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.cloudera.com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.cloudera.com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.cloudera.com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.DeleteAlarmsRequestMarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmHistoryRequestMarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmHistoryResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsForMetricRequestMarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsForMetricResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsRequestMarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.DisableAlarmActionsRequestMarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.EnableAlarmActionsRequestMarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.GetMetricStatisticsRequestMarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.GetMetricStatisticsResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.InternalServiceExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.InvalidFormatExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.InvalidParameterCombinationExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.LimitExceededExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.ListMetricsRequestMarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.ListMetricsResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.MissingRequiredParameterExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.PutMetricAlarmRequestMarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.PutMetricDataRequestMarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.cloudwatch.model.transform.SetAlarmStateRequestMarshaller;
import com.cloudera.com.amazonaws.transform.StandardErrorUnmarshaller;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import com.cloudera.com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudWatchClient
extends AmazonWebServiceClient
implements AmazonCloudWatch {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonCloudWatchClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCloudWatchClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCloudWatchClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudWatchClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudWatchClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCloudWatchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonCloudWatchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterCombinationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidFormatExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingRequiredParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("monitoring.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/cloudera/com/amazonaws/services/cloudwatch/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/cloudera/com/amazonaws/services/cloudwatch/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putMetricAlarm(PutMetricAlarmRequest putMetricAlarmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putMetricAlarmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<PutMetricAlarmRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new PutMetricAlarmRequestMarshaller().marshall(putMetricAlarmRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putMetricData(PutMetricDataRequest putMetricDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putMetricDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<PutMetricDataRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new PutMetricDataRequestMarshaller().marshall(putMetricDataRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMetricsResult listMetrics(ListMetricsRequest listMetricsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMetricsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListMetricsRequest> request = null;
        Response<ListMetricsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListMetricsRequestMarshaller().marshall(listMetricsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListMetricsResultStaxUnmarshaller(), executionContext);
            ListMetricsResult listMetricsResult = response.getAwsResponse();
            return listMetricsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMetricStatisticsResult getMetricStatistics(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMetricStatisticsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetMetricStatisticsRequest> request = null;
        Response<GetMetricStatisticsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetMetricStatisticsRequestMarshaller().marshall(getMetricStatisticsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetMetricStatisticsResultStaxUnmarshaller(), executionContext);
            GetMetricStatisticsResult getMetricStatisticsResult = response.getAwsResponse();
            return getMetricStatisticsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableAlarmActions(DisableAlarmActionsRequest disableAlarmActionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableAlarmActionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DisableAlarmActionsRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DisableAlarmActionsRequestMarshaller().marshall(disableAlarmActionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmsResult describeAlarms(DescribeAlarmsRequest describeAlarmsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAlarmsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeAlarmsRequest> request = null;
        Response<DescribeAlarmsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeAlarmsRequestMarshaller().marshall(describeAlarmsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeAlarmsResultStaxUnmarshaller(), executionContext);
            DescribeAlarmsResult describeAlarmsResult = response.getAwsResponse();
            return describeAlarmsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmsForMetricResult describeAlarmsForMetric(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAlarmsForMetricRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeAlarmsForMetricRequest> request = null;
        Response<DescribeAlarmsForMetricResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeAlarmsForMetricRequestMarshaller().marshall(describeAlarmsForMetricRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeAlarmsForMetricResultStaxUnmarshaller(), executionContext);
            DescribeAlarmsForMetricResult describeAlarmsForMetricResult = response.getAwsResponse();
            return describeAlarmsForMetricResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmHistoryResult describeAlarmHistory(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAlarmHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeAlarmHistoryRequest> request = null;
        Response<DescribeAlarmHistoryResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeAlarmHistoryRequestMarshaller().marshall(describeAlarmHistoryRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeAlarmHistoryResultStaxUnmarshaller(), executionContext);
            DescribeAlarmHistoryResult describeAlarmHistoryResult = response.getAwsResponse();
            return describeAlarmHistoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableAlarmActions(EnableAlarmActionsRequest enableAlarmActionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableAlarmActionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<EnableAlarmActionsRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new EnableAlarmActionsRequestMarshaller().marshall(enableAlarmActionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAlarms(DeleteAlarmsRequest deleteAlarmsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAlarmsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteAlarmsRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteAlarmsRequestMarshaller().marshall(deleteAlarmsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlarmState(SetAlarmStateRequest setAlarmStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setAlarmStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetAlarmStateRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetAlarmStateRequestMarshaller().marshall(setAlarmStateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    @Override
    public ListMetricsResult listMetrics() throws AmazonServiceException, AmazonClientException {
        return this.listMetrics(new ListMetricsRequest());
    }

    @Override
    public DescribeAlarmsResult describeAlarms() throws AmazonServiceException, AmazonClientException {
        return this.describeAlarms(new DescribeAlarmsRequest());
    }

    @Override
    public DescribeAlarmHistoryResult describeAlarmHistory() throws AmazonServiceException, AmazonClientException {
        return this.describeAlarmHistory(new DescribeAlarmHistoryRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

