/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.directconnect;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.AmazonWebServiceClient;
import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.AmazonWebServiceResponse;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.Response;
import com.cloudera.com.amazonaws.ResponseMetadata;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.cloudera.com.amazonaws.handlers.HandlerChainFactory;
import com.cloudera.com.amazonaws.http.ExecutionContext;
import com.cloudera.com.amazonaws.http.HttpResponseHandler;
import com.cloudera.com.amazonaws.http.JsonErrorResponseHandler;
import com.cloudera.com.amazonaws.http.JsonResponseHandler;
import com.cloudera.com.amazonaws.internal.StaticCredentialsProvider;
import com.cloudera.com.amazonaws.metrics.RequestMetricCollector;
import com.cloudera.com.amazonaws.services.directconnect.AmazonDirectConnect;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectResult;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmConnectionRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmConnectionResult;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.CreateConnectionRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.CreateConnectionResult;
import com.cloudera.com.amazonaws.services.directconnect.model.CreateInterconnectRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.CreateInterconnectResult;
import com.cloudera.com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteConnectionRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteConnectionResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteInterconnectRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteInterconnectResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeConnectionsRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeConnectionsResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeInterconnectsResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeLocationsRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeLocationsResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysResult;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest;
import com.cloudera.com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesResult;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.AllocateConnectionOnInterconnectRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.AllocateConnectionOnInterconnectResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.AllocatePrivateVirtualInterfaceRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.AllocatePrivateVirtualInterfaceResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.AllocatePublicVirtualInterfaceRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.AllocatePublicVirtualInterfaceResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.ConfirmConnectionRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.ConfirmConnectionResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.ConfirmPrivateVirtualInterfaceRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.ConfirmPrivateVirtualInterfaceResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.ConfirmPublicVirtualInterfaceRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.ConfirmPublicVirtualInterfaceResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.CreateConnectionRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.CreateConnectionResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.CreateInterconnectRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.CreateInterconnectResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.CreatePrivateVirtualInterfaceRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.CreatePrivateVirtualInterfaceResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.CreatePublicVirtualInterfaceRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.CreatePublicVirtualInterfaceResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DeleteConnectionRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DeleteConnectionResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DeleteInterconnectRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DeleteInterconnectResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DeleteVirtualInterfaceRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DeleteVirtualInterfaceResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeConnectionsOnInterconnectRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeConnectionsOnInterconnectResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeConnectionsRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeConnectionsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeInterconnectsRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeInterconnectsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeLocationsRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeLocationsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeVirtualGatewaysRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeVirtualGatewaysResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeVirtualInterfacesRequestMarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DescribeVirtualInterfacesResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DirectConnectClientExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.directconnect.model.transform.DirectConnectServerExceptionUnmarshaller;
import com.cloudera.com.amazonaws.transform.JsonErrorUnmarshaller;
import com.cloudera.com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonDirectConnectClient
extends AmazonWebServiceClient
implements AmazonDirectConnect {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonDirectConnect.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonDirectConnectClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonDirectConnectClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonDirectConnectClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonDirectConnectClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonDirectConnectClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonDirectConnectClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonDirectConnectClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonDirectConnectClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonDirectConnectClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new DirectConnectServerExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DirectConnectClientExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("directconnect.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/cloudera/com/amazonaws/services/directconnect/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/cloudera/com/amazonaws/services/directconnect/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLocationsResult describeLocations(DescribeLocationsRequest describeLocationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLocationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLocationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLocationsRequestMarshaller().marshall(describeLocationsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeLocationsResultJsonUnmarshaller unmarshaller = new DescribeLocationsResultJsonUnmarshaller();
            JsonResponseHandler<DescribeLocationsResult> responseHandler = new JsonResponseHandler<DescribeLocationsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLocationsResult describeLocationsResult = (DescribeLocationsResult)response.getAwsResponse();
            return describeLocationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmPublicVirtualInterfaceResult confirmPublicVirtualInterface(ConfirmPublicVirtualInterfaceRequest confirmPublicVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(confirmPublicVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfirmPublicVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConfirmPublicVirtualInterfaceRequestMarshaller().marshall(confirmPublicVirtualInterfaceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ConfirmPublicVirtualInterfaceResultJsonUnmarshaller unmarshaller = new ConfirmPublicVirtualInterfaceResultJsonUnmarshaller();
            JsonResponseHandler<ConfirmPublicVirtualInterfaceResult> responseHandler = new JsonResponseHandler<ConfirmPublicVirtualInterfaceResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ConfirmPublicVirtualInterfaceResult confirmPublicVirtualInterfaceResult = (ConfirmPublicVirtualInterfaceResult)response.getAwsResponse();
            return confirmPublicVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePrivateVirtualInterfaceResult createPrivateVirtualInterface(CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPrivateVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePrivateVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePrivateVirtualInterfaceRequestMarshaller().marshall(createPrivateVirtualInterfaceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreatePrivateVirtualInterfaceResultJsonUnmarshaller unmarshaller = new CreatePrivateVirtualInterfaceResultJsonUnmarshaller();
            JsonResponseHandler<CreatePrivateVirtualInterfaceResult> responseHandler = new JsonResponseHandler<CreatePrivateVirtualInterfaceResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreatePrivateVirtualInterfaceResult createPrivateVirtualInterfaceResult = (CreatePrivateVirtualInterfaceResult)response.getAwsResponse();
            return createPrivateVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualInterfaceResult deleteVirtualInterface(DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVirtualInterfaceRequestMarshaller().marshall(deleteVirtualInterfaceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteVirtualInterfaceResultJsonUnmarshaller unmarshaller = new DeleteVirtualInterfaceResultJsonUnmarshaller();
            JsonResponseHandler<DeleteVirtualInterfaceResult> responseHandler = new JsonResponseHandler<DeleteVirtualInterfaceResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteVirtualInterfaceResult deleteVirtualInterfaceResult = (DeleteVirtualInterfaceResult)response.getAwsResponse();
            return deleteVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePublicVirtualInterfaceResult createPublicVirtualInterface(CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPublicVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePublicVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePublicVirtualInterfaceRequestMarshaller().marshall(createPublicVirtualInterfaceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreatePublicVirtualInterfaceResultJsonUnmarshaller unmarshaller = new CreatePublicVirtualInterfaceResultJsonUnmarshaller();
            JsonResponseHandler<CreatePublicVirtualInterfaceResult> responseHandler = new JsonResponseHandler<CreatePublicVirtualInterfaceResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreatePublicVirtualInterfaceResult createPublicVirtualInterfaceResult = (CreatePublicVirtualInterfaceResult)response.getAwsResponse();
            return createPublicVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInterconnectResult createInterconnect(CreateInterconnectRequest createInterconnectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateInterconnectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateInterconnectRequestMarshaller().marshall(createInterconnectRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateInterconnectResultJsonUnmarshaller unmarshaller = new CreateInterconnectResultJsonUnmarshaller();
            JsonResponseHandler<CreateInterconnectResult> responseHandler = new JsonResponseHandler<CreateInterconnectResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateInterconnectResult createInterconnectResult = (CreateInterconnectResult)response.getAwsResponse();
            return createInterconnectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualInterfacesResult describeVirtualInterfaces(DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeVirtualInterfacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVirtualInterfacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVirtualInterfacesRequestMarshaller().marshall(describeVirtualInterfacesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeVirtualInterfacesResultJsonUnmarshaller unmarshaller = new DescribeVirtualInterfacesResultJsonUnmarshaller();
            JsonResponseHandler<DescribeVirtualInterfacesResult> responseHandler = new JsonResponseHandler<DescribeVirtualInterfacesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeVirtualInterfacesResult describeVirtualInterfacesResult = (DescribeVirtualInterfacesResult)response.getAwsResponse();
            return describeVirtualInterfacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmConnectionResult confirmConnection(ConfirmConnectionRequest confirmConnectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(confirmConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfirmConnectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConfirmConnectionRequestMarshaller().marshall(confirmConnectionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ConfirmConnectionResultJsonUnmarshaller unmarshaller = new ConfirmConnectionResultJsonUnmarshaller();
            JsonResponseHandler<ConfirmConnectionResult> responseHandler = new JsonResponseHandler<ConfirmConnectionResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ConfirmConnectionResult confirmConnectionResult = (ConfirmConnectionResult)response.getAwsResponse();
            return confirmConnectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInterconnectsResult describeInterconnects(DescribeInterconnectsRequest describeInterconnectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInterconnectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInterconnectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInterconnectsRequestMarshaller().marshall(describeInterconnectsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeInterconnectsResultJsonUnmarshaller unmarshaller = new DescribeInterconnectsResultJsonUnmarshaller();
            JsonResponseHandler<DescribeInterconnectsResult> responseHandler = new JsonResponseHandler<DescribeInterconnectsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInterconnectsResult describeInterconnectsResult = (DescribeInterconnectsResult)response.getAwsResponse();
            return describeInterconnectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualGatewaysResult describeVirtualGateways(DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeVirtualGatewaysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVirtualGatewaysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVirtualGatewaysRequestMarshaller().marshall(describeVirtualGatewaysRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeVirtualGatewaysResultJsonUnmarshaller unmarshaller = new DescribeVirtualGatewaysResultJsonUnmarshaller();
            JsonResponseHandler<DescribeVirtualGatewaysResult> responseHandler = new JsonResponseHandler<DescribeVirtualGatewaysResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeVirtualGatewaysResult describeVirtualGatewaysResult = (DescribeVirtualGatewaysResult)response.getAwsResponse();
            return describeVirtualGatewaysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmPrivateVirtualInterfaceResult confirmPrivateVirtualInterface(ConfirmPrivateVirtualInterfaceRequest confirmPrivateVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(confirmPrivateVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfirmPrivateVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConfirmPrivateVirtualInterfaceRequestMarshaller().marshall(confirmPrivateVirtualInterfaceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ConfirmPrivateVirtualInterfaceResultJsonUnmarshaller unmarshaller = new ConfirmPrivateVirtualInterfaceResultJsonUnmarshaller();
            JsonResponseHandler<ConfirmPrivateVirtualInterfaceResult> responseHandler = new JsonResponseHandler<ConfirmPrivateVirtualInterfaceResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ConfirmPrivateVirtualInterfaceResult confirmPrivateVirtualInterfaceResult = (ConfirmPrivateVirtualInterfaceResult)response.getAwsResponse();
            return confirmPrivateVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionsResult describeConnections(DescribeConnectionsRequest describeConnectionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConnectionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConnectionsRequestMarshaller().marshall(describeConnectionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeConnectionsResultJsonUnmarshaller unmarshaller = new DescribeConnectionsResultJsonUnmarshaller();
            JsonResponseHandler<DescribeConnectionsResult> responseHandler = new JsonResponseHandler<DescribeConnectionsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConnectionsResult describeConnectionsResult = (DescribeConnectionsResult)response.getAwsResponse();
            return describeConnectionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocatePublicVirtualInterfaceResult allocatePublicVirtualInterface(AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(allocatePublicVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AllocatePublicVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AllocatePublicVirtualInterfaceRequestMarshaller().marshall(allocatePublicVirtualInterfaceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            AllocatePublicVirtualInterfaceResultJsonUnmarshaller unmarshaller = new AllocatePublicVirtualInterfaceResultJsonUnmarshaller();
            JsonResponseHandler<AllocatePublicVirtualInterfaceResult> responseHandler = new JsonResponseHandler<AllocatePublicVirtualInterfaceResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            AllocatePublicVirtualInterfaceResult allocatePublicVirtualInterfaceResult = (AllocatePublicVirtualInterfaceResult)response.getAwsResponse();
            return allocatePublicVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocatePrivateVirtualInterfaceResult allocatePrivateVirtualInterface(AllocatePrivateVirtualInterfaceRequest allocatePrivateVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(allocatePrivateVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AllocatePrivateVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AllocatePrivateVirtualInterfaceRequestMarshaller().marshall(allocatePrivateVirtualInterfaceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            AllocatePrivateVirtualInterfaceResultJsonUnmarshaller unmarshaller = new AllocatePrivateVirtualInterfaceResultJsonUnmarshaller();
            JsonResponseHandler<AllocatePrivateVirtualInterfaceResult> responseHandler = new JsonResponseHandler<AllocatePrivateVirtualInterfaceResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            AllocatePrivateVirtualInterfaceResult allocatePrivateVirtualInterfaceResult = (AllocatePrivateVirtualInterfaceResult)response.getAwsResponse();
            return allocatePrivateVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectionResult deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConnectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConnectionRequestMarshaller().marshall(deleteConnectionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteConnectionResultJsonUnmarshaller unmarshaller = new DeleteConnectionResultJsonUnmarshaller();
            JsonResponseHandler<DeleteConnectionResult> responseHandler = new JsonResponseHandler<DeleteConnectionResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteConnectionResult deleteConnectionResult = (DeleteConnectionResult)response.getAwsResponse();
            return deleteConnectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionsOnInterconnectResult describeConnectionsOnInterconnect(DescribeConnectionsOnInterconnectRequest describeConnectionsOnInterconnectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectionsOnInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConnectionsOnInterconnectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConnectionsOnInterconnectRequestMarshaller().marshall(describeConnectionsOnInterconnectRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeConnectionsOnInterconnectResultJsonUnmarshaller unmarshaller = new DescribeConnectionsOnInterconnectResultJsonUnmarshaller();
            JsonResponseHandler<DescribeConnectionsOnInterconnectResult> responseHandler = new JsonResponseHandler<DescribeConnectionsOnInterconnectResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConnectionsOnInterconnectResult describeConnectionsOnInterconnectResult = (DescribeConnectionsOnInterconnectResult)response.getAwsResponse();
            return describeConnectionsOnInterconnectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateConnectionOnInterconnectResult allocateConnectionOnInterconnect(AllocateConnectionOnInterconnectRequest allocateConnectionOnInterconnectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(allocateConnectionOnInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AllocateConnectionOnInterconnectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AllocateConnectionOnInterconnectRequestMarshaller().marshall(allocateConnectionOnInterconnectRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            AllocateConnectionOnInterconnectResultJsonUnmarshaller unmarshaller = new AllocateConnectionOnInterconnectResultJsonUnmarshaller();
            JsonResponseHandler<AllocateConnectionOnInterconnectResult> responseHandler = new JsonResponseHandler<AllocateConnectionOnInterconnectResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            AllocateConnectionOnInterconnectResult allocateConnectionOnInterconnectResult = (AllocateConnectionOnInterconnectResult)response.getAwsResponse();
            return allocateConnectionOnInterconnectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectionResult createConnection(CreateConnectionRequest createConnectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateConnectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateConnectionRequestMarshaller().marshall(createConnectionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateConnectionResultJsonUnmarshaller unmarshaller = new CreateConnectionResultJsonUnmarshaller();
            JsonResponseHandler<CreateConnectionResult> responseHandler = new JsonResponseHandler<CreateConnectionResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateConnectionResult createConnectionResult = (CreateConnectionResult)response.getAwsResponse();
            return createConnectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInterconnectResult deleteInterconnect(DeleteInterconnectRequest deleteInterconnectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInterconnectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInterconnectRequestMarshaller().marshall(deleteInterconnectRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteInterconnectResultJsonUnmarshaller unmarshaller = new DeleteInterconnectResultJsonUnmarshaller();
            JsonResponseHandler<DeleteInterconnectResult> responseHandler = new JsonResponseHandler<DeleteInterconnectResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInterconnectResult deleteInterconnectResult = (DeleteInterconnectResult)response.getAwsResponse();
            return deleteInterconnectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public DescribeLocationsResult describeLocations() throws AmazonServiceException, AmazonClientException {
        return this.describeLocations(new DescribeLocationsRequest());
    }

    @Override
    public DescribeVirtualInterfacesResult describeVirtualInterfaces() throws AmazonServiceException, AmazonClientException {
        return this.describeVirtualInterfaces(new DescribeVirtualInterfacesRequest());
    }

    @Override
    public DescribeInterconnectsResult describeInterconnects() throws AmazonServiceException, AmazonClientException {
        return this.describeInterconnects(new DescribeInterconnectsRequest());
    }

    @Override
    public DescribeVirtualGatewaysResult describeVirtualGateways() throws AmazonServiceException, AmazonClientException {
        return this.describeVirtualGateways(new DescribeVirtualGatewaysRequest());
    }

    @Override
    public DescribeConnectionsResult describeConnections() throws AmazonServiceException, AmazonClientException {
        return this.describeConnections(new DescribeConnectionsRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

