/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.dynamodb.datamodeling;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.ArgumentMarshaller;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.ArgumentUnmarshaller;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.DynamoDBMapperConfig;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.DynamoDBMappingException;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.DynamoDBQueryExpression;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.DynamoDBRangeKey;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.DynamoDBReflector;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.DynamoDBScanExpression;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.DynamoDBTable;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.KeyPair;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.PaginatedQueryList;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.PaginatedScanList;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.QueryResultPage;
import com.cloudera.com.amazonaws.services.dynamodb.datamodeling.ScanResultPage;
import com.cloudera.com.amazonaws.services.dynamodb.model.AttributeValue;
import com.cloudera.com.amazonaws.services.dynamodb.model.AttributeValueUpdate;
import com.cloudera.com.amazonaws.services.dynamodb.model.BatchGetItemRequest;
import com.cloudera.com.amazonaws.services.dynamodb.model.BatchGetItemResult;
import com.cloudera.com.amazonaws.services.dynamodb.model.BatchResponse;
import com.cloudera.com.amazonaws.services.dynamodb.model.BatchWriteItemRequest;
import com.cloudera.com.amazonaws.services.dynamodb.model.BatchWriteItemResult;
import com.cloudera.com.amazonaws.services.dynamodb.model.DeleteItemRequest;
import com.cloudera.com.amazonaws.services.dynamodb.model.DeleteRequest;
import com.cloudera.com.amazonaws.services.dynamodb.model.ExpectedAttributeValue;
import com.cloudera.com.amazonaws.services.dynamodb.model.GetItemRequest;
import com.cloudera.com.amazonaws.services.dynamodb.model.GetItemResult;
import com.cloudera.com.amazonaws.services.dynamodb.model.Key;
import com.cloudera.com.amazonaws.services.dynamodb.model.KeysAndAttributes;
import com.cloudera.com.amazonaws.services.dynamodb.model.PutItemRequest;
import com.cloudera.com.amazonaws.services.dynamodb.model.PutRequest;
import com.cloudera.com.amazonaws.services.dynamodb.model.QueryRequest;
import com.cloudera.com.amazonaws.services.dynamodb.model.QueryResult;
import com.cloudera.com.amazonaws.services.dynamodb.model.ScanRequest;
import com.cloudera.com.amazonaws.services.dynamodb.model.ScanResult;
import com.cloudera.com.amazonaws.services.dynamodb.model.UpdateItemRequest;
import com.cloudera.com.amazonaws.services.dynamodb.model.WriteRequest;
import com.cloudera.com.amazonaws.util.VersionInfoUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DynamoDBMapper {
    private final AmazonDynamoDB db;
    private final DynamoDBMapperConfig config;
    private static final DynamoDBReflector reflector = new DynamoDBReflector();
    private static final String USER_AGENT = DynamoDBMapper.class.getName() + "/" + VersionInfoUtils.getVersion();

    public DynamoDBMapper(AmazonDynamoDB dynamoDB) {
        this(dynamoDB, DynamoDBMapperConfig.DEFAULT);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config) {
        this.db = dynamoDB;
        this.config = config;
    }

    public <T> T load(Class<T> clazz, Object hashKey, DynamoDBMapperConfig config) {
        return this.load(clazz, hashKey, null, config);
    }

    public <T> T load(Class<T> clazz, Object hashKey) {
        return this.load(clazz, hashKey, null, this.config);
    }

    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey) {
        return this.load(clazz, hashKey, rangeKey, this.config);
    }

    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey, DynamoDBMapperConfig config) {
        GetItemResult item;
        Map<String, AttributeValue> itemAttributes;
        config = this.mergeConfig(config);
        String tableName = this.getTableName(clazz, config);
        Method hashKeyGetter = reflector.getHashKeyGetter(clazz);
        AttributeValue hashKeyElement = this.getHashKeyElement(hashKey, hashKeyGetter);
        AttributeValue rangeKeyElement = null;
        if (rangeKey != null) {
            Method rangeKeyMethod = reflector.getRangeKeyGetter(clazz);
            if (rangeKeyMethod == null) {
                throw new DynamoDBMappingException("Zero-parameter range key property must be annotated with " + DynamoDBRangeKey.class);
            }
            rangeKeyElement = this.getRangeKeyElement(rangeKey, rangeKeyMethod);
        }
        if ((itemAttributes = (item = this.db.getItem(DynamoDBMapper.applyUserAgent(new GetItemRequest().withTableName(tableName).withKey(new Key().withHashKeyElement(hashKeyElement).withRangeKeyElement(rangeKeyElement)).withConsistentRead(config.getConsistentReads() == DynamoDBMapperConfig.ConsistentReads.CONSISTENT)))).getItem()) == null) {
            return null;
        }
        return this.marshallIntoObject(clazz, itemAttributes);
    }

    private <T> String getTableName(Class<T> clazz, DynamoDBMapperConfig config) {
        DynamoDBTable table = reflector.getTable(clazz);
        String tableName = table.tableName();
        if (config.getTableNameOverride() != null) {
            tableName = config.getTableNameOverride().getTableName() != null ? config.getTableNameOverride().getTableName() : config.getTableNameOverride().getTableNamePrefix() + tableName;
        }
        return tableName;
    }

    private AttributeValue getHashKeyElement(Object hashKey, Method hashKeyGetter) {
        return this.getSimpleAttributeValue(hashKeyGetter, hashKey);
    }

    private AttributeValue getRangeKeyElement(Object rangeKey, Method rangeKeyGetter) {
        return this.getSimpleAttributeValue(rangeKeyGetter, rangeKey);
    }

    public <T> T marshallIntoObject(Class<T> clazz, Map<String, AttributeValue> itemAttributes) {
        T toReturn = null;
        try {
            toReturn = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Failed to instantiate new instance of class", e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Failed to instantiate new instance of class", e);
        }
        if (itemAttributes == null || itemAttributes.isEmpty()) {
            return toReturn;
        }
        itemAttributes = this.untransformAttributes(clazz, itemAttributes);
        for (Method m : reflector.getRelevantGetters(clazz)) {
            String attributeName = reflector.getAttributeName(m);
            if (!itemAttributes.containsKey(attributeName)) continue;
            this.setValue(toReturn, m, itemAttributes.get(attributeName));
        }
        return toReturn;
    }

    public <T> List<T> marshallIntoObjects(Class<T> clazz, List<Map<String, AttributeValue>> itemAttributes) {
        ArrayList<T> result = new ArrayList<T>();
        for (Map<String, AttributeValue> item : itemAttributes) {
            result.add(this.marshallIntoObject(clazz, item));
        }
        return result;
    }

    private <T> void setValue(T toReturn, Method getter, AttributeValue value) {
        Object argument;
        Method setter = reflector.getSetter(getter);
        ArgumentUnmarshaller unmarhsaller = reflector.getArgumentUnmarshaller(toReturn, getter, setter);
        unmarhsaller.typeCheck(value, setter);
        try {
            argument = unmarhsaller.unmarshall(value);
        }
        catch (IllegalArgumentException e) {
            throw new DynamoDBMappingException("Couldn't unmarshall value " + value + " for " + setter, e);
        }
        catch (ParseException e) {
            throw new DynamoDBMappingException("Error attempting to parse date string " + value + " for " + setter, e);
        }
        this.safeInvoke(setter, toReturn, argument);
    }

    private AttributeValue getSimpleAttributeValue(Method getter, Object getterReturnResult) {
        if (getterReturnResult == null) {
            return null;
        }
        ArgumentMarshaller marshaller = reflector.getArgumentMarshaller(getter);
        return marshaller.marshall(getterReturnResult);
    }

    public <T> void save(T object) {
        this.save(object, this.config);
    }

    public <T> void save(T object, DynamoDBMapperConfig config) {
        AttributeValue currentValue;
        AttributeValue newVersionValue;
        String attributeName;
        Object getterResult;
        config = this.mergeConfig(config);
        Class<?> clazz = object.getClass();
        String tableName = this.getTableName(clazz, config);
        Method hashKeyGetter = reflector.getHashKeyGetter(clazz);
        AttributeValue hashKeyElement = this.getHashKeyElement(this.safeInvoke(hashKeyGetter, object, new Object[0]), hashKeyGetter);
        AttributeValue rangeKeyElement = null;
        Method rangeKeyGetter = reflector.getRangeKeyGetter(clazz);
        if (rangeKeyGetter != null) {
            rangeKeyElement = this.getRangeKeyElement(this.safeInvoke(rangeKeyGetter, object, new Object[0]), rangeKeyGetter);
        }
        Key objectKey = new Key().withHashKeyElement(hashKeyElement).withRangeKeyElement(rangeKeyElement);
        HashMap<String, AttributeValueUpdate> updateValues = new HashMap<String, AttributeValueUpdate>();
        HashMap<String, ExpectedAttributeValue> expectedValues = new HashMap<String, ExpectedAttributeValue>();
        boolean forcePut = config.getSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.CLOBBER;
        boolean nonKeyAttributePresent = false;
        LinkedList<ValueUpdate> inMemoryUpdates = new LinkedList<ValueUpdate>();
        LinkedList<Method> keyGetterMethods = new LinkedList<Method>();
        keyGetterMethods.add(hashKeyGetter);
        if (rangeKeyGetter != null) {
            keyGetterMethods.add(rangeKeyGetter);
        }
        if (!forcePut) {
            for (Method method : keyGetterMethods) {
                getterResult = this.safeInvoke(method, object, new Object[0]);
                if (getterResult != null || !reflector.isAssignableKey(method)) continue;
                forcePut = true;
            }
        }
        if (forcePut) {
            for (Method method : keyGetterMethods) {
                getterResult = this.safeInvoke(method, object, new Object[0]);
                attributeName = reflector.getAttributeName(method);
                if (getterResult == null && reflector.isAssignableKey(method)) {
                    newVersionValue = this.getAutoGeneratedKeyAttributeValue(method, getterResult);
                    updateValues.put(attributeName, new AttributeValueUpdate().withAction("PUT").withValue(newVersionValue));
                    inMemoryUpdates.add(new ValueUpdate(method, newVersionValue, object));
                    if (config.getSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.CLOBBER) continue;
                    ExpectedAttributeValue expected = new ExpectedAttributeValue();
                    expected.setExists(false);
                    expectedValues.put(attributeName, expected);
                    continue;
                }
                currentValue = this.getSimpleAttributeValue(method, getterResult);
                if (currentValue != null) {
                    updateValues.put(attributeName, new AttributeValueUpdate().withValue(currentValue).withAction("PUT"));
                    continue;
                }
                throw new DynamoDBMappingException("Null value for non-generated key for method " + method);
            }
        } else {
            if (hashKeyElement == null) {
                throw new DynamoDBMappingException("No value provided for hash key for object " + object);
            }
            if (rangeKeyGetter != null && rangeKeyElement == null) {
                throw new DynamoDBMappingException("No value provided for range key for object " + object);
            }
        }
        for (Method method : reflector.getRelevantGetters(clazz)) {
            if (method.equals(hashKeyGetter) || method.equals(rangeKeyGetter)) continue;
            nonKeyAttributePresent = true;
            getterResult = this.safeInvoke(method, object, new Object[0]);
            attributeName = reflector.getAttributeName(method);
            if (reflector.isVersionAttributeGetter(method)) {
                if (config.getSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER) {
                    ExpectedAttributeValue expected = new ExpectedAttributeValue();
                    AttributeValue currentValue2 = this.getSimpleAttributeValue(method, getterResult);
                    expected.setExists(currentValue2 != null);
                    if (currentValue2 != null) {
                        expected.setValue(currentValue2);
                    }
                    expectedValues.put(attributeName, expected);
                }
                newVersionValue = this.getVersionAttributeValue(method, getterResult);
                updateValues.put(attributeName, new AttributeValueUpdate().withAction("PUT").withValue(newVersionValue));
                inMemoryUpdates.add(new ValueUpdate(method, newVersionValue, object));
                continue;
            }
            currentValue = this.getSimpleAttributeValue(method, getterResult);
            if (currentValue != null) {
                updateValues.put(attributeName, new AttributeValueUpdate().withValue(currentValue).withAction("PUT"));
                continue;
            }
            if (config.getSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.CLOBBER) continue;
            updateValues.put(attributeName, new AttributeValueUpdate().withAction("DELETE"));
        }
        if (config.getSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.CLOBBER || forcePut) {
            this.db.putItem(DynamoDBMapper.applyUserAgent(new PutItemRequest().withTableName(tableName).withItem(this.transformAttributes(clazz, this.convertToItem(updateValues))).withExpected(expectedValues)));
        } else if (!nonKeyAttributePresent) {
            this.keyOnlyPut(clazz, tableName, objectKey, hashKeyGetter, rangeKeyGetter);
        } else {
            this.db.updateItem(DynamoDBMapper.applyUserAgent(new UpdateItemRequest().withTableName(tableName).withKey(objectKey).withAttributeUpdates(this.transformAttributeUpdates(clazz, objectKey, updateValues)).withExpected(expectedValues)));
        }
        for (ValueUpdate update : inMemoryUpdates) {
            update.apply();
        }
    }

    private void keyOnlyPut(Class<?> clazz, String tableName, Key objectKey, Method hashKeyGetter, Method rangeKeyGetter) {
        Map<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        HashMap<String, ExpectedAttributeValue> expectedValues = new HashMap<String, ExpectedAttributeValue>();
        String hashKeyAttributeName = reflector.getAttributeName(hashKeyGetter);
        attributes.put(hashKeyAttributeName, objectKey.getHashKeyElement());
        expectedValues.put(hashKeyAttributeName, new ExpectedAttributeValue().withExists(false));
        if (rangeKeyGetter != null) {
            String rangeKeyAttributeName = reflector.getAttributeName(rangeKeyGetter);
            attributes.put(rangeKeyAttributeName, objectKey.getRangeKeyElement());
            expectedValues.put(rangeKeyAttributeName, new ExpectedAttributeValue().withExists(false));
        }
        attributes = this.transformAttributes(clazz, attributes);
        this.db.putItem(DynamoDBMapper.applyUserAgent(new PutItemRequest().withTableName(tableName).withItem(attributes).withExpected(expectedValues)));
    }

    public void delete(Object object) {
        this.delete(object, this.config);
    }

    public void delete(Object object, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        Class<?> clazz = object.getClass();
        String tableName = this.getTableName(clazz, config);
        Method hashKeyGetter = reflector.getHashKeyGetter(clazz);
        AttributeValue hashKeyElement = this.getHashKeyElement(this.safeInvoke(hashKeyGetter, object, new Object[0]), hashKeyGetter);
        AttributeValue rangeKeyElement = null;
        Method rangeKeyGetter = reflector.getRangeKeyGetter(clazz);
        if (rangeKeyGetter != null) {
            rangeKeyElement = this.getRangeKeyElement(this.safeInvoke(rangeKeyGetter, object, new Object[0]), rangeKeyGetter);
        }
        Key objectKey = new Key().withHashKeyElement(hashKeyElement).withRangeKeyElement(rangeKeyElement);
        HashMap<String, ExpectedAttributeValue> expectedValues = new HashMap<String, ExpectedAttributeValue>();
        if (config.getSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER) {
            for (Method method : reflector.getRelevantGetters(clazz)) {
                if (!reflector.isVersionAttributeGetter(method)) continue;
                Object getterResult = this.safeInvoke(method, object, new Object[0]);
                String attributeName = reflector.getAttributeName(method);
                ExpectedAttributeValue expected = new ExpectedAttributeValue();
                AttributeValue currentValue = this.getSimpleAttributeValue(method, getterResult);
                expected.setExists(currentValue != null);
                if (currentValue != null) {
                    expected.setValue(currentValue);
                }
                expectedValues.put(attributeName, expected);
                break;
            }
        }
        this.db.deleteItem(DynamoDBMapper.applyUserAgent(new DeleteItemRequest().withKey(objectKey).withTableName(tableName).withExpected(expectedValues)));
    }

    public void batchDelete(List<? extends Object> objectsToDelete) {
        this.batchWrite(Collections.emptyList(), objectsToDelete, this.config);
    }

    public void batchDelete(Object ... objectsToDelete) {
        this.batchWrite(Collections.emptyList(), Arrays.asList(objectsToDelete), this.config);
    }

    public void batchSave(List<? extends Object> objectsToSave) {
        this.batchWrite(objectsToSave, Collections.emptyList(), this.config);
    }

    public void batchSave(Object ... objectsToSave) {
        this.batchWrite(Arrays.asList(objectsToSave), Collections.emptyList(), this.config);
    }

    public void batchWrite(List<? extends Object> objectsToWrite, List<? extends Object> objectsToDelete) {
        this.batchWrite(objectsToWrite, objectsToDelete, this.config);
    }

    /*
     * WARNING - void declaration
     */
    public void batchWrite(List<? extends Object> objectsToWrite, List<? extends Object> objectsToDelete, DynamoDBMapperConfig config) {
        String tableName;
        Class<?> clazz;
        config = this.mergeConfig(config);
        HashMap requestItems = new HashMap();
        LinkedList<ValueUpdate> inMemoryUpdates = new LinkedList<ValueUpdate>();
        for (Object object : objectsToWrite) {
            clazz = object.getClass();
            tableName = this.getTableName(clazz, config);
            HashMap<String, AttributeValue> attributeValues = new HashMap<String, AttributeValue>();
            for (Method method : reflector.getRelevantGetters(clazz)) {
                Object getterResult = this.safeInvoke(method, object, new Object[0]);
                String attributeName = reflector.getAttributeName(method);
                AttributeValue currentValue = null;
                if (getterResult == null && reflector.isAssignableKey(method)) {
                    currentValue = this.getAutoGeneratedKeyAttributeValue(method, getterResult);
                    inMemoryUpdates.add(new ValueUpdate(method, currentValue, object));
                } else {
                    currentValue = this.getSimpleAttributeValue(method, getterResult);
                }
                if (currentValue == null) continue;
                attributeValues.put(attributeName, currentValue);
            }
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new LinkedList());
            }
            ((List)requestItems.get(tableName)).add(new WriteRequest().withPutRequest(new PutRequest().withItem(this.transformAttributes(clazz, attributeValues))));
        }
        for (Object object : objectsToDelete) {
            clazz = object.getClass();
            tableName = this.getTableName(clazz, config);
            Method hashKeyGetter = reflector.getHashKeyGetter(clazz);
            AttributeValue hashKeyElement = this.getHashKeyElement(this.safeInvoke(hashKeyGetter, object, new Object[0]), hashKeyGetter);
            AttributeValue rangeKeyElement = null;
            Method rangeKeyGetter = reflector.getRangeKeyGetter(clazz);
            if (rangeKeyGetter != null) {
                rangeKeyElement = this.getRangeKeyElement(this.safeInvoke(rangeKeyGetter, object, new Object[0]), rangeKeyGetter);
            }
            Key objectKey = new Key().withHashKeyElement(hashKeyElement).withRangeKeyElement(rangeKeyElement);
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new LinkedList());
            }
            ((List)requestItems.get(tableName)).add(new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(objectKey)));
        }
        while (!requestItems.isEmpty()) {
            void var7_11;
            HashMap<String, List<WriteRequest>> batch = new HashMap<String, List<WriteRequest>>();
            boolean bl = false;
            Iterator tableIter = requestItems.entrySet().iterator();
            while (tableIter.hasNext() && var7_11 < 25) {
                Map.Entry tableRequest = tableIter.next();
                batch.put((String)tableRequest.getKey(), new LinkedList());
                Iterator writeRequestIter = ((List)tableRequest.getValue()).iterator();
                while (writeRequestIter.hasNext() && ++var7_11 < 25) {
                    WriteRequest writeRequest = (WriteRequest)writeRequestIter.next();
                    batch.get(tableRequest.getKey()).add(writeRequest);
                    writeRequestIter.remove();
                }
                if (writeRequestIter.hasNext()) continue;
                tableIter.remove();
            }
            BatchWriteItemResult result = this.db.batchWriteItem(new BatchWriteItemRequest().withRequestItems(batch));
            for (Map.Entry<String, List<WriteRequest>> unprocessedItem : result.getUnprocessedItems().entrySet()) {
                if (!requestItems.containsKey(unprocessedItem.getKey())) {
                    requestItems.put(unprocessedItem.getKey(), new LinkedList());
                }
                ((List)requestItems.get(unprocessedItem.getKey())).addAll((Collection)unprocessedItem.getValue());
            }
        }
        for (ValueUpdate valueUpdate : inMemoryUpdates) {
            valueUpdate.apply();
        }
    }

    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet) {
        return this.batchLoad(itemsToGet, this.config);
    }

    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet, DynamoDBMapperConfig config) {
        boolean consistentReads;
        boolean bl = consistentReads = (config = this.mergeConfig(config)).getConsistentReads() == DynamoDBMapperConfig.ConsistentReads.CONSISTENT;
        if (!this.validBatchGetRequest(itemsToGet)) {
            return null;
        }
        HashMap<String, KeysAndAttributes> requestItems = new HashMap<String, KeysAndAttributes>();
        HashMap classesByTableName = new HashMap();
        HashMap<String, List<Object>> resultSet = new HashMap<String, List<Object>>();
        int count = 0;
        for (Class<?> clazz : itemsToGet.keySet()) {
            String tableName = this.getTableName(clazz, config);
            List<KeyPair> keyPairs = itemsToGet.get(clazz);
            if (keyPairs == null) continue;
            classesByTableName.put(tableName, clazz);
            Method hashKeyGetter = reflector.getHashKeyGetter(clazz);
            for (KeyPair keyPair : keyPairs) {
                AttributeValue hashKeyElement = this.getHashKeyElement(keyPair.getHashKey(), hashKeyGetter);
                AttributeValue rangeKeyElement = null;
                if (keyPair.getRangeKey() != null) {
                    Method rangeKeyMethod = reflector.getRangeKeyGetter(clazz);
                    if (rangeKeyMethod == null) {
                        throw new DynamoDBMappingException("Zero-parameter range key property must be annotated with " + DynamoDBRangeKey.class);
                    }
                    rangeKeyElement = this.getRangeKeyElement(keyPair.getRangeKey(), rangeKeyMethod);
                }
                if (!requestItems.containsKey(tableName)) {
                    requestItems.put(tableName, new KeysAndAttributes().withConsistentRead(consistentReads).withKeys(new LinkedList<Key>()));
                }
                ((KeysAndAttributes)requestItems.get(tableName)).getKeys().add(new Key().withHashKeyElement(hashKeyElement).withRangeKeyElement(rangeKeyElement));
                if (++count != 100) continue;
                this.processBatchGetRequest(classesByTableName, requestItems, resultSet);
                requestItems.clear();
                count = 0;
            }
        }
        if (count > 0) {
            this.processBatchGetRequest(classesByTableName, requestItems, resultSet);
        }
        return resultSet;
    }

    private void processBatchGetRequest(Map<String, Class<?>> tableNameToClassMapper, Map<String, KeysAndAttributes> requestItems, Map<String, List<Object>> resultSet) {
        BatchGetItemResult batchGetItemResult = null;
        BatchGetItemRequest batchGetItemRequest = new BatchGetItemRequest();
        batchGetItemRequest.setRequestItems(requestItems);
        do {
            if (batchGetItemResult != null) {
                batchGetItemRequest.setRequestItems(batchGetItemResult.getUnprocessedKeys());
            }
            batchGetItemResult = this.db.batchGetItem(batchGetItemRequest);
            Map<String, BatchResponse> responses = batchGetItemResult.getResponses();
            for (String tableName : responses.keySet()) {
                BatchResponse batchResponse = responses.get(tableName);
                List<Object> objects = null;
                objects = resultSet.get(tableName) != null ? resultSet.get(tableName) : new LinkedList();
                List<Map<String, AttributeValue>> items = batchResponse.getItems();
                for (Map<String, AttributeValue> item : items) {
                    objects.add(this.marshallIntoObject(tableNameToClassMapper.get(tableName), item));
                }
                resultSet.put(tableName, objects);
            }
        } while (batchGetItemResult.getUnprocessedKeys() != null && batchGetItemResult.getUnprocessedKeys().size() > 0);
    }

    private boolean validBatchGetRequest(Map<Class<?>, List<KeyPair>> itemsToGet) {
        if (itemsToGet == null || itemsToGet.size() == 0) {
            return false;
        }
        for (Class<?> clazz : itemsToGet.keySet()) {
            if (itemsToGet.get(clazz) == null || itemsToGet.get(clazz).size() <= 0) continue;
            return true;
        }
        return false;
    }

    private Object safeInvoke(Method method, Object object, Object ... arguments) {
        try {
            return method.invoke(object, arguments);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
        catch (IllegalArgumentException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
        catch (InvocationTargetException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
    }

    private Map<String, AttributeValue> convertToItem(Map<String, AttributeValueUpdate> putValues) {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, AttributeValueUpdate> entry : putValues.entrySet()) {
            if (entry.getValue().getValue() == null) continue;
            map.put(entry.getKey(), entry.getValue().getValue());
        }
        return map;
    }

    private AttributeValue getVersionAttributeValue(Method getter, Object getterReturnResult) {
        ArgumentMarshaller marshaller = reflector.getVersionedArgumentMarshaller(getter, getterReturnResult);
        return marshaller.marshall(getterReturnResult);
    }

    private AttributeValue getAutoGeneratedKeyAttributeValue(Method getter, Object getterResult) {
        ArgumentMarshaller marshaller = reflector.getAutoGeneratedKeyArgumentMarshaller(getter);
        return marshaller.marshall(getterResult);
    }

    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDBScanExpression scanExpression) {
        return this.scan(clazz, scanExpression, this.config);
    }

    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        ScanResult scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
        return new PaginatedScanList<T>(this, clazz, this.db, scanRequest, scanResult);
    }

    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        ScanResult scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
        ScanResultPage<T> result = new ScanResultPage<T>();
        result.setResults(this.marshallIntoObjects(clazz, scanResult.getItems()));
        result.setLastEvaluatedKey(scanResult.getLastEvaluatedKey());
        return result;
    }

    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDBScanExpression scanExpression) {
        return this.scanPage(clazz, scanExpression, this.config);
    }

    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDBQueryExpression queryExpression) {
        return this.query(clazz, queryExpression, this.config);
    }

    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDBQueryExpression queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        QueryResult queryResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
        return new PaginatedQueryList<T>(this, clazz, this.db, queryRequest, queryResult);
    }

    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDBQueryExpression queryExpression) {
        return this.queryPage(clazz, queryExpression, this.config);
    }

    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDBQueryExpression queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        QueryResult scanResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
        QueryResultPage<T> result = new QueryResultPage<T>();
        result.setResults(this.marshallIntoObjects(clazz, scanResult.getItems()));
        result.setLastEvaluatedKey(scanResult.getLastEvaluatedKey());
        return result;
    }

    public int count(Class<?> clazz, DynamoDBScanExpression scanExpression) {
        return this.count(clazz, scanExpression, this.config);
    }

    public int count(Class<?> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        scanRequest.setCount(true);
        int count = 0;
        ScanResult scanResult = null;
        do {
            scanResult = this.db.scan(DynamoDBMapper.applyUserAgent(scanRequest));
            count += scanResult.getCount().intValue();
            scanRequest.setExclusiveStartKey(scanResult.getLastEvaluatedKey());
        } while (scanResult.getLastEvaluatedKey() != null);
        return count;
    }

    public int count(Class<?> clazz, DynamoDBQueryExpression queryExpression) {
        return this.count(clazz, queryExpression, this.config);
    }

    public int count(Class<?> clazz, DynamoDBQueryExpression queryExpression, DynamoDBMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        queryRequest.setCount(true);
        int count = 0;
        QueryResult queryResult = null;
        do {
            queryResult = this.db.query(DynamoDBMapper.applyUserAgent(queryRequest));
            count += queryResult.getCount().intValue();
            queryRequest.setExclusiveStartKey(queryResult.getLastEvaluatedKey());
        } while (queryResult.getLastEvaluatedKey() != null);
        return count;
    }

    private DynamoDBMapperConfig mergeConfig(DynamoDBMapperConfig config) {
        if (config != this.config) {
            config = new DynamoDBMapperConfig(this.config, config);
        }
        return config;
    }

    private ScanRequest createScanRequestFromExpression(Class<?> clazz, DynamoDBScanExpression scanExpression, DynamoDBMapperConfig config) {
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(this.getTableName(clazz, config));
        scanRequest.setScanFilter(scanExpression.getScanFilter());
        scanRequest.setLimit(scanExpression.getLimit());
        scanRequest.setExclusiveStartKey(scanExpression.getExclusiveStartKey());
        return scanRequest;
    }

    private QueryRequest createQueryRequestFromExpression(Class<?> clazz, DynamoDBQueryExpression queryExpression, DynamoDBMapperConfig config) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setConsistentRead(queryExpression.isConsistentRead());
        queryRequest.setTableName(this.getTableName(clazz, config));
        queryRequest.setHashKeyValue(queryExpression.getHashKeyValue());
        queryRequest.setScanIndexForward(queryExpression.isScanIndexForward());
        queryRequest.setRangeKeyCondition(queryExpression.getRangeKeyCondition());
        queryRequest.setLimit(queryExpression.getLimit());
        queryRequest.setExclusiveStartKey(queryExpression.getExclusiveStartKey());
        return queryRequest;
    }

    protected Map<String, AttributeValue> untransformAttributes(Class<?> clazz, Map<String, AttributeValue> attributeValues) {
        Method hashKeyGetter = reflector.getHashKeyGetter(clazz);
        String hashKeyName = reflector.getAttributeName(hashKeyGetter);
        Method rangeKeyGetter = reflector.getRangeKeyGetter(clazz);
        String rangeKeyName = rangeKeyGetter == null ? null : reflector.getAttributeName(rangeKeyGetter);
        return this.untransformAttributes(hashKeyName, rangeKeyName, attributeValues);
    }

    protected Map<String, AttributeValue> untransformAttributes(String hashKey, String rangeKey, Map<String, AttributeValue> attributeValues) {
        return attributeValues;
    }

    protected Map<String, AttributeValue> transformAttributes(Class<?> clazz, Map<String, AttributeValue> attributeValues) {
        Method hashKeyGetter = reflector.getHashKeyGetter(clazz);
        String hashKeyName = reflector.getAttributeName(hashKeyGetter);
        Method rangeKeyGetter = reflector.getRangeKeyGetter(clazz);
        String rangeKeyName = rangeKeyGetter == null ? null : reflector.getAttributeName(rangeKeyGetter);
        return this.transformAttributes(hashKeyName, rangeKeyName, attributeValues);
    }

    protected Map<String, AttributeValue> transformAttributes(String hashKey, String rangeKey, Map<String, AttributeValue> attributeValues) {
        return attributeValues;
    }

    private Map<String, AttributeValueUpdate> transformAttributeUpdates(Class<?> clazz, Key objectKey, Map<String, AttributeValueUpdate> updateValues) {
        Map<String, AttributeValue> item = this.convertToItem(updateValues);
        boolean hashKeyAdded = false;
        boolean rangeKeyAdded = false;
        String hashKey = reflector.getAttributeName(reflector.getHashKeyGetter(clazz));
        if (!item.containsKey(hashKey)) {
            item.put(hashKey, objectKey.getHashKeyElement());
            hashKeyAdded = true;
        }
        String rangeKey = null;
        Method rangeKeyGetter = reflector.getRangeKeyGetter(clazz);
        if (rangeKeyGetter != null && !item.containsKey(rangeKey = reflector.getAttributeName(rangeKeyGetter))) {
            item.put(rangeKey, objectKey.getRangeKeyElement());
            rangeKeyAdded = true;
        }
        item = this.transformAttributes(clazz, item);
        if (hashKeyAdded) {
            item.remove(hashKey);
        }
        if (rangeKeyAdded) {
            item.remove(rangeKey);
        }
        for (String key : item.keySet()) {
            if (updateValues.containsKey(key)) {
                updateValues.get(key).getValue().withB(item.get(key).getB()).withBS(item.get(key).getBS()).withN(item.get(key).getN()).withNS(item.get(key).getNS()).withS(item.get(key).getS()).withSS(item.get(key).getSS());
                continue;
            }
            updateValues.put(key, new AttributeValueUpdate(item.get(key), "PUT"));
        }
        return updateValues;
    }

    static <X extends AmazonWebServiceRequest> X applyUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return request;
    }

    private final class ValueUpdate {
        private Method method;
        private AttributeValue newValue;
        private Object target;

        public ValueUpdate(Method method, AttributeValue newValue, Object target) {
            this.method = method;
            this.newValue = newValue;
            this.target = target;
        }

        public void apply() {
            DynamoDBMapper.this.setValue(this.target, this.method, this.newValue);
        }
    }
}

