/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.dynamodbv2.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.cloudera.com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.cloudera.com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.cloudera.com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringInputStream;
import com.cloudera.com.amazonaws.util.StringUtils;
import com.cloudera.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateItemRequestMarshaller
implements Marshaller<Request<UpdateItemRequest>, UpdateItemRequest> {
    @Override
    public Request<UpdateItemRequest> marshall(UpdateItemRequest updateItemRequest) {
        if (updateItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateItemRequest> request = new DefaultRequest<UpdateItemRequest>(updateItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.UpdateItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag bSList;
            ListWithAutoConstructFlag nSList;
            ListWithAutoConstructFlag sSList;
            AttributeValue value;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(updateItemRequest.getTableName());
            }
            if (updateItemRequest.getKey() != null) {
                jsonWriter.key("Key");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> keyListValue : updateItemRequest.getKey().entrySet()) {
                    ListWithAutoConstructFlag bSList2;
                    ListWithAutoConstructFlag nSList2;
                    ListWithAutoConstructFlag sSList2;
                    if (keyListValue.getValue() == null) continue;
                    jsonWriter.key(keyListValue.getKey());
                    jsonWriter.object();
                    if (keyListValue.getValue().getS() != null) {
                        jsonWriter.key("S").value(keyListValue.getValue().getS());
                    }
                    if (keyListValue.getValue().getN() != null) {
                        jsonWriter.key("N").value(keyListValue.getValue().getN());
                    }
                    if (keyListValue.getValue().getB() != null) {
                        jsonWriter.key("B").value(keyListValue.getValue().getB());
                    }
                    if (!((sSList2 = (ListWithAutoConstructFlag)keyListValue.getValue().getSS()) == null || sSList2.isAutoConstruct() && sSList2.isEmpty())) {
                        jsonWriter.key("SS");
                        jsonWriter.array();
                        for (String sSListValue : sSList2) {
                            if (sSListValue == null) continue;
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((nSList2 = (ListWithAutoConstructFlag)keyListValue.getValue().getNS()) == null || nSList2.isAutoConstruct() && nSList2.isEmpty())) {
                        jsonWriter.key("NS");
                        jsonWriter.array();
                        for (String nSListValue : nSList2) {
                            if (nSListValue == null) continue;
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((bSList2 = (ListWithAutoConstructFlag)keyListValue.getValue().getBS()) == null || bSList2.isAutoConstruct() && bSList2.isEmpty())) {
                        jsonWriter.key("BS");
                        jsonWriter.array();
                        for (ByteBuffer bSListValue : bSList2) {
                            if (bSListValue == null) continue;
                            jsonWriter.value(bSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getAttributeUpdates() != null) {
                jsonWriter.key("AttributeUpdates");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValueUpdate> attributeUpdatesListValue : updateItemRequest.getAttributeUpdates().entrySet()) {
                    if (attributeUpdatesListValue.getValue() == null) continue;
                    jsonWriter.key(attributeUpdatesListValue.getKey());
                    jsonWriter.object();
                    value = attributeUpdatesListValue.getValue().getValue();
                    if (value != null) {
                        jsonWriter.key("Value");
                        jsonWriter.object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value(value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value(value.getN());
                        }
                        if (value.getB() != null) {
                            jsonWriter.key("B").value(value.getB());
                        }
                        if (!((sSList = (ListWithAutoConstructFlag)value.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                            jsonWriter.key("SS");
                            jsonWriter.array();
                            for (String sSListValue : sSList) {
                                if (sSListValue == null) continue;
                                jsonWriter.value(sSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((nSList = (ListWithAutoConstructFlag)value.getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                            jsonWriter.key("NS");
                            jsonWriter.array();
                            for (String nSListValue : nSList) {
                                if (nSListValue == null) continue;
                                jsonWriter.value(nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((bSList = (ListWithAutoConstructFlag)value.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                            jsonWriter.key("BS");
                            jsonWriter.array();
                            for (ByteBuffer bSListValue : bSList) {
                                if (bSListValue == null) continue;
                                jsonWriter.value(bSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (attributeUpdatesListValue.getValue().getAction() != null) {
                        jsonWriter.key("Action").value(attributeUpdatesListValue.getValue().getAction());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getExpected() != null) {
                jsonWriter.key("Expected");
                jsonWriter.object();
                for (Map.Entry<String, ExpectedAttributeValue> expectedListValue : updateItemRequest.getExpected().entrySet()) {
                    if (expectedListValue.getValue() == null) continue;
                    jsonWriter.key(expectedListValue.getKey());
                    jsonWriter.object();
                    value = expectedListValue.getValue().getValue();
                    if (value != null) {
                        jsonWriter.key("Value");
                        jsonWriter.object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value(value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value(value.getN());
                        }
                        if (value.getB() != null) {
                            jsonWriter.key("B").value(value.getB());
                        }
                        if (!((sSList = (ListWithAutoConstructFlag)value.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                            jsonWriter.key("SS");
                            jsonWriter.array();
                            for (String sSListValue : sSList) {
                                if (sSListValue == null) continue;
                                jsonWriter.value(sSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((nSList = (ListWithAutoConstructFlag)value.getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                            jsonWriter.key("NS");
                            jsonWriter.array();
                            for (String nSListValue : nSList) {
                                if (nSListValue == null) continue;
                                jsonWriter.value(nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((bSList = (ListWithAutoConstructFlag)value.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                            jsonWriter.key("BS");
                            jsonWriter.array();
                            for (ByteBuffer bSListValue : bSList) {
                                if (bSListValue == null) continue;
                                jsonWriter.value(bSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (expectedListValue.getValue().isExists() != null) {
                        jsonWriter.key("Exists").value(expectedListValue.getValue().isExists());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getReturnValues() != null) {
                jsonWriter.key("ReturnValues").value(updateItemRequest.getReturnValues());
            }
            if (updateItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(updateItemRequest.getReturnConsumedCapacity());
            }
            if (updateItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonWriter.key("ReturnItemCollectionMetrics").value(updateItemRequest.getReturnItemCollectionMetrics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

