/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.cloudera.com.amazonaws.services.ec2.model.ReportInstanceReasonCodes;
import com.cloudera.com.amazonaws.services.ec2.model.ReportStatusType;
import com.cloudera.com.amazonaws.services.ec2.model.transform.ReportInstanceStatusRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportInstanceStatusRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<ReportInstanceStatusRequest> {
    private ListWithAutoConstructFlag<String> instances;
    private String status;
    private Date startTime;
    private Date endTime;
    private ListWithAutoConstructFlag<String> reasonCodes;
    private String description;

    public List<String> getInstances() {
        if (this.instances == null) {
            this.instances = new ListWithAutoConstructFlag();
            this.instances.setAutoConstruct(true);
        }
        return this.instances;
    }

    public void setInstances(Collection<String> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public ReportInstanceStatusRequest withInstances(String ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<String>(instances.length));
        }
        for (String value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public ReportInstanceStatusRequest withInstances(Collection<String> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ReportInstanceStatusRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(ReportStatusType status) {
        this.status = status.toString();
    }

    public ReportInstanceStatusRequest withStatus(ReportStatusType status) {
        this.status = status.toString();
        return this;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public ReportInstanceStatusRequest withStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public ReportInstanceStatusRequest withEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<String> getReasonCodes() {
        if (this.reasonCodes == null) {
            this.reasonCodes = new ListWithAutoConstructFlag();
            this.reasonCodes.setAutoConstruct(true);
        }
        return this.reasonCodes;
    }

    public void setReasonCodes(Collection<String> reasonCodes) {
        if (reasonCodes == null) {
            this.reasonCodes = null;
            return;
        }
        ListWithAutoConstructFlag reasonCodesCopy = new ListWithAutoConstructFlag(reasonCodes.size());
        reasonCodesCopy.addAll(reasonCodes);
        this.reasonCodes = reasonCodesCopy;
    }

    public ReportInstanceStatusRequest withReasonCodes(String ... reasonCodes) {
        if (this.getReasonCodes() == null) {
            this.setReasonCodes(new ArrayList<String>(reasonCodes.length));
        }
        for (String value : reasonCodes) {
            this.getReasonCodes().add(value);
        }
        return this;
    }

    public ReportInstanceStatusRequest withReasonCodes(Collection<String> reasonCodes) {
        if (reasonCodes == null) {
            this.reasonCodes = null;
        } else {
            ListWithAutoConstructFlag reasonCodesCopy = new ListWithAutoConstructFlag(reasonCodes.size());
            reasonCodesCopy.addAll(reasonCodes);
            this.reasonCodes = reasonCodesCopy;
        }
        return this;
    }

    public ReportInstanceStatusRequest withReasonCodes(ReportInstanceReasonCodes ... reasonCodes) {
        ArrayList<String> reasonCodesCopy = new ArrayList<String>(reasonCodes.length);
        for (ReportInstanceReasonCodes member : reasonCodes) {
            reasonCodesCopy.add(member.toString());
        }
        if (this.getReasonCodes() == null) {
            this.setReasonCodes(reasonCodesCopy);
        } else {
            this.getReasonCodes().addAll(reasonCodesCopy);
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ReportInstanceStatusRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public Request<ReportInstanceStatusRequest> getDryRunRequest() {
        Request<ReportInstanceStatusRequest> request = new ReportInstanceStatusRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: " + this.getStartTime() + ",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: " + this.getEndTime() + ",");
        }
        if (this.getReasonCodes() != null) {
            sb.append("ReasonCodes: " + this.getReasonCodes() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getReasonCodes() == null ? 0 : this.getReasonCodes().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportInstanceStatusRequest)) {
            return false;
        }
        ReportInstanceStatusRequest other = (ReportInstanceStatusRequest)obj;
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getReasonCodes() == null ^ this.getReasonCodes() == null) {
            return false;
        }
        if (other.getReasonCodes() != null && !other.getReasonCodes().equals(this.getReasonCodes())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }
}

