/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest;
import com.cloudera.com.amazonaws.services.ec2.model.PriceScheduleSpecification;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateReservedInstancesListingRequestMarshaller
implements Marshaller<Request<CreateReservedInstancesListingRequest>, CreateReservedInstancesListingRequest> {
    @Override
    public Request<CreateReservedInstancesListingRequest> marshall(CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {
        if (createReservedInstancesListingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateReservedInstancesListingRequest> request = new DefaultRequest<CreateReservedInstancesListingRequest>(createReservedInstancesListingRequest, "AmazonEC2");
        request.addParameter("Action", "CreateReservedInstancesListing");
        request.addParameter("Version", "2013-10-15");
        if (createReservedInstancesListingRequest.getReservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId", StringUtils.fromString(createReservedInstancesListingRequest.getReservedInstancesId()));
        }
        if (createReservedInstancesListingRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger(createReservedInstancesListingRequest.getInstanceCount()));
        }
        List<PriceScheduleSpecification> priceSchedulesList = createReservedInstancesListingRequest.getPriceSchedules();
        int priceSchedulesListIndex = 1;
        for (PriceScheduleSpecification priceSchedulesListValue : priceSchedulesList) {
            PriceScheduleSpecification priceScheduleSpecificationMember = priceSchedulesListValue;
            if (priceScheduleSpecificationMember != null) {
                if (priceScheduleSpecificationMember.getTerm() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Term", StringUtils.fromLong(priceScheduleSpecificationMember.getTerm()));
                }
                if (priceScheduleSpecificationMember.getPrice() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Price", StringUtils.fromDouble(priceScheduleSpecificationMember.getPrice()));
                }
                if (priceScheduleSpecificationMember.getCurrencyCode() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".CurrencyCode", StringUtils.fromString(priceScheduleSpecificationMember.getCurrencyCode()));
                }
            }
            ++priceSchedulesListIndex;
        }
        if (createReservedInstancesListingRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createReservedInstancesListingRequest.getClientToken()));
        }
        return request;
    }
}

