/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticache.model.transform;

import com.cloudera.com.amazonaws.services.elasticache.model.Endpoint;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointStaxUnmarshaller
implements Unmarshaller<Endpoint, StaxUnmarshallerContext> {
    private static EndpointStaxUnmarshaller instance;

    @Override
    public Endpoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        Endpoint endpoint = new Endpoint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return endpoint;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Address", targetDepth)) {
                    endpoint.setAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Port", targetDepth)) continue;
                endpoint.setPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return endpoint;
    }

    public static EndpointStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointStaxUnmarshaller();
        }
        return instance;
    }
}

