/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticbeanstalk.model;

import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.elasticbeanstalk.model.Listener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerDescription
implements Serializable {
    private String loadBalancerName;
    private String domain;
    private ListWithAutoConstructFlag<Listener> listeners;

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public LoadBalancerDescription withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public LoadBalancerDescription withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ListWithAutoConstructFlag();
            this.listeners.setAutoConstruct(true);
        }
        return this.listeners;
    }

    public void setListeners(Collection<Listener> listeners) {
        if (listeners == null) {
            this.listeners = null;
            return;
        }
        ListWithAutoConstructFlag listenersCopy = new ListWithAutoConstructFlag(listeners.size());
        listenersCopy.addAll(listeners);
        this.listeners = listenersCopy;
    }

    public LoadBalancerDescription withListeners(Listener ... listeners) {
        if (this.getListeners() == null) {
            this.setListeners(new ArrayList<Listener>(listeners.length));
        }
        for (Listener value : listeners) {
            this.getListeners().add(value);
        }
        return this;
    }

    public LoadBalancerDescription withListeners(Collection<Listener> listeners) {
        if (listeners == null) {
            this.listeners = null;
        } else {
            ListWithAutoConstructFlag listenersCopy = new ListWithAutoConstructFlag(listeners.size());
            listenersCopy.addAll(listeners);
            this.listeners = listenersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerName() != null) {
            sb.append("LoadBalancerName: " + this.getLoadBalancerName() + ",");
        }
        if (this.getDomain() != null) {
            sb.append("Domain: " + this.getDomain() + ",");
        }
        if (this.getListeners() != null) {
            sb.append("Listeners: " + this.getListeners());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerName() == null ? 0 : this.getLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        hashCode = 31 * hashCode + (this.getListeners() == null ? 0 : this.getListeners().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerDescription)) {
            return false;
        }
        LoadBalancerDescription other = (LoadBalancerDescription)obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) {
            return false;
        }
        if (other.getLoadBalancerName() != null && !other.getLoadBalancerName().equals(this.getLoadBalancerName())) {
            return false;
        }
        if (other.getDomain() == null ^ this.getDomain() == null) {
            return false;
        }
        if (other.getDomain() != null && !other.getDomain().equals(this.getDomain())) {
            return false;
        }
        if (other.getListeners() == null ^ this.getListeners() == null) {
            return false;
        }
        return other.getListeners() == null || other.getListeners().equals(this.getListeners());
    }
}

