/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticbeanstalk.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeApplicationsRequestMarshaller
implements Marshaller<Request<DescribeApplicationsRequest>, DescribeApplicationsRequest> {
    @Override
    public Request<DescribeApplicationsRequest> marshall(DescribeApplicationsRequest describeApplicationsRequest) {
        if (describeApplicationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeApplicationsRequest> request = new DefaultRequest<DescribeApplicationsRequest>(describeApplicationsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DescribeApplications");
        request.addParameter("Version", "2010-12-01");
        List<String> applicationNamesList = describeApplicationsRequest.getApplicationNames();
        int applicationNamesListIndex = 1;
        for (String applicationNamesListValue : applicationNamesList) {
            if (applicationNamesListValue != null) {
                request.addParameter("ApplicationNames.member." + applicationNamesListIndex, StringUtils.fromString(applicationNamesListValue));
            }
            ++applicationNamesListIndex;
        }
        return request;
    }
}

