/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticbeanstalk.model.transform;

import com.cloudera.com.amazonaws.services.elasticbeanstalk.model.EventDescription;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDescriptionStaxUnmarshaller
implements Unmarshaller<EventDescription, StaxUnmarshallerContext> {
    private static EventDescriptionStaxUnmarshaller instance;

    @Override
    public EventDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventDescription eventDescription = new EventDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return eventDescription;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("EventDate", targetDepth)) {
                    eventDescription.setEventDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Message", targetDepth)) {
                    eventDescription.setMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ApplicationName", targetDepth)) {
                    eventDescription.setApplicationName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VersionLabel", targetDepth)) {
                    eventDescription.setVersionLabel(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TemplateName", targetDepth)) {
                    eventDescription.setTemplateName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EnvironmentName", targetDepth)) {
                    eventDescription.setEnvironmentName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequestId", targetDepth)) {
                    eventDescription.setRequestId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Severity", targetDepth)) continue;
                eventDescription.setSeverity(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return eventDescription;
    }

    public static EventDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EventDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

