/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticmapreduce;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.AmazonWebServiceClient;
import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.AmazonWebServiceResponse;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.Response;
import com.cloudera.com.amazonaws.ResponseMetadata;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.cloudera.com.amazonaws.handlers.HandlerChainFactory;
import com.cloudera.com.amazonaws.http.ExecutionContext;
import com.cloudera.com.amazonaws.http.HttpResponseHandler;
import com.cloudera.com.amazonaws.http.JsonErrorResponseHandler;
import com.cloudera.com.amazonaws.http.JsonResponseHandler;
import com.cloudera.com.amazonaws.internal.StaticCredentialsProvider;
import com.cloudera.com.amazonaws.metrics.RequestMetricCollector;
import com.cloudera.com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.AddTagsRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.AddTagsResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.DescribeClusterResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.DescribeStepResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ListClustersRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ListClustersResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ListInstancesResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ListStepsRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ListStepsResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.RemoveTagsResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.AddInstanceGroupsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.AddInstanceGroupsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.AddJobFlowStepsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.AddJobFlowStepsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.AddTagsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.AddTagsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.DescribeClusterRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.DescribeClusterResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.DescribeJobFlowsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.DescribeJobFlowsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.DescribeStepRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.DescribeStepResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.InternalServerExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.InvalidRequestExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ListBootstrapActionsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ListBootstrapActionsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ListClustersRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ListClustersResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ListInstanceGroupsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ListInstanceGroupsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ListInstancesRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ListInstancesResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ListStepsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ListStepsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.ModifyInstanceGroupsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.RemoveTagsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.RemoveTagsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.RunJobFlowRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.RunJobFlowResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.SetTerminationProtectionRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.SetVisibleToAllUsersRequestMarshaller;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.transform.TerminateJobFlowsRequestMarshaller;
import com.cloudera.com.amazonaws.transform.JsonErrorUnmarshaller;
import com.cloudera.com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticMapReduceClient
extends AmazonWebServiceClient
implements AmazonElasticMapReduce {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonElasticMapReduce.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonElasticMapReduceClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonElasticMapReduceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonElasticMapReduceClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonElasticMapReduceClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new InternalServerExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidRequestExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("elasticmapreduce.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/cloudera/com/amazonaws/services/elasticmapreduce/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/cloudera/com/amazonaws/services/elasticmapreduce/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBootstrapActionsResult listBootstrapActions(ListBootstrapActionsRequest listBootstrapActionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBootstrapActionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBootstrapActionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBootstrapActionsRequestMarshaller().marshall(listBootstrapActionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListBootstrapActionsResultJsonUnmarshaller unmarshaller = new ListBootstrapActionsResultJsonUnmarshaller();
            JsonResponseHandler<ListBootstrapActionsResult> responseHandler = new JsonResponseHandler<ListBootstrapActionsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListBootstrapActionsResult listBootstrapActionsResult = (ListBootstrapActionsResult)response.getAwsResponse();
            return listBootstrapActionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResult addTags(AddTagsRequest addTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsRequestMarshaller().marshall(addTagsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            AddTagsResultJsonUnmarshaller unmarshaller = new AddTagsResultJsonUnmarshaller();
            JsonResponseHandler<AddTagsResult> responseHandler = new JsonResponseHandler<AddTagsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            AddTagsResult addTagsResult = (AddTagsResult)response.getAwsResponse();
            return addTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisibleToAllUsers(SetVisibleToAllUsersRequest setVisibleToAllUsersRequest) {
        Request<SetVisibleToAllUsersRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(setVisibleToAllUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new SetVisibleToAllUsersRequestMarshaller().marshall(setVisibleToAllUsersRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStepsResult listSteps(ListStepsRequest listStepsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStepsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStepsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStepsRequestMarshaller().marshall(listStepsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListStepsResultJsonUnmarshaller unmarshaller = new ListStepsResultJsonUnmarshaller();
            JsonResponseHandler<ListStepsResult> responseHandler = new JsonResponseHandler<ListStepsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListStepsResult listStepsResult = (ListStepsResult)response.getAwsResponse();
            return listStepsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddJobFlowStepsResult addJobFlowSteps(AddJobFlowStepsRequest addJobFlowStepsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addJobFlowStepsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddJobFlowStepsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddJobFlowStepsRequestMarshaller().marshall(addJobFlowStepsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            AddJobFlowStepsResultJsonUnmarshaller unmarshaller = new AddJobFlowStepsResultJsonUnmarshaller();
            JsonResponseHandler<AddJobFlowStepsResult> responseHandler = new JsonResponseHandler<AddJobFlowStepsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            AddJobFlowStepsResult addJobFlowStepsResult = (AddJobFlowStepsResult)response.getAwsResponse();
            return addJobFlowStepsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStepResult describeStep(DescribeStepRequest describeStepRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStepRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeStepRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeStepRequestMarshaller().marshall(describeStepRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeStepResultJsonUnmarshaller unmarshaller = new DescribeStepResultJsonUnmarshaller();
            JsonResponseHandler<DescribeStepResult> responseHandler = new JsonResponseHandler<DescribeStepResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeStepResult describeStepResult = (DescribeStepResult)response.getAwsResponse();
            return describeStepResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResult listClusters(ListClustersRequest listClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClustersRequestMarshaller().marshall(listClustersRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListClustersResultJsonUnmarshaller unmarshaller = new ListClustersResultJsonUnmarshaller();
            JsonResponseHandler<ListClustersResult> responseHandler = new JsonResponseHandler<ListClustersResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListClustersResult listClustersResult = (ListClustersResult)response.getAwsResponse();
            return listClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResult removeTags(RemoveTagsRequest removeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsRequestMarshaller().marshall(removeTagsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RemoveTagsResultJsonUnmarshaller unmarshaller = new RemoveTagsResultJsonUnmarshaller();
            JsonResponseHandler<RemoveTagsResult> responseHandler = new JsonResponseHandler<RemoveTagsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            RemoveTagsResult removeTagsResult = (RemoveTagsResult)response.getAwsResponse();
            return removeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInstanceGroupsResult listInstanceGroups(ListInstanceGroupsRequest listInstanceGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInstanceGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInstanceGroupsRequestMarshaller().marshall(listInstanceGroupsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListInstanceGroupsResultJsonUnmarshaller unmarshaller = new ListInstanceGroupsResultJsonUnmarshaller();
            JsonResponseHandler<ListInstanceGroupsResult> responseHandler = new JsonResponseHandler<ListInstanceGroupsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListInstanceGroupsResult listInstanceGroupsResult = (ListInstanceGroupsResult)response.getAwsResponse();
            return listInstanceGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyInstanceGroups(ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) {
        Request<ModifyInstanceGroupsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(modifyInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ModifyInstanceGroupsRequestMarshaller().marshall(modifyInstanceGroupsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInstancesResult listInstances(ListInstancesRequest listInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInstancesRequestMarshaller().marshall(listInstancesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListInstancesResultJsonUnmarshaller unmarshaller = new ListInstancesResultJsonUnmarshaller();
            JsonResponseHandler<ListInstancesResult> responseHandler = new JsonResponseHandler<ListInstancesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListInstancesResult listInstancesResult = (ListInstancesResult)response.getAwsResponse();
            return listInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddInstanceGroupsResult addInstanceGroups(AddInstanceGroupsRequest addInstanceGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddInstanceGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddInstanceGroupsRequestMarshaller().marshall(addInstanceGroupsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            AddInstanceGroupsResultJsonUnmarshaller unmarshaller = new AddInstanceGroupsResultJsonUnmarshaller();
            JsonResponseHandler<AddInstanceGroupsResult> responseHandler = new JsonResponseHandler<AddInstanceGroupsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            AddInstanceGroupsResult addInstanceGroupsResult = (AddInstanceGroupsResult)response.getAwsResponse();
            return addInstanceGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateJobFlows(TerminateJobFlowsRequest terminateJobFlowsRequest) {
        Request<TerminateJobFlowsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(terminateJobFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new TerminateJobFlowsRequestMarshaller().marshall(terminateJobFlowsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTerminationProtection(SetTerminationProtectionRequest setTerminationProtectionRequest) {
        Request<SetTerminationProtectionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(setTerminationProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new SetTerminationProtectionRequestMarshaller().marshall(setTerminationProtectionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public DescribeJobFlowsResult describeJobFlows(DescribeJobFlowsRequest describeJobFlowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobFlowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobFlowsRequestMarshaller().marshall(describeJobFlowsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeJobFlowsResultJsonUnmarshaller unmarshaller = new DescribeJobFlowsResultJsonUnmarshaller();
            JsonResponseHandler<DescribeJobFlowsResult> responseHandler = new JsonResponseHandler<DescribeJobFlowsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJobFlowsResult describeJobFlowsResult = (DescribeJobFlowsResult)response.getAwsResponse();
            return describeJobFlowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunJobFlowResult runJobFlow(RunJobFlowRequest runJobFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(runJobFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RunJobFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RunJobFlowRequestMarshaller().marshall(runJobFlowRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RunJobFlowResultJsonUnmarshaller unmarshaller = new RunJobFlowResultJsonUnmarshaller();
            JsonResponseHandler<RunJobFlowResult> responseHandler = new JsonResponseHandler<RunJobFlowResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            RunJobFlowResult runJobFlowResult = (RunJobFlowResult)response.getAwsResponse();
            return runJobFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClusterResult describeCluster(DescribeClusterRequest describeClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeClusterRequestMarshaller().marshall(describeClusterRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeClusterResultJsonUnmarshaller unmarshaller = new DescribeClusterResultJsonUnmarshaller();
            JsonResponseHandler<DescribeClusterResult> responseHandler = new JsonResponseHandler<DescribeClusterResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeClusterResult describeClusterResult = (DescribeClusterResult)response.getAwsResponse();
            return describeClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public ListBootstrapActionsResult listBootstrapActions() throws AmazonServiceException, AmazonClientException {
        return this.listBootstrapActions(new ListBootstrapActionsRequest());
    }

    @Override
    public AddTagsResult addTags() throws AmazonServiceException, AmazonClientException {
        return this.addTags(new AddTagsRequest());
    }

    @Override
    public ListStepsResult listSteps() throws AmazonServiceException, AmazonClientException {
        return this.listSteps(new ListStepsRequest());
    }

    @Override
    public DescribeStepResult describeStep() throws AmazonServiceException, AmazonClientException {
        return this.describeStep(new DescribeStepRequest());
    }

    @Override
    public ListClustersResult listClusters() throws AmazonServiceException, AmazonClientException {
        return this.listClusters(new ListClustersRequest());
    }

    @Override
    public RemoveTagsResult removeTags() throws AmazonServiceException, AmazonClientException {
        return this.removeTags(new RemoveTagsRequest());
    }

    @Override
    public ListInstanceGroupsResult listInstanceGroups() throws AmazonServiceException, AmazonClientException {
        return this.listInstanceGroups(new ListInstanceGroupsRequest());
    }

    @Override
    public void modifyInstanceGroups() throws AmazonServiceException, AmazonClientException {
        this.modifyInstanceGroups(new ModifyInstanceGroupsRequest());
    }

    @Override
    public ListInstancesResult listInstances() throws AmazonServiceException, AmazonClientException {
        return this.listInstances(new ListInstancesRequest());
    }

    @Override
    @Deprecated
    public DescribeJobFlowsResult describeJobFlows() throws AmazonServiceException, AmazonClientException {
        return this.describeJobFlows(new DescribeJobFlowsRequest());
    }

    @Override
    public DescribeClusterResult describeCluster() throws AmazonServiceException, AmazonClientException {
        return this.describeCluster(new DescribeClusterRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

