/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticmapreduce.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunJobFlowRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String name;
    private String logUri;
    private String additionalInfo;
    private String amiVersion;
    private JobFlowInstancesConfig instances;
    private ListWithAutoConstructFlag<StepConfig> steps;
    private ListWithAutoConstructFlag<BootstrapActionConfig> bootstrapActions;
    private ListWithAutoConstructFlag<String> supportedProducts;
    private ListWithAutoConstructFlag<SupportedProductConfig> newSupportedProducts;
    private Boolean visibleToAllUsers;
    private String jobFlowRole;
    private ListWithAutoConstructFlag<Tag> tags;

    public RunJobFlowRequest() {
    }

    public RunJobFlowRequest(String name, JobFlowInstancesConfig instances) {
        this.setName(name);
        this.setInstances(instances);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RunJobFlowRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getLogUri() {
        return this.logUri;
    }

    public void setLogUri(String logUri) {
        this.logUri = logUri;
    }

    public RunJobFlowRequest withLogUri(String logUri) {
        this.logUri = logUri;
        return this;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public RunJobFlowRequest withAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public String getAmiVersion() {
        return this.amiVersion;
    }

    public void setAmiVersion(String amiVersion) {
        this.amiVersion = amiVersion;
    }

    public RunJobFlowRequest withAmiVersion(String amiVersion) {
        this.amiVersion = amiVersion;
        return this;
    }

    public JobFlowInstancesConfig getInstances() {
        return this.instances;
    }

    public void setInstances(JobFlowInstancesConfig instances) {
        this.instances = instances;
    }

    public RunJobFlowRequest withInstances(JobFlowInstancesConfig instances) {
        this.instances = instances;
        return this;
    }

    public List<StepConfig> getSteps() {
        if (this.steps == null) {
            this.steps = new ListWithAutoConstructFlag();
            this.steps.setAutoConstruct(true);
        }
        return this.steps;
    }

    public void setSteps(Collection<StepConfig> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        ListWithAutoConstructFlag stepsCopy = new ListWithAutoConstructFlag(steps.size());
        stepsCopy.addAll(steps);
        this.steps = stepsCopy;
    }

    public RunJobFlowRequest withSteps(StepConfig ... steps) {
        if (this.getSteps() == null) {
            this.setSteps(new ArrayList<StepConfig>(steps.length));
        }
        for (StepConfig value : steps) {
            this.getSteps().add(value);
        }
        return this;
    }

    public RunJobFlowRequest withSteps(Collection<StepConfig> steps) {
        if (steps == null) {
            this.steps = null;
        } else {
            ListWithAutoConstructFlag stepsCopy = new ListWithAutoConstructFlag(steps.size());
            stepsCopy.addAll(steps);
            this.steps = stepsCopy;
        }
        return this;
    }

    public List<BootstrapActionConfig> getBootstrapActions() {
        if (this.bootstrapActions == null) {
            this.bootstrapActions = new ListWithAutoConstructFlag();
            this.bootstrapActions.setAutoConstruct(true);
        }
        return this.bootstrapActions;
    }

    public void setBootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
        if (bootstrapActions == null) {
            this.bootstrapActions = null;
            return;
        }
        ListWithAutoConstructFlag bootstrapActionsCopy = new ListWithAutoConstructFlag(bootstrapActions.size());
        bootstrapActionsCopy.addAll(bootstrapActions);
        this.bootstrapActions = bootstrapActionsCopy;
    }

    public RunJobFlowRequest withBootstrapActions(BootstrapActionConfig ... bootstrapActions) {
        if (this.getBootstrapActions() == null) {
            this.setBootstrapActions(new ArrayList<BootstrapActionConfig>(bootstrapActions.length));
        }
        for (BootstrapActionConfig value : bootstrapActions) {
            this.getBootstrapActions().add(value);
        }
        return this;
    }

    public RunJobFlowRequest withBootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
        if (bootstrapActions == null) {
            this.bootstrapActions = null;
        } else {
            ListWithAutoConstructFlag bootstrapActionsCopy = new ListWithAutoConstructFlag(bootstrapActions.size());
            bootstrapActionsCopy.addAll(bootstrapActions);
            this.bootstrapActions = bootstrapActionsCopy;
        }
        return this;
    }

    public List<String> getSupportedProducts() {
        if (this.supportedProducts == null) {
            this.supportedProducts = new ListWithAutoConstructFlag();
            this.supportedProducts.setAutoConstruct(true);
        }
        return this.supportedProducts;
    }

    public void setSupportedProducts(Collection<String> supportedProducts) {
        if (supportedProducts == null) {
            this.supportedProducts = null;
            return;
        }
        ListWithAutoConstructFlag supportedProductsCopy = new ListWithAutoConstructFlag(supportedProducts.size());
        supportedProductsCopy.addAll(supportedProducts);
        this.supportedProducts = supportedProductsCopy;
    }

    public RunJobFlowRequest withSupportedProducts(String ... supportedProducts) {
        if (this.getSupportedProducts() == null) {
            this.setSupportedProducts(new ArrayList<String>(supportedProducts.length));
        }
        for (String value : supportedProducts) {
            this.getSupportedProducts().add(value);
        }
        return this;
    }

    public RunJobFlowRequest withSupportedProducts(Collection<String> supportedProducts) {
        if (supportedProducts == null) {
            this.supportedProducts = null;
        } else {
            ListWithAutoConstructFlag supportedProductsCopy = new ListWithAutoConstructFlag(supportedProducts.size());
            supportedProductsCopy.addAll(supportedProducts);
            this.supportedProducts = supportedProductsCopy;
        }
        return this;
    }

    public List<SupportedProductConfig> getNewSupportedProducts() {
        if (this.newSupportedProducts == null) {
            this.newSupportedProducts = new ListWithAutoConstructFlag();
            this.newSupportedProducts.setAutoConstruct(true);
        }
        return this.newSupportedProducts;
    }

    public void setNewSupportedProducts(Collection<SupportedProductConfig> newSupportedProducts) {
        if (newSupportedProducts == null) {
            this.newSupportedProducts = null;
            return;
        }
        ListWithAutoConstructFlag newSupportedProductsCopy = new ListWithAutoConstructFlag(newSupportedProducts.size());
        newSupportedProductsCopy.addAll(newSupportedProducts);
        this.newSupportedProducts = newSupportedProductsCopy;
    }

    public RunJobFlowRequest withNewSupportedProducts(SupportedProductConfig ... newSupportedProducts) {
        if (this.getNewSupportedProducts() == null) {
            this.setNewSupportedProducts(new ArrayList<SupportedProductConfig>(newSupportedProducts.length));
        }
        for (SupportedProductConfig value : newSupportedProducts) {
            this.getNewSupportedProducts().add(value);
        }
        return this;
    }

    public RunJobFlowRequest withNewSupportedProducts(Collection<SupportedProductConfig> newSupportedProducts) {
        if (newSupportedProducts == null) {
            this.newSupportedProducts = null;
        } else {
            ListWithAutoConstructFlag newSupportedProductsCopy = new ListWithAutoConstructFlag(newSupportedProducts.size());
            newSupportedProductsCopy.addAll(newSupportedProducts);
            this.newSupportedProducts = newSupportedProductsCopy;
        }
        return this;
    }

    public Boolean isVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public void setVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.visibleToAllUsers = visibleToAllUsers;
    }

    public RunJobFlowRequest withVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.visibleToAllUsers = visibleToAllUsers;
        return this;
    }

    public Boolean getVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public String getJobFlowRole() {
        return this.jobFlowRole;
    }

    public void setJobFlowRole(String jobFlowRole) {
        this.jobFlowRole = jobFlowRole;
    }

    public RunJobFlowRequest withJobFlowRole(String jobFlowRole) {
        this.jobFlowRole = jobFlowRole;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public RunJobFlowRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public RunJobFlowRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getLogUri() != null) {
            sb.append("LogUri: " + this.getLogUri() + ",");
        }
        if (this.getAdditionalInfo() != null) {
            sb.append("AdditionalInfo: " + this.getAdditionalInfo() + ",");
        }
        if (this.getAmiVersion() != null) {
            sb.append("AmiVersion: " + this.getAmiVersion() + ",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances() + ",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: " + this.getSteps() + ",");
        }
        if (this.getBootstrapActions() != null) {
            sb.append("BootstrapActions: " + this.getBootstrapActions() + ",");
        }
        if (this.getSupportedProducts() != null) {
            sb.append("SupportedProducts: " + this.getSupportedProducts() + ",");
        }
        if (this.getNewSupportedProducts() != null) {
            sb.append("NewSupportedProducts: " + this.getNewSupportedProducts() + ",");
        }
        if (this.isVisibleToAllUsers() != null) {
            sb.append("VisibleToAllUsers: " + this.isVisibleToAllUsers() + ",");
        }
        if (this.getJobFlowRole() != null) {
            sb.append("JobFlowRole: " + this.getJobFlowRole() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getLogUri() == null ? 0 : this.getLogUri().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.getAmiVersion() == null ? 0 : this.getAmiVersion().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        hashCode = 31 * hashCode + (this.getBootstrapActions() == null ? 0 : this.getBootstrapActions().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedProducts() == null ? 0 : this.getSupportedProducts().hashCode());
        hashCode = 31 * hashCode + (this.getNewSupportedProducts() == null ? 0 : this.getNewSupportedProducts().hashCode());
        hashCode = 31 * hashCode + (this.isVisibleToAllUsers() == null ? 0 : this.isVisibleToAllUsers().hashCode());
        hashCode = 31 * hashCode + (this.getJobFlowRole() == null ? 0 : this.getJobFlowRole().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunJobFlowRequest)) {
            return false;
        }
        RunJobFlowRequest other = (RunJobFlowRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getLogUri() == null ^ this.getLogUri() == null) {
            return false;
        }
        if (other.getLogUri() != null && !other.getLogUri().equals(this.getLogUri())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        if (other.getAdditionalInfo() != null && !other.getAdditionalInfo().equals(this.getAdditionalInfo())) {
            return false;
        }
        if (other.getAmiVersion() == null ^ this.getAmiVersion() == null) {
            return false;
        }
        if (other.getAmiVersion() != null && !other.getAmiVersion().equals(this.getAmiVersion())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !other.getSteps().equals(this.getSteps())) {
            return false;
        }
        if (other.getBootstrapActions() == null ^ this.getBootstrapActions() == null) {
            return false;
        }
        if (other.getBootstrapActions() != null && !other.getBootstrapActions().equals(this.getBootstrapActions())) {
            return false;
        }
        if (other.getSupportedProducts() == null ^ this.getSupportedProducts() == null) {
            return false;
        }
        if (other.getSupportedProducts() != null && !other.getSupportedProducts().equals(this.getSupportedProducts())) {
            return false;
        }
        if (other.getNewSupportedProducts() == null ^ this.getNewSupportedProducts() == null) {
            return false;
        }
        if (other.getNewSupportedProducts() != null && !other.getNewSupportedProducts().equals(this.getNewSupportedProducts())) {
            return false;
        }
        if (other.isVisibleToAllUsers() == null ^ this.isVisibleToAllUsers() == null) {
            return false;
        }
        if (other.isVisibleToAllUsers() != null && !other.isVisibleToAllUsers().equals(this.isVisibleToAllUsers())) {
            return false;
        }
        if (other.getJobFlowRole() == null ^ this.getJobFlowRole() == null) {
            return false;
        }
        if (other.getJobFlowRole() != null && !other.getJobFlowRole().equals(this.getJobFlowRole())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }
}

