/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elastictranscoder.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRoleRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String role;
    private String inputBucket;
    private String outputBucket;
    private ListWithAutoConstructFlag<String> topics;

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public TestRoleRequest withRole(String role) {
        this.role = role;
        return this;
    }

    public String getInputBucket() {
        return this.inputBucket;
    }

    public void setInputBucket(String inputBucket) {
        this.inputBucket = inputBucket;
    }

    public TestRoleRequest withInputBucket(String inputBucket) {
        this.inputBucket = inputBucket;
        return this;
    }

    public String getOutputBucket() {
        return this.outputBucket;
    }

    public void setOutputBucket(String outputBucket) {
        this.outputBucket = outputBucket;
    }

    public TestRoleRequest withOutputBucket(String outputBucket) {
        this.outputBucket = outputBucket;
        return this;
    }

    public List<String> getTopics() {
        if (this.topics == null) {
            this.topics = new ListWithAutoConstructFlag();
            this.topics.setAutoConstruct(true);
        }
        return this.topics;
    }

    public void setTopics(Collection<String> topics) {
        if (topics == null) {
            this.topics = null;
            return;
        }
        ListWithAutoConstructFlag topicsCopy = new ListWithAutoConstructFlag(topics.size());
        topicsCopy.addAll(topics);
        this.topics = topicsCopy;
    }

    public TestRoleRequest withTopics(String ... topics) {
        if (this.getTopics() == null) {
            this.setTopics(new ArrayList<String>(topics.length));
        }
        for (String value : topics) {
            this.getTopics().add(value);
        }
        return this;
    }

    public TestRoleRequest withTopics(Collection<String> topics) {
        if (topics == null) {
            this.topics = null;
        } else {
            ListWithAutoConstructFlag topicsCopy = new ListWithAutoConstructFlag(topics.size());
            topicsCopy.addAll(topics);
            this.topics = topicsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRole() != null) {
            sb.append("Role: " + this.getRole() + ",");
        }
        if (this.getInputBucket() != null) {
            sb.append("InputBucket: " + this.getInputBucket() + ",");
        }
        if (this.getOutputBucket() != null) {
            sb.append("OutputBucket: " + this.getOutputBucket() + ",");
        }
        if (this.getTopics() != null) {
            sb.append("Topics: " + this.getTopics());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getInputBucket() == null ? 0 : this.getInputBucket().hashCode());
        hashCode = 31 * hashCode + (this.getOutputBucket() == null ? 0 : this.getOutputBucket().hashCode());
        hashCode = 31 * hashCode + (this.getTopics() == null ? 0 : this.getTopics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRoleRequest)) {
            return false;
        }
        TestRoleRequest other = (TestRoleRequest)obj;
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getInputBucket() == null ^ this.getInputBucket() == null) {
            return false;
        }
        if (other.getInputBucket() != null && !other.getInputBucket().equals(this.getInputBucket())) {
            return false;
        }
        if (other.getOutputBucket() == null ^ this.getOutputBucket() == null) {
            return false;
        }
        if (other.getOutputBucket() != null && !other.getOutputBucket().equals(this.getOutputBucket())) {
            return false;
        }
        if (other.getTopics() == null ^ this.getTopics() == null) {
            return false;
        }
        return other.getTopics() == null || other.getTopics().equals(this.getTopics());
    }
}

