/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.rds.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.rds.model.AddTagsToResourceRequest;
import com.cloudera.com.amazonaws.services.rds.model.Tag;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddTagsToResourceRequestMarshaller
implements Marshaller<Request<AddTagsToResourceRequest>, AddTagsToResourceRequest> {
    @Override
    public Request<AddTagsToResourceRequest> marshall(AddTagsToResourceRequest addTagsToResourceRequest) {
        if (addTagsToResourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddTagsToResourceRequest> request = new DefaultRequest<AddTagsToResourceRequest>(addTagsToResourceRequest, "AmazonRDS");
        request.addParameter("Action", "AddTagsToResource");
        request.addParameter("Version", "2013-09-09");
        if (addTagsToResourceRequest.getResourceName() != null) {
            request.addParameter("ResourceName", StringUtils.fromString(addTagsToResourceRequest.getResourceName()));
        }
        List<Tag> tagsList = addTagsToResourceRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

