/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.rds.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest;
import com.cloudera.com.amazonaws.services.rds.model.Tag;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDBSubnetGroupRequestMarshaller
implements Marshaller<Request<CreateDBSubnetGroupRequest>, CreateDBSubnetGroupRequest> {
    @Override
    public Request<CreateDBSubnetGroupRequest> marshall(CreateDBSubnetGroupRequest createDBSubnetGroupRequest) {
        if (createDBSubnetGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDBSubnetGroupRequest> request = new DefaultRequest<CreateDBSubnetGroupRequest>(createDBSubnetGroupRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBSubnetGroup");
        request.addParameter("Version", "2013-09-09");
        if (createDBSubnetGroupRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString(createDBSubnetGroupRequest.getDBSubnetGroupName()));
        }
        if (createDBSubnetGroupRequest.getDBSubnetGroupDescription() != null) {
            request.addParameter("DBSubnetGroupDescription", StringUtils.fromString(createDBSubnetGroupRequest.getDBSubnetGroupDescription()));
        }
        List<String> subnetIdsList = createDBSubnetGroupRequest.getSubnetIds();
        int subnetIdsListIndex = 1;
        for (String subnetIdsListValue : subnetIdsList) {
            if (subnetIdsListValue != null) {
                request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringUtils.fromString(subnetIdsListValue));
            }
            ++subnetIdsListIndex;
        }
        List<Tag> tagsList = createDBSubnetGroupRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

