/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.s3.internal;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.auth.AWS4Signer;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSSessionCredentials;
import com.cloudera.com.amazonaws.auth.AnonymousAWSCredentials;
import com.cloudera.com.amazonaws.auth.AwsChunkedEncodingInputStream;
import com.cloudera.com.amazonaws.auth.Presigner;
import com.cloudera.com.amazonaws.services.s3.AmazonS3Client;
import com.cloudera.com.amazonaws.services.s3.internal.Constants;
import com.cloudera.com.amazonaws.services.s3.internal.RepeatableInputStream;
import com.cloudera.com.amazonaws.services.s3.model.PutObjectRequest;
import com.cloudera.com.amazonaws.services.s3.model.UploadPartRequest;
import com.cloudera.com.amazonaws.util.BinaryUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSS3V4Signer
extends AWS4Signer
implements Presigner {
    private static Log clientLog = LogFactory.getLog(AmazonS3Client.class);
    private static final long MAX_EXPIRATION_TIME_IN_SECONDS = 604800L;

    public AWSS3V4Signer() {
        super(false);
    }

    @Override
    public void presignRequest(Request<?> request, AWSCredentials credentials, Date expiration) {
        this.addHostHeader(request);
        if (credentials instanceof AnonymousAWSCredentials) {
            return;
        }
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)sanitizedCredentials);
            request.addParameter("x-amz-security-token", ((AWSSessionCredentials)sanitizedCredentials).getSessionToken());
        }
        long dateMilli = this.getDateFromRequest(request);
        String dateStamp = this.getDateStamp(dateMilli);
        String scope = this.getScope(request, dateStamp);
        String signingCredentials = sanitizedCredentials.getAWSAccessKeyId() + "/" + scope;
        long expirationInSeconds = (expiration.getTime() - System.currentTimeMillis()) / 1000L;
        if (expirationInSeconds > 604800L) {
            throw new AmazonClientException("Requests that are pre-signed by SigV4 algorithm are valid for at most 7 days. The expiration date set on the current request [" + this.getTimeStamp(expiration.getTime()) + "] has exceeded this limit.");
        }
        long now = System.currentTimeMillis();
        String timeStamp = this.getTimeStamp(now);
        request.addParameter("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        request.addParameter("X-Amz-Date", timeStamp);
        request.addParameter("X-Amz-SignedHeaders", this.getSignedHeadersString(request));
        request.addParameter("X-Amz-Expires", Long.toString(expirationInSeconds));
        request.addParameter("X-Amz-Credential", signingCredentials);
        String contentSha256 = "UNSIGNED-PAYLOAD";
        AWS4Signer.HeaderSigningResult headerSigningResult = this.computeSignature(request, dateStamp, timeStamp, "AWS4-HMAC-SHA256", contentSha256, sanitizedCredentials);
        request.addParameter("X-Amz-Signature", BinaryUtils.toHex(headerSigningResult.getSignature()));
    }

    @Override
    protected void processRequestPayload(Request<?> request, AWS4Signer.HeaderSigningResult headerSigningResult) {
        if (AWSS3V4Signer.useChunkEncoding(request)) {
            InputStream payloadStream = request.getContent();
            String dateTime = headerSigningResult.getDateTime();
            String keyPath = headerSigningResult.getScope();
            byte[] kSigning = headerSigningResult.getKSigning();
            String signature = BinaryUtils.toHex(headerSigningResult.getSignature());
            AwsChunkedEncodingInputStream chunkEncodededStream = new AwsChunkedEncodingInputStream(payloadStream, kSigning, dateTime, keyPath, signature, this);
            request.setContent(chunkEncodededStream);
        }
    }

    @Override
    protected String calculateContentHash(Request<?> request) {
        request.addHeader("x-amz-content-sha256", "required");
        if (AWSS3V4Signer.useChunkEncoding(request)) {
            long originalContentLength;
            String contentSha256 = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
            if (request.getHeaders().containsKey("Content-Length")) {
                originalContentLength = Long.parseLong(request.getHeaders().get("Content-Length"));
            } else {
                try {
                    originalContentLength = AWSS3V4Signer.getContentLength(request);
                }
                catch (IOException e) {
                    throw new AmazonClientException("Cannot get the content-lenght of the request content.", e);
                }
            }
            request.addHeader("x-amz-decoded-content-length", Long.toString(originalContentLength));
            request.addHeader("Content-Length", Long.toString(AwsChunkedEncodingInputStream.calculateStreamContentLength(originalContentLength)));
            return contentSha256;
        }
        return super.calculateContentHash(request);
    }

    private static boolean useChunkEncoding(Request<?> request) {
        boolean chunkedEncodingEnabled = false;
        if (request.getOriginalRequest() instanceof PutObjectRequest || request.getOriginalRequest() instanceof UploadPartRequest) {
            chunkedEncodingEnabled = true;
        }
        return chunkedEncodingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getContentLength(Request<?> request) throws IOException {
        InputStream content = request.getContent();
        if (!content.markSupported()) {
            int streamBufferSize = Constants.getStreamBufferSize();
            content = new RepeatableInputStream(content, streamBufferSize);
            request.setContent(content);
        }
        long contentLength = 0L;
        byte[] tmp = new byte[4096];
        try {
            int read;
            content.mark(-1);
            while ((read = content.read(tmp)) != -1) {
                contentLength += (long)read;
            }
            content.reset();
        }
        finally {
            content.close();
        }
        return contentLength;
    }
}

