/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleemail.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.simpleemail.model.RawMessage;
import com.cloudera.com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendRawEmailRequestMarshaller
implements Marshaller<Request<SendRawEmailRequest>, SendRawEmailRequest> {
    @Override
    public Request<SendRawEmailRequest> marshall(SendRawEmailRequest sendRawEmailRequest) {
        if (sendRawEmailRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendRawEmailRequest> request = new DefaultRequest<SendRawEmailRequest>(sendRawEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendRawEmail");
        request.addParameter("Version", "2010-12-01");
        if (sendRawEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(sendRawEmailRequest.getSource()));
        }
        List<String> destinationsList = sendRawEmailRequest.getDestinations();
        int destinationsListIndex = 1;
        for (String destinationsListValue : destinationsList) {
            if (destinationsListValue != null) {
                request.addParameter("Destinations.member." + destinationsListIndex, StringUtils.fromString(destinationsListValue));
            }
            ++destinationsListIndex;
        }
        RawMessage rawMessageRawMessage = sendRawEmailRequest.getRawMessage();
        if (rawMessageRawMessage != null && rawMessageRawMessage.getData() != null) {
            request.addParameter("RawMessage.Data", StringUtils.fromByteBuffer(rawMessageRawMessage.getData()));
        }
        return request;
    }
}

