/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow;

import com.cloudera.com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinitionFactoryFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecisionTaskHandler;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskPoller;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.GenericWorkflowWorker;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousWorkflowWorker {
    private final DecisionTaskPoller poller;
    private final POJOWorkflowDefinitionFactoryFactory factoryFactory = new POJOWorkflowDefinitionFactoryFactory();

    public SynchronousWorkflowWorker() {
        this.poller = new DecisionTaskPoller();
        this.poller.setDecisionTaskHandler(new AsyncDecisionTaskHandler(this.factoryFactory));
    }

    public SynchronousWorkflowWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll) {
        this.poller = new DecisionTaskPoller(service, domain, taskListToPoll, new AsyncDecisionTaskHandler(this.factoryFactory));
    }

    public String getIdentity() {
        return this.poller.getIdentity();
    }

    public void setIdentity(String identity) {
        this.poller.setIdentity(identity);
    }

    public AmazonSimpleWorkflow getService() {
        return this.poller.getService();
    }

    public String getDomain() {
        return this.poller.getDomain();
    }

    public void setService(AmazonSimpleWorkflow service) {
        this.poller.setService(service);
    }

    public void setDomain(String domain) {
        this.poller.setDomain(domain);
    }

    public String getTaskListToPoll() {
        return this.poller.getTaskListToPoll();
    }

    public void setTaskListToPoll(String pollTaskList) {
        this.poller.setTaskListToPoll(pollTaskList);
    }

    public boolean pollAndProcessSingleDecisionTask() throws Exception {
        return this.poller.pollAndProcessSingleTask();
    }

    public void setConverter(DataConverter converter) {
        this.factoryFactory.setDataConverter(converter);
    }

    public Iterable<WorkflowType> getWorkflowTypesToRegister() {
        return this.factoryFactory.getWorkflowTypesToRegister();
    }

    public void addWorkflowImplementationType(Class<?> workflowImplementationType) throws InstantiationException, IllegalAccessException {
        this.factoryFactory.addWorkflowImplementationType(workflowImplementationType);
    }

    public void addWorkflowImplementationType(Class<?> workflowImplementationType, DataConverter converterOverride) throws InstantiationException, IllegalAccessException {
        this.factoryFactory.addWorkflowImplementationType(workflowImplementationType, converterOverride);
    }

    public void setWorkflowImplementationTypes(Collection<Class<?>> workflowImplementationTypes) throws InstantiationException, IllegalAccessException {
        this.factoryFactory.setWorkflowImplementationTypes(workflowImplementationTypes);
    }

    public Collection<Class<?>> getWorkflowImplementationTypes() {
        return this.factoryFactory.getWorkflowImplementationTypes();
    }

    public void registerTypesToPoll() throws Exception {
        GenericWorkflowWorker.registerWorkflowTypes(this.getService(), this.getDomain(), this.getTaskListToPoll(), this.factoryFactory);
    }
}

