/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.core;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.AsyncContextBase;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.AsyncParentContext;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.AsyncStackTrace;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.AsyncTaskInfo;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TryCatchFinallyContext
extends AsyncContextBase {
    private List<AsyncContextBase> heirs = new ArrayList<AsyncContextBase>();
    private int nonDaemonHeirsCount;
    private Executor executor;
    private TryCatchFinally.State state = TryCatchFinally.State.CREATED;
    private Throwable failure;
    private boolean canceled;
    private boolean executed;
    private boolean daemondCausedCancellation;
    private final TryCatchFinally tryCatchFinally;
    private final String parentTaskMethodName;

    TryCatchFinallyContext(TryCatchFinally tryCatchFinally, Boolean daemon, String parentTaskMethodName, int skipStackLines, Promise<?>[] waitFor) {
        super(daemon, waitFor, skipStackLines);
        this.tryCatchFinally = tryCatchFinally;
        this.executor = this.parent.getExecutor();
        this.parentTaskMethodName = parentTaskMethodName;
    }

    TryCatchFinallyContext(AsyncParentContext parent, TryCatchFinally tryCatchFinally, Boolean daemon, String parentTaskMethodName, int skipStackLines, Promise<?>[] waitFor) {
        super(parent, daemon, waitFor, skipStackLines);
        this.tryCatchFinally = tryCatchFinally;
        this.executor = parent.getExecutor();
        this.parentTaskMethodName = parentTaskMethodName;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void add(final AsyncContextBase async, Promise<?> waitFor) {
        this.checkClosed();
        this.heirs.add(async);
        if (!async.isDaemon()) {
            ++this.nonDaemonHeirsCount;
        }
        if (waitFor == null) {
            this.executor.execute(async);
        } else {
            waitFor.addCallback(new Runnable(){

                public void run() {
                    TryCatchFinallyContext.this.executor.execute(async);
                }
            });
        }
    }

    private void checkClosed() {
        if (this.state == TryCatchFinally.State.CLOSED) {
            throw new IllegalStateException(this.state.toString());
        }
    }

    @Override
    public void cancel(Throwable cause) {
        if (this.state == TryCatchFinally.State.CREATED) {
            assert (this.heirs.size() == 0);
            this.state = TryCatchFinally.State.CLOSED;
            this.parent.remove(this);
            return;
        }
        if (this.failure == null) {
            this.canceled = true;
            this.failure = new CancellationException();
            if (this.stackTrace != null) {
                this.failure.setStackTrace(this.stackTrace.getStackTrace());
            }
            this.failure.initCause(cause);
            if (this.state == TryCatchFinally.State.TRYING) {
                this.cancelHeirs();
            }
        }
    }

    public boolean isCancelRequested() {
        return this.canceled;
    }

    @Override
    public void remove(AsyncContextBase async) {
        this.checkClosed();
        this.heirs.remove(async);
        if (!async.isDaemon()) {
            --this.nonDaemonHeirsCount;
            assert (this.nonDaemonHeirsCount >= 0);
        }
        this.updateState();
    }

    @Override
    public void fail(AsyncContextBase async, Throwable e) {
        this.checkClosed();
        boolean cancellationException = e instanceof CancellationException;
        if (!cancellationException || this.failure == null && !this.daemondCausedCancellation) {
            this.failure = e;
        }
        boolean removed = this.heirs.remove(async);
        assert (removed);
        if (!async.isDaemon()) {
            --this.nonDaemonHeirsCount;
            assert (this.nonDaemonHeirsCount >= 0);
        }
        this.cancelHeirs();
        this.updateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.state == TryCatchFinally.State.CLOSED) {
            return;
        }
        if (this.state == TryCatchFinally.State.CREATED) {
            this.state = TryCatchFinally.State.TRYING;
        }
        TryCatchFinallyContext.setCurrent(this);
        Throwable f = this.failure;
        try {
            switch (this.state) {
                case TRYING: {
                    if (this.canceled) {
                        return;
                    }
                    this.tryCatchFinally.doTry();
                    return;
                }
                case CATCHING: {
                    this.failure = null;
                    this.tryCatchFinally.doCatch(f);
                    return;
                }
                case FINALIZING: {
                    this.tryCatchFinally.doFinally();
                    return;
                }
            }
            return;
        }
        catch (Throwable e) {
            if (this.stackTrace != null && e != f) {
                AsyncStackTrace merged = new AsyncStackTrace(this.stackTrace, e.getStackTrace(), 0);
                merged.setStartFrom(this.getParentTaskMethodName());
                e.setStackTrace(merged.getStackTrace());
            }
            this.failure = e;
            this.cancelHeirs();
            return;
        }
        finally {
            TryCatchFinallyContext.setCurrent(null);
            this.executed = true;
            this.updateState();
        }
    }

    private void cancelHeirs() {
        ArrayList<AsyncContextBase> toCancel = new ArrayList<AsyncContextBase>(this.heirs);
        for (AsyncContextBase heir : toCancel) {
            heir.cancel(this.failure);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateState() {
        if (this.state == TryCatchFinally.State.CLOSED || !this.executed) {
            return;
        }
        if (this.nonDaemonHeirsCount != 0) return;
        if (this.heirs.isEmpty()) {
            if (this.state == TryCatchFinally.State.TRYING) {
                if (this.failure == null) {
                    this.state = TryCatchFinally.State.FINALIZING;
                    this.execute();
                    return;
                } else {
                    this.state = TryCatchFinally.State.CATCHING;
                    this.execute();
                }
                return;
            } else if (this.state == TryCatchFinally.State.CATCHING) {
                this.state = TryCatchFinally.State.FINALIZING;
                this.execute();
                return;
            } else {
                if (this.state != TryCatchFinally.State.FINALIZING) throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
                assert (this.state != TryCatchFinally.State.CLOSED);
                this.state = TryCatchFinally.State.CLOSED;
                if (this.failure == null) {
                    this.parent.remove(this);
                    return;
                } else {
                    this.parent.fail(this, this.failure);
                }
            }
            return;
        } else {
            if (this.failure == null) {
                this.daemondCausedCancellation = true;
            }
            this.cancelHeirs();
        }
    }

    private void execute() {
        this.executed = false;
        this.executor.execute(this);
    }

    @Override
    protected void getAsynchronousStackTraceDump(List<AsyncTaskInfo> result) {
        if (this.heirs.size() == 0) {
            result.add(this.getTaskInfo());
        } else {
            for (AsyncContextBase heir : this.heirs) {
                heir.getAsynchronousStackTraceDump(result);
            }
        }
    }

    @Override
    public boolean isRethrown(Throwable e) {
        return e == this.failure;
    }

    @Override
    public AsyncParentContext getCurrentTryCatchFinallyContext() {
        return this;
    }

    @Override
    public boolean getDaemonFlagForHeir() {
        return false;
    }

    @Override
    public String getParentTaskMethodName() {
        if (this.parentTaskMethodName != null) {
            return this.parentTaskMethodName;
        }
        if (this.state == TryCatchFinally.State.TRYING) {
            return "doTry";
        }
        if (this.state == TryCatchFinally.State.CATCHING) {
            return "doCatch";
        }
        if (this.state == TryCatchFinally.State.FINALIZING) {
            return "doFinally";
        }
        return null;
    }

    public TryCatchFinally.State getState() {
        return this.state;
    }

    public String toString() {
        if (this.stackTrace != null) {
            return this.stackTrace.toString();
        }
        return super.toString();
    }
}

