/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.junit.spring;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.junit.WorkflowTestBase;
import java.util.List;
import org.junit.Test;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowSpringJUnit4ClassRunner
extends SpringJUnit4ClassRunner {
    private WorkflowTestBase workflowTestRule;
    private long timeout;
    private Class<? extends Throwable> expectedException;

    public FlowSpringJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        Test annotation = (Test)method.getAnnotation(Test.class);
        long timeout = annotation.timeout();
        if (timeout > 0L) {
            long springTimeout = this.getSpringTimeout(method);
            if (this.workflowTestRule != null && springTimeout == 0L) {
                this.workflowTestRule.setTestTimeoutActualTimeMilliseconds(timeout);
            }
        }
        return next;
    }

    protected List<MethodRule> rules(Object test) {
        List result = super.rules(test);
        for (MethodRule methodRule : result) {
            if (!WorkflowTestBase.class.isAssignableFrom(methodRule.getClass())) continue;
            this.workflowTestRule = (WorkflowTestBase)methodRule;
            this.workflowTestRule.setFlowTestRunner(true);
            if (this.timeout > 0L) {
                this.workflowTestRule.setTestTimeoutActualTimeMilliseconds(this.timeout);
            }
            if (this.expectedException == null) continue;
            this.workflowTestRule.setExpectedException(this.expectedException);
        }
        return result;
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod method, Object test, Statement next) {
        Test annotation = (Test)method.getAnnotation(Test.class);
        Class expected = annotation.expected();
        if (expected != Test.None.class) {
            this.expectedException = expected;
            if (this.workflowTestRule != null) {
                this.workflowTestRule.setExpectedException(this.expectedException);
            }
        }
        return next;
    }
}

