/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo.MethodConverterPair;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinition;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowImplementationFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.CurrentDecisionContext;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class POJOWorkflowDefinitionFactory
extends WorkflowDefinitionFactory {
    private final DataConverter converter = new JsonDataConverter();
    private final WorkflowType workflowType;
    private final WorkflowTypeRegistrationOptions registrationOptions;
    private final POJOWorkflowImplementationFactory implementationFactory;
    private final MethodConverterPair workflowImplementationMethod;
    private final MethodConverterPair getStateMethod;
    private final Map<String, MethodConverterPair> signals;

    public POJOWorkflowDefinitionFactory(POJOWorkflowImplementationFactory implementationFactory, WorkflowType workflowType, WorkflowTypeRegistrationOptions registrationOptions, MethodConverterPair workflowImplementationMethod, Map<String, MethodConverterPair> signals, MethodConverterPair getStateMethod) {
        this.implementationFactory = implementationFactory;
        this.workflowType = workflowType;
        this.registrationOptions = registrationOptions;
        this.workflowImplementationMethod = workflowImplementationMethod;
        this.signals = signals;
        this.getStateMethod = getStateMethod;
    }

    @Override
    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    @Override
    public WorkflowTypeRegistrationOptions getWorkflowRegistrationOptions() {
        return this.registrationOptions;
    }

    @Override
    public WorkflowDefinition getWorkflowDefinition(DecisionContext context) throws Exception {
        if (this.implementationFactory == null) {
            return null;
        }
        CurrentDecisionContext.set(context);
        Object workflowDefinitionObject = this.implementationFactory.newInstance(context);
        return new POJOWorkflowDefinition(workflowDefinitionObject, this.workflowImplementationMethod, this.signals, this.getStateMethod, this.converter, context);
    }

    @Override
    public void deleteWorkflowDefinition(WorkflowDefinition instance) {
        POJOWorkflowDefinition definition = (POJOWorkflowDefinition)instance;
        this.implementationFactory.deleteInstance(definition.getImplementationInstance());
        CurrentDecisionContext.unset();
    }
}

