/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.annotations.Execute;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.annotations.GetState;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.annotations.NullDataConverter;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.annotations.Signal;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.annotations.SkipTypeRegistration;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.annotations.Workflow;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.annotations.WorkflowRegistrationOptions;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo.MethodConverterPair;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinitionFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowImplementationFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POJOWorkflowDefinitionFactoryFactory
extends WorkflowDefinitionFactoryFactory {
    private DataConverter converter = new JsonDataConverter();
    private List<WorkflowType> workflowTypesToRegister = new ArrayList<WorkflowType>();
    private Map<WorkflowType, WorkflowDefinitionFactory> factories = new HashMap<WorkflowType, WorkflowDefinitionFactory>();
    private final Collection<Class<?>> workflowImplementationTypes = new ArrayList();

    public DataConverter getDataConverter() {
        return this.converter;
    }

    public void setDataConverter(DataConverter converter) {
        this.converter = converter;
    }

    @Override
    public WorkflowDefinitionFactory getWorkflowDefinitionFactory(WorkflowType workflowType) {
        return this.factories.get(workflowType);
    }

    @Override
    public Iterable<WorkflowType> getWorkflowTypesToRegister() {
        return this.workflowTypesToRegister;
    }

    public void addWorkflowImplementationType(Class<?> workflowImplementationType) throws InstantiationException, IllegalAccessException {
        this.addWorkflowImplementationType(workflowImplementationType, null);
    }

    public void addWorkflowImplementationType(Class<?> workflowImplementationType, DataConverter converterOverride) throws InstantiationException, IllegalAccessException {
        if (workflowImplementationType.isInterface()) {
            throw new IllegalArgumentException(workflowImplementationType + " has to be a instantiatable class");
        }
        HashSet implementedInterfaces = new HashSet();
        this.getImplementedInterfacesAnnotatedWithWorkflow(workflowImplementationType, implementedInterfaces);
        if (implementedInterfaces.size() == 0) {
            throw new IllegalArgumentException("Workflow definition does not implement any @Workflow interface. " + workflowImplementationType);
        }
        for (Class clazz : implementedInterfaces) {
            this.addWorkflowType(clazz, workflowImplementationType, converterOverride);
        }
    }

    public void setWorkflowImplementationTypes(Collection<Class<?>> workflowImplementationTypes) throws InstantiationException, IllegalAccessException {
        for (Class<?> type : workflowImplementationTypes) {
            this.addWorkflowImplementationType(type);
        }
    }

    public Collection<Class<?>> getWorkflowImplementationTypes() {
        return this.workflowImplementationTypes;
    }

    private void addWorkflowType(Class<?> interfaze, Class<?> workflowImplementationType, DataConverter converterOverride) throws InstantiationException, IllegalAccessException {
        Workflow workflowAnnotation = interfaze.getAnnotation(Workflow.class);
        String interfaceName = interfaze.getSimpleName();
        MethodConverterPair workflowImplementationMethod = null;
        MethodConverterPair getStateMethod = null;
        WorkflowType workflowType = null;
        WorkflowTypeRegistrationOptions registrationOptions = null;
        HashMap<String, MethodConverterPair> signals = new HashMap<String, MethodConverterPair>();
        for (Method method : interfaze.getMethods()) {
            DataConverter converter;
            if (method.getDeclaringClass().getAnnotation(Workflow.class) == null) continue;
            Execute executeAnnotation = method.getAnnotation(Execute.class);
            Signal signalAnnotation = method.getAnnotation(Signal.class);
            GetState getStateAnnotation = method.getAnnotation(GetState.class);
            this.checkAnnotationUniqueness(method, executeAnnotation, signalAnnotation, getStateAnnotation);
            if (executeAnnotation != null) {
                if (workflowImplementationMethod != null) {
                    throw new IllegalArgumentException("Interface annotated with @Workflow is allowed to have only one method annotated with @Execute. Found " + POJOWorkflowDefinitionFactoryFactory.getMethodFullName(workflowImplementationMethod.getMethod()) + " and " + POJOWorkflowDefinitionFactoryFactory.getMethodFullName(method));
                }
                if (!method.getReturnType().equals(Void.TYPE) && !Promise.class.isAssignableFrom(method.getReturnType())) {
                    throw new IllegalArgumentException("Workflow implementation method annotated with @Execute can return only Promise or void: " + POJOWorkflowDefinitionFactoryFactory.getMethodFullName(method));
                }
                if (!method.getDeclaringClass().equals(interfaze)) {
                    throw new IllegalArgumentException("Interface " + interfaze.getName() + " cannot inherit workflow implementation method annotated with @Execute: " + POJOWorkflowDefinitionFactoryFactory.getMethodFullName(method));
                }
                converter = this.createConverter(workflowAnnotation.dataConverter(), converterOverride);
                workflowImplementationMethod = new MethodConverterPair(method, converter);
                workflowType = this.getWorkflowType(interfaceName, method, executeAnnotation);
                WorkflowRegistrationOptions registrationOptionsAnnotation = interfaze.getAnnotation(WorkflowRegistrationOptions.class);
                SkipTypeRegistration skipRegistrationAnnotation = interfaze.getAnnotation(SkipTypeRegistration.class);
                if (skipRegistrationAnnotation == null) {
                    if (registrationOptionsAnnotation == null) {
                        throw new IllegalArgumentException("@WorkflowRegistrationOptions is required for the interface that contains method annotated with @Execute");
                    }
                    registrationOptions = this.createRegistrationOptions(registrationOptionsAnnotation);
                } else if (registrationOptionsAnnotation != null) {
                    throw new IllegalArgumentException("@WorkflowRegistrationOptions is not allowed for the interface annotated with @SkipTypeRegistration.");
                }
            }
            if (signalAnnotation != null) {
                String signalName = signalAnnotation.name();
                if (signalName == null || signalName.isEmpty()) {
                    signalName = method.getName();
                }
                DataConverter signalConverter = this.createConverter(workflowAnnotation.dataConverter(), converterOverride);
                signals.put(signalName, new MethodConverterPair(method, signalConverter));
            }
            if (getStateAnnotation == null) continue;
            if (getStateMethod != null) {
                throw new IllegalArgumentException("Interface annotated with @Workflow is allowed to have only one method annotated with @GetState. Found " + POJOWorkflowDefinitionFactoryFactory.getMethodFullName(getStateMethod.getMethod()) + " and " + POJOWorkflowDefinitionFactoryFactory.getMethodFullName(method));
            }
            if (method.getReturnType().equals(Void.TYPE) || Promise.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Workflow method annotated with @GetState cannot have void or Promise return type: " + POJOWorkflowDefinitionFactoryFactory.getMethodFullName(method));
            }
            converter = this.createConverter(workflowAnnotation.dataConverter(), converterOverride);
            getStateMethod = new MethodConverterPair(method, converter);
        }
        if (workflowImplementationMethod == null) {
            throw new IllegalArgumentException("Workflow definition does not implement any method annotated with @Execute. " + workflowImplementationType);
        }
        POJOWorkflowImplementationFactory implementationFactory = this.getImplementationFactory(workflowImplementationType, interfaze, workflowType);
        POJOWorkflowDefinitionFactory factory = new POJOWorkflowDefinitionFactory(implementationFactory, workflowType, registrationOptions, workflowImplementationMethod, signals, getStateMethod);
        this.factories.put(workflowType, factory);
        this.workflowImplementationTypes.add(workflowImplementationType);
        if (((WorkflowDefinitionFactory)factory).getWorkflowRegistrationOptions() != null) {
            this.workflowTypesToRegister.add(workflowType);
        }
    }

    private void checkAnnotationUniqueness(Method method, Object ... annotations) {
        ArrayList<Object> notNullOnes = new ArrayList<Object>();
        for (Object annotation : annotations) {
            if (annotation == null) continue;
            notNullOnes.add(annotation);
        }
        if (notNullOnes.size() > 1) {
            throw new IllegalArgumentException("Method " + method.getName() + " is annotated with both " + notNullOnes);
        }
    }

    protected POJOWorkflowImplementationFactory getImplementationFactory(final Class<?> workflowImplementationType, Class<?> workflowInteface, WorkflowType workflowType) {
        return new POJOWorkflowImplementationFactory(){

            public Object newInstance(DecisionContext decisionContext) throws Exception {
                return workflowImplementationType.newInstance();
            }

            public void deleteInstance(Object instance) {
            }
        };
    }

    private void getImplementedInterfacesAnnotatedWithWorkflow(Class<?> workflowImplementationType, Set<Class<?>> implementedInterfaces) {
        Class<?>[] interfaces;
        Class<?> superClass = workflowImplementationType.getSuperclass();
        if (superClass != null) {
            this.getImplementedInterfacesAnnotatedWithWorkflow(superClass, implementedInterfaces);
        }
        for (Class<?> i : interfaces = workflowImplementationType.getInterfaces()) {
            if (i.getAnnotation(Workflow.class) != null && !implementedInterfaces.contains(i)) {
                boolean skipAdd = this.removeSuperInterfaces(i, implementedInterfaces);
                if (skipAdd) continue;
                implementedInterfaces.add(i);
                continue;
            }
            this.getImplementedInterfacesAnnotatedWithWorkflow(i, implementedInterfaces);
        }
    }

    private boolean removeSuperInterfaces(Class<?> interfaceToAdd, Set<Class<?>> implementedInterfaces) {
        boolean skipAdd = false;
        ArrayList interfacesToRemove = new ArrayList();
        for (Class<?> clazz : implementedInterfaces) {
            if (clazz.isAssignableFrom(interfaceToAdd)) {
                interfacesToRemove.add(clazz);
            }
            if (!interfaceToAdd.isAssignableFrom(clazz)) continue;
            skipAdd = true;
        }
        for (Class<Object> clazz : interfacesToRemove) {
            implementedInterfaces.remove(clazz);
        }
        return skipAdd;
    }

    private static String getMethodFullName(Method m) {
        return m.getDeclaringClass().getName() + "." + m.getName();
    }

    private DataConverter createConverter(Class<? extends DataConverter> converterTypeFromAnnotation, DataConverter converterOverride) throws InstantiationException, IllegalAccessException {
        if (converterOverride != null) {
            return converterOverride;
        }
        if (converterTypeFromAnnotation == null || converterTypeFromAnnotation.equals(NullDataConverter.class)) {
            return this.converter;
        }
        return converterTypeFromAnnotation.newInstance();
    }

    protected WorkflowType getWorkflowType(String interfaceName, Method method, Execute executeAnnotation) {
        assert (method != null);
        assert (executeAnnotation != null);
        WorkflowType workflowType = new WorkflowType();
        String workflowName = null;
        workflowName = executeAnnotation.name() != null && !executeAnnotation.name().isEmpty() ? executeAnnotation.name() : interfaceName + "." + method.getName();
        if (executeAnnotation.version().isEmpty()) {
            throw new IllegalArgumentException("Empty value of the required \"version\" parameter of the @Execute annotation found on " + POJOWorkflowDefinitionFactoryFactory.getMethodFullName(method));
        }
        workflowType.setName(workflowName);
        workflowType.setVersion(executeAnnotation.version());
        return workflowType;
    }

    protected WorkflowTypeRegistrationOptions createRegistrationOptions(WorkflowRegistrationOptions registrationOptionsAnnotation) {
        WorkflowTypeRegistrationOptions result = new WorkflowTypeRegistrationOptions();
        result.setDescription(POJOWorkflowDefinitionFactoryFactory.emptyStringToNull(registrationOptionsAnnotation.description()));
        result.setDefaultExecutionStartToCloseTimeoutSeconds(registrationOptionsAnnotation.defaultExecutionStartToCloseTimeoutSeconds());
        result.setDefaultTaskStartToCloseTimeoutSeconds(registrationOptionsAnnotation.defaultTaskStartToCloseTimeoutSeconds());
        String taskList = registrationOptionsAnnotation.defaultTaskList();
        if (!taskList.equals("USE_WORKER_TASK_LIST")) {
            result.setDefaultTaskList(taskList);
        }
        result.setDefaultChildPolicy(registrationOptionsAnnotation.defaultChildPolicy());
        return result;
    }

    private static String emptyStringToNull(String value) {
        if (value.length() == 0) {
            return null;
        }
        return value;
    }
}

